/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPFPKT2.C
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Tirza van Rijn
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1991/9/2
**
** DESCRIPTION: Packet filter for the online BEHOLDER
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFPKT2.C  $
** LOGINFO:     $Log:   I:/TIRZA/CPROG/BEHOLDER/APS/PKTCAPT/VCS/DPFPKT2.C_V  $
**              
**                 Rev 1.0   2 Sep 1991 15:26:54   tirza
**              Initial revision.
*************************************************************************/
#if !defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/TIRZA/CPROG/BEHOLDER/APS/PKTCAPT/VCS/DPFPKT.C_V   1.0   2 Sep 1991 15:26:54   tirza  $";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <power3.h>

#include <error.h>
#include <dp.h>
#include <dpu.h>
#include <bufm.h>
#include <dpfpkt.h>


#define P_PktF_start                (StartOf_FilterList[0])
#define N_PktF_start                (StartOf_FilterList[1])
#define P_StartF_start              (StartOf_FilterList[2])
#define N_StartF_start              (StartOf_FilterList[3])
#define P_StopF_start               (StartOf_FilterList[4])
#define N_StopF_start               (StartOf_FilterList[5])
#define DEFAULT_FILTERFILE_NAME     "default.fil"


DPHDRINFO EthHdrInfo = {            
    0,                              
    6,                              
    12,                             
    14,                             
    6,                              
    2                               
};
DPHDRINFO *hdrinfo = &EthHdrInfo;

typedef struct _FILTER {
    unsigned int FilterNo;
    int UseDestAddr;
    BYTE DestAddr [6];
    int UseSrcAddr;
    BYTE SrcAddr [6];
    int UsePktType;
    unsigned int PktTypeInt;
    BYTE PktType [2];
    int UseContents;
    int ContentsOff;
    int ContentsLen;
    BYTE *Contents;
    int UseDevNr;
    int DevNr;
    int UsePktSize;
    unsigned int PktSizeLL;
    unsigned int PktSizeUL;
    struct _FILTER *FNext;
} FILTER;

/* Function prototypes */
static int  ProcessEventPacket(DPEVENT Event);
static int  ReceivePkt(void);
static void Init(void);
static int  Start(void);
static void Stop(void);
static void Reset(void);
static int FilterPacket(FILTER *fp, DPBUF *frame);
static void ResetFilters(void);
static void DisposeFilterList(FILTER *fp);
int PwmFiltersMenu(int Element);
static void ReadFilterFile (void);
static void ReadFilterContents(void);
static void WriteFilterFile (void);
static int PwmFilterAction(int element);
static void EditFilter(unsigned FilterType);
static FILTER *AddFilter(unsigned FilterType);
static void DeleteFilter(unsigned FilterType);
static int PwmFilterVars(PWWIN *pFilterWin, int Action, int Elem);
static int PwmDestHostNameMenu(int Element);
static int PwmSrcHostNameMenu(int Element);
static int PwmProtocolMenu(int Element);
static void DisplayFilterNo(PWWIN *Win, FILTER *fp);
static void DisplayDestAddr(PWWIN *Win, FILTER *fp);
static void DisplaySrcAddr(PWWIN *Win, FILTER *fp);
static void DisplayPktType(PWWIN *Win, FILTER *fp);
static void DisplayContents(PWWIN *Win, FILTER *fp);
static void DisplayOffset(PWWIN *Win, FILTER *fp);
static void DisplayDevNo(PWWIN *Win, FILTER *fp);
static void DisplayPSLL(PWWIN *Win, FILTER *fp);
static void DisplayPSUL(PWWIN *Win, FILTER *fp);
static void EditDestAddr(FILTER **fpp);
static void EditSrcAddr(FILTER **fpp);
static void EditPktType(FILTER **fpp);
static void EditContents(FILTER **fpp);
static void EditOffset(FILTER **fpp);
static void EditDevNo(FILTER **fpp);
static void EditPSLL(FILTER **fpp);
static void EditPSUL(FILTER **fpp);
static void HostName2DestAddr(FILTER **fp, int index);
static void HostName2SrcAddr(FILTER **fp, int index);
static void Protocol2PktType(FILTER **fp, int index);
static void AddrStr2Addr(char *string, BYTE *array);
static void ContentsStr2Contents(char *string, BYTE *array);
static void Contents2ContentsStr(BYTE *array, char *string, int NrOfBytes);
static void PrintFilterStatus(void);


static FILTER *StartOf_FilterList[6] = {
    NULL,           /* P_PktF_start */
    NULL,           /* N_PktF_start */
    NULL,           /* P_StartF_start */
    NULL,           /* N_StartF_start */
    NULL,           /* P_StopF_start */
    NULL            /* N_StopF_start */
};
unsigned int NrOf_Filters[6] = {
    0,              /* NrOf_P_PktFs */
    0,              /* NrOf_P_PktFs */
    0,              /* NrOf_P_StartFs */
    0,              /* NrOf_N_StartFs */
    0,              /* NrOf_P_StopFs */
    0               /* NrOf_P_StopFs */
};
static char type[6][3] = {
    "+P",
    "-P",
    "+B",
    "-B",
    "+E",
    "-E"
};
DPFILT DpfPkt   = { "Pkt",   ProcessEventPacket,   0 };
static int r;
static int Filtering;
static int FilterStat;
static char FilterfileName[80];
static FILE *FilterFile;
static int FileElem;
static int FilterActionElem;
static int HostNameElem;
static int ProtocolMenuElem;
static int Element;
static int element;
static int Elem;
static PWWIN *pFilterWin;
static PWWIN *pTempWin;
static PWWIN *FilterStatusWin;
static FILTER *gfp;         /* Dirty programming because I can't pass these */
static unsigned FilterType; /* parameters to FilterAction and PwmFilterVars */
char *FiltersMenu[] = {
    "Read filter file",
    "Write filter file",
    "Positive packet filters",
    "Negative packet filters",
    "Positive start filters",
    "Negative start filters",
    "Positive stop filters",
    "Negative stop filters",
    NULL
};
static char *FilterAction[] = {
    "Add filter",
    "Edit filter",
    "Delete filter",
    NULL
};
static int NrOf_AddrDefs;
static KEY *adres_keys;
static DESC *adres_desc;
static char **HostNameMenu;
static int adres_defs_Xist = 0;
static int NrOf_ProtDefs;
static KEY *prot_keys;
static DESC *prot_desc;
static char **ProtocolMenu;
static int prot_defs_Xist = 0;
static int changed = 0;


static int ProcessEventPacket(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
        case DPE_RECEIVEPKT:  ret = ReceivePkt();       break;
        case DPE_INIT:              Init();             break;
        case DPE_START:             Start (); ret = r;  break;
        case DPE_STOP:              Stop();             break;
        case DPE_RESET:             Reset();            break;
    }
    return ret;
}

static int ReceivePkt()
{
    DPBUF *frame;
    int ret;
    FILTER *fp;

    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Starting..."); 
    frame = DpReceivePkt();

    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Filtering = %d", Filtering); 
    if (Filtering == 0)
    {
        if (P_StartF_start == NULL && N_StartF_start == NULL)
            Filtering = 1;
        else
        {
            fp = P_StartF_start;
            while ((Filtering == 0) && (fp != NULL))
            {
                Filtering = Filtering || FilterPacket(fp, frame);
                fp = fp->FNext;
            }
            if (Filtering == 0)
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass p-START-filter");
            else
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed p-START-filter");
            fp = N_StartF_start;
            while ((Filtering == 1) && (fp != NULL))
            {
                Filtering = Filtering && !(FilterPacket(fp, frame));
                fp = fp->FNext;
            }
            if (Filtering == 0)
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass n-START-filter");
            else
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed n-START-filter");
        }
        if (Filtering == 1)
            FilterStat = 1;
    }
    if (Filtering == 0)
        return (0);
    else
    {
        if (P_PktF_start == NULL && N_PktF_start == NULL)
            ret = 1;
        else
        {
            ret = 0;
            fp = P_PktF_start;
            while ((ret == 0) && (fp != NULL))
            {
                ret = ret || FilterPacket(fp, frame);
                fp = fp->FNext;
            }
            if (ret == 0)
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass p-PKT-filter");
            else
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed p-PKT-filter");
            fp = N_PktF_start;
            if (P_PktF_start == NULL)
                ret = 1;
            while ((ret == 1) && (fp != NULL))
            {
                ret = ret && !(FilterPacket(fp, frame));
                fp = fp->FNext;
            }
            if (ret == 0)
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass n-PKT-filter");
            else
                ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed n-PKT-filter");
            if (P_StopF_start == NULL && N_StopF_start == NULL)
                ;
            else
            {
                fp = P_StopF_start;
                while ((Filtering == 1) && (fp != NULL))
                {
                    Filtering = Filtering && !(FilterPacket(fp, frame));
                    fp = fp->FNext;
                }
                if (Filtering == 1)
                    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass p-STOP-filter");
                else
                    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed p-STOP-filter");
                fp = N_StopF_start;
                while ((Filtering == 0) && (fp != NULL))
                {
                    Filtering = Filtering || FilterPacket(fp, frame);
                    fp = fp->FNext;
                }
                if (Filtering == 1)
                    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet didn't pass n-STOP-filter");
                else
                {
                    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Packet passed n-STOP-filter");
                    Filtering  = 2;
                    FilterStat = 2;
                }
            }
        }
    }
/*    PacketsVisible = 1;
        if (!PacketsVisible)
            return; */
    if (changed)
        PrintFilterStatus();
    ERR_DEB(ERR_PCA, 2, "DPFPKT=ReceivePkt: Ended."); 
    return ret;
}

static void Init(void)
{
    int id, i;
    int adres_keys_Xist = 0;
    int adres_descs_Xist = 0;
    int prot_keys_Xist = 0;
    int prot_descs_Xist = 0;

    if (DpuIniInit("DP.INI") == 0)
    {
        id = DpuIniFindId("HDRADDR");
        if (id >= 0)
        {
            NrOf_AddrDefs = DpuIniCountDefs(id);
            if ((adres_keys = (KEY *)malloc(NrOf_AddrDefs*sizeof(KEY))) != NULL)
            {
                DpuIniGetKeys(id, adres_keys);
                adres_keys_Xist++;
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPFPKT=Init: Can't allocate adres_keys"); 
            if (((HostNameMenu = (char **)malloc((NrOf_AddrDefs+2)*sizeof(char *))) != NULL) &&
                ((adres_desc = (DESC *)malloc((NrOf_AddrDefs+1)*sizeof(DESC))) != NULL))
            {
                DpuIniGetDefs(id, adres_desc);
                strcpy(adres_desc[0], "Self define");
                for (i=0; i<NrOf_AddrDefs+1; i++)
                {
                    HostNameMenu[i] = adres_desc[i];
                }
                HostNameMenu[NrOf_AddrDefs+1] = NULL;
                adres_descs_Xist++;
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPFPKT=Init: Can't allocate adres_desc and/or HostNameMenu");
        }

        id = DpuIniFindId("HDRTYPE");
        if (id >= 0)
        {
            NrOf_ProtDefs = DpuIniCountDefs(id);
            if ((prot_keys = (KEY *)malloc(NrOf_ProtDefs*sizeof(KEY))) != NULL)
            {
                DpuIniGetKeys(id, prot_keys);
                prot_keys_Xist++;
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPFPKT=Init: Can't allocate prot_keys"); 
            if (((ProtocolMenu = (char **)malloc((NrOf_ProtDefs+2)*sizeof(char *))) != NULL) &&
                ((prot_desc = (DESC *)malloc((NrOf_ProtDefs+1)*sizeof(DESC))) != NULL))
            {
                DpuIniGetDefs(id, prot_desc);
                strcpy(prot_desc[0], "Self define");
                for (i=0; i<NrOf_ProtDefs+1; i++)
                {
                    ProtocolMenu[i] = prot_desc[i];
                }
                ProtocolMenu[NrOf_ProtDefs+1] = NULL;
                prot_descs_Xist++;
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPFPKT=Init: Can't allocate prot_desc and/or ProtocolMenu");
        }
        adres_defs_Xist = (adres_keys_Xist && adres_descs_Xist);
        prot_defs_Xist = (prot_keys_Xist && prot_descs_Xist);
    }
    else
        ERR_ERR(ERR_PCA, 1, "DPFPKT=Init: Can't open init file DP.INI");

    FilterStatusWin = pw_open (14, 1, 9, 78, "Filter Status", PWM_NOSHADE, PWW_NORMAL);
    pw_printfat (FilterStatusWin, -1, 0, "Ty#DestAddressSrcAddressProtocoOffsContentsDLen>Len<");
}

static int Start(void)
{
    ERR_DEB(ERR_PCA, 1, "DPFPKT=Start: Starting...");
    Filtering = 0;
    FilterStat = 0;
    strcpy(FilterfileName, DEFAULT_FILTERFILE_NAME);
    return 0;
}

static void Stop(void)
{
    ERR_DEB(ERR_PCA, 1, "DPFPKT=Stop: Starting...");
    ResetFilters();
    Filtering = 0;
    FilterStat = 3;
    strcpy(FilterfileName, DEFAULT_FILTERFILE_NAME);
}

static void Reset(void)
{
    ERR_DEB(ERR_PCA, 1, "DPFPKT=Reset: Starting...");
    ResetFilters();
    Filtering = 0;
    FilterStat = 0;
}

static int FilterPacket(FILTER *fp, DPBUF *frame)
{
  return(((!fp->UseDestAddr)  || (memcmp(frame->pBuf+hdrinfo->DestOff, fp->DestAddr, hdrinfo->AddrLen) == 0)) &&
         ((!fp->UseSrcAddr)   || (memcmp(frame->pBuf+hdrinfo->SrcOff,  fp->SrcAddr,  hdrinfo->AddrLen) == 0)) &&
         ((!fp->UsePktType)   || (memcmp(frame->pBuf+hdrinfo->TypOff,  fp->PktType,  hdrinfo->TypLen)  == 0)) &&
         ((!fp->UseContents)  || (memcmp(frame->pBuf+fp->ContentsOff, fp->Contents, fp->ContentsLen) == 0)) &&
         ((!fp->UseDevNr)     || (frame->Dev == fp->DevNr)) &&
         ((!fp->UsePktSize)   || (frame->Size >= fp->PktSizeLL && frame->Size <= fp->PktSizeUL)));
}

static void ResetFilters(void)
{
    int i;

    for (i=0; i<6; i++)
    {
        DisposeFilterList(StartOf_FilterList[i]);
        StartOf_FilterList[i] = NULL;
        NrOf_Filters[i] = 0;
    }
}

static void DisposeFilterList(FILTER *fp)
{
    if (fp != NULL)
        DisposeFilterList(fp->FNext);
    IPBufFree(fp->Contents);
    IPBufFree(fp);
}

int PwmFiltersMenu(int Element)
{
    switch (Element)
    {
        case 0: /* Read filter file */
            ReadFilterFile();
            break;
        case 1: /* Write filter file */
            WriteFilterFile();
            break;
        case 2: /* Positive packet filter */
            FilterType = 0;
            pw_menu(12, 16, 0, 0, "Positive packet filter", FilterAction, PwmFilterAction, &FilterActionElem);
            break;
        case 3: /* Negative packet filter */
            FilterType = 1;
            pw_menu(12, 16, 0, 0, "Negative packet filter", FilterAction, PwmFilterAction, &FilterActionElem);
            break;
        case 4: /* Positive start filter */
            FilterType = 2;
            pw_menu(12, 16, 0, 0, "Positive start filter", FilterAction, PwmFilterAction, &FilterActionElem);
            break;
        case 5: /* Negative start filter */
            FilterType = 3;
            pw_menu(12, 16, 0, 0, "Negative start filter", FilterAction, PwmFilterAction, &FilterActionElem);
            break;
        case 6: /* Positive stop filter */
            FilterType = 4;
            pw_menu(12, 16, 0, 0, "Positive stop filter", FilterAction, PwmFilterAction, &FilterActionElem);
            break;
        case 7: /* Negative stop filter */
            FilterType = 5;
            pw_menu(12, 16, 0, 0, "Negative stop filter", FilterAction, PwmFilterAction, &FilterActionElem);
    }
    return Element;
}

static void ReadFilterFile (void)
{
    int c;

    DpuGetFile("Filter file", "*.FIL", FilterfileName, &FileElem);
    if ((FilterFile = fopen(FilterfileName, "r")) != NULL)
    {
        while (!feof(FilterFile))                            
        {
            c = fgetc(FilterFile);
            {
                switch (c)
                {                                      
                    case ' ': /* blank */
                        break;
                    case '\n': /* CR-LF */
                        break;
                    case EOF: /* end-of-file */
                        break;
                    case '#':  /* comment */
                        while (((c = fgetc(FilterFile)) != EOF) && (c != '\n'))
                            ;  /* skip rest of line */
                        break;
                    case '+': /* start of positive filter definition */
                        c = fgetc(FilterFile);
                        switch (c)
                        {
                            case 'P': /* Positive packet filter */
                                FilterType = 0;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            case 'B': /* Positive start filter */
                                FilterType = 2;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            case 'E': /* Positive stop filter */
                                FilterType = 4;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            default:
                                pw_warning("Unknown filter type: %c (hex %x)", c, c);
                                break;
                        }
                        break;
                    case '-':  /* start of negative filter definition */
                        c = fgetc(FilterFile);
                        switch (c)
                        {
                            case 'P': /* Negative packet filter */
                                FilterType = 1;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            case 'B': /* Negative start filter */
                                FilterType = 3;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            case 'E': /* Negative stop filter */
                                FilterType = 5;
                                if ((gfp = AddFilter(FilterType)) != NULL)
                                    ReadFilterContents();
                                break;
                            default:
                                pw_warning("Unknown filter type: %c (hex %x)", c, c);
                                while (((c = fgetc(FilterFile)) != EOF) && (c != '\n'))
                                    ;  /* skip rest of line */
                                break;
                        }
                        break;
                    default:
                        pw_warning("Wrong start of line: %c (hex %x)", c, c);
                        while (((c = fgetc(FilterFile)) != EOF) && (c != '\n'))
                            ;  /* skip rest of line */
                        break;
                }
            }
        }
    }
    else 
        pw_warning("Can't open filter file %s", FilterfileName);
}

static void ReadFilterContents(void)
{
    int c;
    char string[3028];
    int i;

    while ((!feof(FilterFile)) && ((c = fgetc(FilterFile)) != '\n'))
    {
        switch (c)
        {
            case ' ': /* blank */
                break;
            case 'D': /* Destination address */
                if ((fscanf(FilterFile, "%02x:%02x:%02x:%02x:%02x:%02x",
                        &gfp->DestAddr[0], &gfp->DestAddr[1],
                        &gfp->DestAddr[2], &gfp->DestAddr[3],
                        &gfp->DestAddr[4], &gfp->DestAddr[5])) == 6)
                {
                    gfp->UseDestAddr = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong destination address definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'S': /* Source address */
                if ((fscanf(FilterFile, "%02x:%02x:%02x:%02x:%02x:%02x",
                        &gfp->SrcAddr[0], &gfp->SrcAddr[1],
                        &gfp->SrcAddr[2], &gfp->SrcAddr[3],
                        &gfp->SrcAddr[4], &gfp->SrcAddr[5])) == 6)
                {
                    gfp->UseSrcAddr = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong source address definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'P': /* Protocol Type */
                if ((fscanf(FilterFile, "%04x", &gfp->PktTypeInt)) == 1)
                {
                    gfp->PktType[0] = (BYTE) (gfp->PktTypeInt >> 8);
                    gfp->PktType[1] = (BYTE) (gfp->PktTypeInt & 0xff);
                    gfp->UsePktType = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong protocol type definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'C': /* Contents */
                i = 0;
                while ((c = fgetc(FilterFile)) != ' ')
                {
                    if (isxdigit(c))
                        string[i++] = (char)c;
                    else
                    {
                        pw_warning("Wrong contents definition");
                        while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                            ;  /* skip until next blank */
                    }
                }
                string[i] = '\0';
                gfp->ContentsLen = strlen(string)/2;
                if ((gfp->Contents = IPBufGet(gfp->ContentsLen * sizeof (BYTE))) != NULL)
                {
                    ContentsStr2Contents(string, gfp->Contents);
                    gfp->UseContents = 1;
                    if (!changed)
                        changed++;
                }
                break;
            case 'O': /* contents Offset */
                if ((fscanf(FilterFile, "%d", &gfp->ContentsOff)) == 1)
                    ;
                else
                {
                    pw_warning("Wrong contents offset definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'N': /* device Number */
                if ((fscanf(FilterFile, "%d", &gfp->PktTypeInt)) == 1)
                {
                    gfp->UseDevNr = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong device number definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'L': /* packet size Lower limit */
                if ((fscanf(FilterFile, "%d", &gfp->PktSizeLL)) == 1)
                {
                    gfp->UsePktSize = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong packet size lower limit definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            case 'U': /* packet size Upper limit */
                if ((fscanf(FilterFile, "%d", &gfp->PktSizeUL)) == 1)
                {
                    gfp->UsePktSize = 1;
                    if (!changed)
                        changed++;
                }
                else
                {
                    pw_warning("Wrong packet size upper limit definition");
                    while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                        ;  /* skip until next blank */
                }
                break;
            default:
                pw_warning("Unknown filter variable: %c (hex %x)", c, c);
                while (((c = fgetc(FilterFile)) != EOF) && (c != ' '))
                    ;  /* skip until next blank */
                break;
        }
    }
}

static void WriteFilterFile (void)
{
    FILTER *tfp;
    int i, j;

    pTempWin = pw_open(10, 12, 1, 52, "Filter file", PWM_DEFAULT, PWW_NORMAL);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, FilterfileName, 80, NULL, PWM_UPROMPT);
    pw_close(pTempWin);
    if ((FilterFile = fopen(FilterfileName, "w")) != NULL) 
    {
        for (i=0; i<6; i++)
        {
            tfp = StartOf_FilterList[i];
            while (tfp != NULL)
            {
                fprintf(FilterFile, "%02s", type[i]);
                if (tfp->UseDestAddr)
                    fprintf(FilterFile, " D%02x:%02x:%02x:%02x:%02x:%02x",
                        tfp->DestAddr[0], tfp->DestAddr[1],
                        tfp->DestAddr[2], tfp->DestAddr[3],
                        tfp->DestAddr[4], tfp->DestAddr[5]);
                if (tfp->UseSrcAddr)
                    fprintf(FilterFile, " S%02x:%02x:%02x:%02x:%02x:%02x",
                        tfp->SrcAddr[0], tfp->SrcAddr[1],
                        tfp->SrcAddr[2], tfp->SrcAddr[3],
                        tfp->SrcAddr[4], tfp->SrcAddr[5]);
                if (tfp->UsePktType)
                    fprintf(FilterFile, " P%04x", tfp->PktTypeInt);
                if (tfp->UseContents)
                {
                    fprintf(FilterFile, " C");
                    for (j=0; j<tfp->ContentsLen; j++)
                        fprintf(FilterFile, "%02x", tfp->Contents[j]);
                    fprintf(FilterFile, " O%d", tfp->ContentsOff);
                }
                if (tfp->UseDevNr)
                    fprintf(FilterFile, " N%d", tfp->DevNr);
                if (tfp->UsePktSize)
                {
                    fprintf(FilterFile, " L%d", tfp->PktSizeLL);
                    fprintf(FilterFile, " U%d", tfp->PktSizeUL);
                }
                tfp = tfp->FNext;
                fprintf(FilterFile, "\n");
            }
        }
        fclose(FilterFile);
    }
    else 
        pw_warning("Can't open filter file %s", FilterfileName);
}

static int PwmFilterAction(int element)
{
    switch (element)
    {
        case 0: /* Add filter */
            if ((gfp = AddFilter(FilterType)) != NULL);
                pw_select(14, 18, 0, 40, "Edit filter", PwmFilterVars, NULL);
            break;
        case 1: /* Edit filter */
            EditFilter(FilterType);
            break;
        case 2: /* Delete filter */
            DeleteFilter(FilterType);
            break;
    }
    return Element; 
}

static void EditFilter(unsigned FilterType)
{
    PWKEY key = 0;
    unsigned int *NrOfFilters, FilterNumber;

    gfp = StartOf_FilterList[FilterType];
    NrOfFilters = &NrOf_Filters[FilterType];
    key = pw_question("Enter filter number", "0123456789", PWW_DATA);
    if (key == PWK_ESC)
        FilterNumber = 1;               
    else
        FilterNumber = key - '0';
    if ((FilterNumber < 1) || (FilterNumber > (*NrOfFilters)))
    {
        pw_warning("Filter number out of range");
        return;
    }
    while ((gfp != NULL) && (gfp->FilterNo < FilterNumber))
        gfp = gfp->FNext;
    if (gfp->FilterNo == FilterNumber)
        pw_select(14, 18, 0, 40, "Edit filter", PwmFilterVars, NULL);
    else
    {
        pw_warning("Can't find filter number %d", FilterNumber);
        return;
    }
}

static FILTER *AddFilter(unsigned FilterType)
{
    FILTER **temp, *fp;
    unsigned int *NrOfFilters;

    temp = &StartOf_FilterList[FilterType];
    NrOfFilters = &NrOf_Filters[FilterType];
    if ((fp = IPBufGet(sizeof(FILTER))) != NULL)
    {
        fp->FilterNo = (*NrOfFilters)+1;
        fp->UseDestAddr = 0;
        fp->DestAddr[0] = 0x00;
        fp->UseSrcAddr = 0;
        fp->SrcAddr[0] = 0x00;
        fp->UsePktType = 0;
        fp->PktTypeInt = 0;
        fp->UseContents = 0;
        fp->ContentsOff = 0;
        fp->ContentsLen = 0;
        fp->Contents = NULL;
        fp->UseDevNr = 0;
        fp->DevNr = 0;
        fp->UsePktSize = 0;
        fp->PktSizeLL = 0;
        fp->PktSizeUL = 1514;
        fp->FNext = NULL;

        while ((*temp) != NULL)
            temp = &((*temp)->FNext);
        (*temp) = fp;
        (*NrOfFilters)++;
        if (!changed)
            changed++;
    }
    else
        pw_warning("Can't allocate new filter");
    return (fp);
}

static void DeleteFilter(unsigned FilterType)
{
    PWKEY key = 0;
    FILTER *q, *p;
    unsigned int *NrOfFilters, FilterNumber;

    q = p = StartOf_FilterList[FilterType];
    NrOfFilters = &NrOf_Filters[FilterType];
    key = pw_question("Enter filter number", "0123456789", PWW_DATA);
    if (key == PWK_ESC)
        FilterNumber = 1;
    else
        FilterNumber = key - '0';
    if ((FilterNumber < 1) || (FilterNumber > (*NrOfFilters)))
    {
        pw_warning("Filter number out of range");
        return;
    }
    if (q->FilterNo == FilterNumber)
    {
        StartOf_FilterList[FilterType] = StartOf_FilterList[FilterType]->FNext;
        IPBufFree(q->Contents);
        IPBufFree(q);
        p = StartOf_FilterList[FilterType];
        while (p != NULL)
        {
            p->FilterNo = p->FilterNo-1;
            p = p->FNext;
        }
        (*NrOfFilters)--;
        if (!changed)
            changed++;
    }
    else
    {
        while ((q != NULL) && (q->FilterNo < FilterNumber))
        {
            p = q;
            q = q->FNext;
        }
        if (q->FilterNo == FilterNumber)
        {
            p->FNext = q->FNext;
            IPBufFree(q->Contents);
            IPBufFree(q);
            p = p->FNext;
            while (p != NULL)
            {
                p->FilterNo = p->FilterNo-1;
                p = p->FNext;
            }
            (*NrOfFilters)--;
            if (!changed)
                changed++;
        }
        else
        {
            pw_warning("Can't find filter number %d", FilterNumber);
            return;
        }
    }
}

static int PwmFilterVars(PWWIN *pFilterWin, int Action, int Elem)
{
    switch (Action)
    {
        case PWA_INIT:
            break;
        case PWA_COUNT:
            Elem = 10;
            break;
        case PWA_FIRSTCHAR:
            switch (Elem)
            {
                case 0: /* Filter number */
                    Elem = 'F';
                    break;
                case 1: /* Destination address */
                    Elem = 'D';
                    break;
                case 2: /* Source address */
                    Elem = 'S';
                    break;
                case 3: /* Protocol type */
                    Elem = 'P';
                    break;
                case 4: /* Contents */
                    Elem = 'C';
                    break;
                case 5: /* contents Offset */
                    Elem = 'O';
                    break;
                case 6: /* device Number */
                    Elem = 'N';
                    break;
                case 7: /* packet size Lower limit */
                    Elem = 'L';
                    break;
                case 8: /* packet size Upper limit */
                    Elem = 'U';
                    break;
             }
            break;
        case PWA_DISPLAY:
            if (gfp != NULL)
            {
                switch (Elem)
                {
                    case 0: /* Filter number */
                        DisplayFilterNo(pFilterWin, gfp);
                        break;
                    case 1: /* Destination address */
                        DisplayDestAddr(pFilterWin, gfp);
                        break;
                    case 2: /* Source address */
                        DisplaySrcAddr(pFilterWin, gfp);
                        break;
                    case 3: /* Protocol type */
                        DisplayPktType(pFilterWin, gfp);
                        break;
                    case 4: /* Contents */
                        DisplayContents(pFilterWin, gfp);
                        break;
                    case 5: /* contents Offset */
                        DisplayOffset(pFilterWin, gfp);
                        break;
                    case 6: /* device Number */
                        DisplayDevNo(pFilterWin, gfp);
                        break;
                    case 7: /* packet size Lower limit */
                        DisplayPSLL(pFilterWin, gfp);
                        break;
                    case 8: /* packet size Upper limit */
                        DisplayPSUL(pFilterWin, gfp);
                        break; 
                 }
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPAPC=PwmFilterVars: NULL-pointer.");
            break;
        case PWA_ENTER:
            if (gfp != NULL)
            
            {
                switch (Elem)
                {
                    case 0: /* Filter number */
                        break;
                    case 1: /* Destination address */
                        if (adres_defs_Xist)
                            pw_menu(10, 12, 0, 0, "Host names", HostNameMenu, PwmDestHostNameMenu, &HostNameElem);
                        else
                            EditDestAddr(&gfp);
                        break;
                    case 2: /* Source address */
                        if (adres_defs_Xist)
                            pw_menu(10, 12, 0, 0, "Host names", HostNameMenu, PwmSrcHostNameMenu, &HostNameElem);
                        else
                            EditSrcAddr(&gfp);
                        break;
                    case 3: /* Protocol type */
                        if (prot_defs_Xist)
                            pw_menu(10, 12, 0, 0, "Protocols", ProtocolMenu, PwmProtocolMenu, &ProtocolMenuElem);
                        else
                            EditPktType(&gfp);
                        break;
                    case 4: /* Contents */
                        EditContents(&gfp);
                        break;
                    case 5: /* contents Offset */
                        EditOffset(&gfp);
                        break;
                    case 6: /* device Number */
                        EditDevNo(&gfp);
                        break;
                    case 7: /* packet size Lower limit */
                        EditPSLL(&gfp);
                        break;
                    case 8: /* packet size Upper limit */
                        EditPSUL(&gfp);
                        break; 
                 }
                 Elem = PWA_UPDATELINE;
            }
            else
                ERR_ERR(ERR_PCA, 1, "DPAPC=PwmFilterVars: NULL-pointer.");
            break;
        case PWA_INSERT:
            break;
        case PWA_DELETE:
            break;
    }
    return Elem; 
}

static int PwmDestHostNameMenu(int Element)
{
    switch (Element)
    {
        case 0: /* Self define */
            EditDestAddr(&gfp);
            break;
        default: /* Host name */
            HostName2DestAddr(&gfp, Element-1);
            break;
    }
    return PWA_EXITMENU;
}

static int PwmSrcHostNameMenu(int Element)
{
    switch (Element)
    {
        case 0: /* Self define */
            EditSrcAddr(&gfp);
            break;
        default: /* Host name */
            HostName2SrcAddr(&gfp, Element-1);
            break;
    }
    return PWA_EXITMENU;
}

static int PwmProtocolMenu(int Element)
{
    switch (Element)
    {
        case 0: /* Self define */
            EditPktType(&gfp);
            break;
        default: /* Host name */
            Protocol2PktType(&gfp, Element-1);
            break;
    }
    return PWA_EXITMENU;
}

static void DisplayFilterNo(PWWIN *Win, FILTER *fp)
{
    char InputString[10];

    InputString[0] = '\0';
    itoa(fp->FilterNo, InputString, 10);
    pw_printf(Win, "Filter number: %s", InputString);
}

static void DisplayDestAddr(PWWIN *Win, FILTER *fp)
{
    char InputString[20];

    InputString[0] = '\0';
    if (fp->UseDestAddr)
        sprintf(InputString, "%02x:%02x:%02x:%02x:%02x:%02x",
            fp->DestAddr[0], fp->DestAddr[1], fp->DestAddr[2], fp->DestAddr[3], fp->DestAddr[4], fp->DestAddr[5]);
    pw_printf(Win, "Destination address: %s", InputString);
}

static void DisplaySrcAddr(PWWIN *Win, FILTER *fp)
{
    char InputString[20];
 
    InputString[0] = '\0';
    if (fp->UseSrcAddr)
        sprintf(InputString, "%02x:%02x:%02x:%02x:%02x:%02x",
            fp->SrcAddr[0], fp->SrcAddr[1], fp->SrcAddr[2], fp->SrcAddr[3], fp->SrcAddr[4], fp->SrcAddr[5]);
    pw_printf(Win, "Source address: %s", InputString);
}

static void DisplayPktType(PWWIN *Win, FILTER *fp)
{
    char InputString[10];
 
    InputString[0] = '\0';
    if (fp->UsePktType)
        itoa(fp->PktTypeInt, InputString, 16);
    pw_printf(Win, "Protocol type: %s", InputString);
}

static void DisplayContents(PWWIN *Win, FILTER *fp)
{
    char InputString[1520];
 
    InputString[0] = '\0';
    if (fp->UseContents)
        Contents2ContentsStr(fp->Contents, InputString, fp->ContentsLen);
    pw_printf(Win, "Contents: %s", InputString);
}

static void DisplayOffset(PWWIN *Win, FILTER *fp)
{
    char InputString[10];
 
    InputString[0] = '\0';
    if (fp->UseContents)
        itoa(fp->ContentsOff, InputString, 10);
    pw_printf(Win, "contents Offset: %s", InputString);
}

static void DisplayDevNo(PWWIN *Win, FILTER *fp)
{
    char InputString[10];
 
    InputString[0] = '\0';
    if (fp->UseDevNr)
        itoa(fp->DevNr, InputString, 10);
    pw_printf(Win, "device Number: %s", InputString);
}

static void DisplayPSLL(PWWIN *Win, FILTER *fp)
{
    char InputString[10];
 
    InputString[0] = '\0';
    if (fp->UsePktSize)
        itoa(fp->PktSizeLL, InputString, 10);
    pw_printf(Win, "packet size Lower limit: %s", InputString);
}

static void DisplayPSUL(PWWIN *Win, FILTER *fp)
{
    char InputString[10];
 
    InputString[0] = '\0';
    if (fp->UsePktSize)
        itoa(fp->PktSizeUL, InputString, 10);
    pw_printf(Win, "packet size Upper limit: %s", InputString);
}

static void EditDestAddr(FILTER **fpp)
{
    char InputString[20];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UseDestAddr)
        sprintf(InputString, "%02x:%02x:%02x:%02x:%02x:%02x",
            (*fpp)->DestAddr[0], (*fpp)->DestAddr[1], (*fpp)->DestAddr[2], (*fpp)->DestAddr[3], (*fpp)->DestAddr[4], (*fpp)->DestAddr[5]);
    pTempWin = pw_open(10, 12, 1, 52, "Destination address", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 18, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UseDestAddr = (strlen(InputString) != 0);
    AddrStr2Addr(InputString, (*fpp)->DestAddr);
    if (!changed)
        changed++;
}

static void EditSrcAddr(FILTER **fpp)
{
    char InputString[20];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UseSrcAddr)
        sprintf(InputString, "%02x:%02x:%02x:%02x:%02x:%02x",
            (*fpp)->SrcAddr[0], (*fpp)->SrcAddr[1], (*fpp)->SrcAddr[2], (*fpp)->SrcAddr[3], (*fpp)->SrcAddr[4], (*fpp)->SrcAddr[5]);
    pTempWin = pw_open(10, 12, 1, 52, "Source address", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 18, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UseSrcAddr = (strlen(InputString) != 0);
    AddrStr2Addr(InputString, (*fpp)->SrcAddr);
    if (!changed)
        changed++;
}

static void EditPktType(FILTER **fpp)
{
    char InputString[10];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UsePktType)
        itoa((*fpp)->PktTypeInt, InputString, 16);
    pTempWin = pw_open(10, 12, 1, 52, "Protocol type", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 5, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UsePktType = 1;
    sscanf(InputString, "%04x", &((*fpp)->PktTypeInt));
    (*fpp)->PktType[0] = (BYTE) ((*fpp)->PktTypeInt >> 8);
    (*fpp)->PktType[1] = (BYTE) ((*fpp)->PktTypeInt & 0xff);
    if (!changed)
        changed++;
}

static void EditContents(FILTER **fpp)
{
    char InputString[3028];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UseContents)
        Contents2ContentsStr((*fpp)->Contents, InputString, (*fpp)->ContentsLen);
    pTempWin = pw_open(10, 12, 1, 52, "Contents", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 1514, NULL, PWM_PROMPT); 
    pw_close(pTempWin);
    (*fpp)->ContentsLen = strlen(InputString)/2;
    if (((*fpp)->Contents = IPBufGet((*fpp)->ContentsLen * sizeof(BYTE))) != NULL)
    {
        ContentsStr2Contents(InputString, (*fpp)->Contents);
        (*fpp)->UseContents = (strlen(InputString) != 0);
        ERR_DEB(ERR_PCA, 1, "DPAPC=PwmFilterVars: Successfully added new contents");
        if (!changed)
            changed++;
    }
    else
        ERR_DEB(ERR_PCA, 1, "DPAPC=PwmFilterVars: Couldn't allocate new contents");
}

static void EditOffset(FILTER **fpp)
{
    char InputString[10];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UseContents)
        itoa((*fpp)->ContentsOff, InputString, 10);
    pTempWin = pw_open(10, 12, 1, 52, "Contents offset", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 5, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->ContentsOff = atoi(InputString);
    if (!changed)
        changed++;
}

static void EditDevNo(FILTER **fpp)
{
    char InputString[10];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UseDevNr)
        itoa((*fpp)->DevNr, InputString, 10);
    pTempWin = pw_open(10, 12, 1, 52, "Device number", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 2, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UseDevNr = 1;
    (*fpp)->DevNr = atoi(InputString);
    if (!changed)
        changed++;
}

static void EditPSLL(FILTER **fpp)
{
    char InputString[10];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UsePktSize)
        itoa((*fpp)->PktSizeLL, InputString, 10);
    pTempWin = pw_open(10, 12, 1, 52, "Packet size lower limit", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 5, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UsePktSize = 1;
    (*fpp)->PktSizeLL = atoi(InputString);
    if (!changed)
        changed++;
}

static void EditPSUL(FILTER **fpp)
{
    char InputString[10];
    PWWIN *pTempWin;
 
    InputString[0] = '\0';
    if ((*fpp)->UsePktSize)
        itoa((*fpp)->PktSizeUL, InputString, 10);
    pTempWin = pw_open(10, 12, 1, 52, "Packet size upper limit", PWM_DEFAULT, PWW_DATA);
    pw_shade(pTempWin);
    pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 5, NULL, PWM_PROMPT);
    pw_close(pTempWin);
    (*fpp)->UsePktSize = 1;
    (*fpp)->PktSizeUL = atoi(InputString);
    if (!changed)
        changed++;
}

static void HostName2DestAddr(FILTER **fpp, int index)
{
    memcpy((*fpp)->DestAddr, adres_keys[index], hdrinfo->AddrLen);
    (*fpp)->UseDestAddr = 1;
    if (!changed)
        changed++;
}

static void HostName2SrcAddr(FILTER **fpp, int index)
{
    memcpy((*fpp)->SrcAddr, adres_keys[index], hdrinfo->AddrLen);
    (*fpp)->UseSrcAddr = 1;
    if (!changed)
        changed++;
}

static void Protocol2PktType(FILTER **fpp, int index)
{
    memcpy((*fpp)->PktType, prot_keys[index], hdrinfo->TypLen);
    (*fpp)->PktTypeInt = ((*fpp)->PktType[0] << 8) + (*fpp)->PktType[1];
    (*fpp)->UsePktType = 1;
    if (!changed)
        changed++;
}

static void AddrStr2Addr(char *string, BYTE *array)
/* Converts a string containing an Ethernet address of the form:
   "xx:xx:xx:xx:xx:xx" (x = hexadecimal digit), to a byte array with two
    consecutive x's in one byte */
{
    int i;

    for (i=0;i<6;i++)
        sscanf(string+i*3, "%x", &(array[i]));
}

static void ContentsStr2Contents(char *string, BYTE *array)
/* Converts a string containing the contents of an Ethernet packet of the form:
   "xxxxxxxxxxxx" (x = hexadecimal digit), to a byte array with two
    consecutive x's in one byte */
{
    int i;      

    for (i=0;i<(int)(strlen(string)/2);i++)
        sscanf(string+i*2, "%02x", &(array[i]));
}

static void Contents2ContentsStr(BYTE *array, char *string, int NrOfBytes)
/* Converts a byte array with two consecutive x's in one byte to a string
   containing the contents of an Ethernet packet of the form:
   "xxxxxxxxxxxx" (x = hexadecimal digit) */
{
    int i;
    char temp[10];

    string [0] = '\0';
    for (i=0;i<NrOfBytes;i++)
    {
        sprintf(temp, "%02x", array[i]);
        strcat(string, temp);
    }
}

static void PrintFilterStatus(void)
{
    FILTER *tfp;
    int found, i, j = 0, k;
    char temp[25];

/*  pw_close(FilterStatusWin); 
    FilterStatusWin = pw_open (14, 1, 9, 78, "Filter Status", PWM_NOSHADE, PWW_DATA);
    pw_printfat (FilterStatusWin, -1, 0, "Ty#DestAddressSrcAddressProtocoOffsContentsDLen>Len<"); */
    for (i=0; i<9; i++)
        pw_printfat(FilterStatusWin, i, 0, "                                                                               "); 
    for (i=0, j=0; ((i<6) && (j<9)); i++)
    {
        tfp = StartOf_FilterList[i];
        while ((tfp != NULL) && (j<9))
        {
            pw_printfat(FilterStatusWin, j, 2, "");
            pw_printfat(FilterStatusWin, j, 4, "");
            pw_printfat(FilterStatusWin, j, 18, "");
            pw_printfat(FilterStatusWin, j, 32, "");
            pw_printfat(FilterStatusWin, j, 40, "");
            pw_printfat(FilterStatusWin, j, 45, "");
            pw_printfat(FilterStatusWin, j, 66, "");
            pw_printfat(FilterStatusWin, j, 68, "");
            pw_printfat(FilterStatusWin, j, 73, "");
            pw_printfat(FilterStatusWin, j, 0, "%02s", type[i]);
            pw_printfat(FilterStatusWin, j, 3, "%01d", tfp->FilterNo);
            if (tfp->UseDestAddr)
            {
                if (adres_defs_Xist)
                {
                    found = 0;
                    for (k=0; k<NrOf_AddrDefs && !found; k++)
                       found = ((memcmp(adres_keys[k], tfp->DestAddr, hdrinfo->AddrLen)) == 0);
                    if (found)
                    {
                        strcpy(temp, adres_desc[k]);
                        pw_printfat(FilterStatusWin, j, 5, "%s", temp);
                    }
                    else
                        pw_printfat(FilterStatusWin, j, 5, "%02x%02x%02x%02x%02x%02x",
                            tfp->DestAddr[0], tfp->DestAddr[1], tfp->DestAddr[2], tfp->DestAddr[3], tfp->DestAddr[4], tfp->DestAddr[5]);
                }
                else
                    pw_printfat(FilterStatusWin, j, 5, "%02x%02x%02x%02x%02x%02x",
                        tfp->DestAddr[0], tfp->DestAddr[1], tfp->DestAddr[2], tfp->DestAddr[3], tfp->DestAddr[4], tfp->DestAddr[5]);
            }
            if (tfp->UseSrcAddr)
            {
                if (adres_defs_Xist)
                {
                    found = 0;
                    for (k=0; k<NrOf_AddrDefs && !found; k++)
                       found = ((memcmp(adres_keys[k], tfp->SrcAddr, hdrinfo->AddrLen)) == 0);
                    if (found)
                    {
                        strcpy(temp, adres_desc[k]);
                        pw_printfat(FilterStatusWin, j, 19, "%s", temp);
                    }
                    else
                        pw_printfat(FilterStatusWin, j, 19, "%02x%02x%02x%02x%02x%02x",
                            tfp->SrcAddr[0], tfp->SrcAddr[1], tfp->SrcAddr[2], tfp->SrcAddr[3], tfp->SrcAddr[4], tfp->SrcAddr[5]);
                }
                else
                    pw_printfat(FilterStatusWin, j, 19, "%02x%02x%02x%02x%02x%02x",
                        tfp->SrcAddr[0], tfp->SrcAddr[1], tfp->SrcAddr[2], tfp->SrcAddr[3], tfp->SrcAddr[4], tfp->SrcAddr[5]);
            }
            if (tfp->UsePktType)
            {
                if (prot_defs_Xist)
                {
                    found = 0;
                    for (k=0; k<NrOf_ProtDefs && !found; k++)
                       found = ((memcmp(prot_keys[k], tfp->PktType, hdrinfo->TypLen)) == 0);
                    if (found)
                    {
                        strcpy(temp, prot_desc[k]);
                        pw_printfat(FilterStatusWin, j, 33, "%s", temp);
                    }
                    else
                        pw_printfat(FilterStatusWin, j, 33, "%02x%02x",
                            tfp->PktType[0], tfp->PktType[1]);
                }
                else
                    pw_printfat(FilterStatusWin, j, 33, "%02x%02x",
                        tfp->PktType[0], tfp->PktType[1]);
            }
            if (tfp->UseContents)
            {
                pw_printfat(FilterStatusWin, j, 41, "%04d", tfp->ContentsOff);
                Contents2ContentsStr(tfp->Contents, temp, (tfp->ContentsLen > 10 ? 10 : tfp->ContentsLen));
                pw_printfat(FilterStatusWin, j, 46, "%s", temp);
            }
            if (tfp->UseDevNr)
                pw_printfat(FilterStatusWin, j, 67, "%01d", tfp->DevNr);
            if (tfp->UsePktSize)
            {
                pw_printfat(FilterStatusWin, j, 69, "%04d", tfp->PktSizeLL);
                pw_printfat(FilterStatusWin, j, 74, "%04d", tfp->PktSizeUL);
            }
            tfp = tfp->FNext;
            j++;
        }
    }
    changed--;
}
