/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dp.c
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Keyboard handling dispatcher functions
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DPKEY.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DPKEY.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 14:21:18   etstjan
**              
**                 Rev 1.0   26 Oct 1990 12:28:08   etstjan
**              Initial revision.
*************************************************************************/
#include <stdio.h>                          /* for NULL */
#include <power3.h>
#include <bufm.h>
#include "dpinc.h"

static void FocusNextApps(void);
static void FocusPrevApps(void);
static void FocusApps(void);
static int  ProcActionMenu(int Element);
static int  ProcAppsMenu(PWWIN *pWin, int Action, int Element);

static DPKEY DpKey;
static int AppsKeyFocus = 0;
static int SelectApps;
static int AppsElement;
static int ActionElement;
static char *ActionMenu[] = {
    "Show",
    "Start",
    "Stop",
    "Hide",
    "Reset",
    "Update",
    NULL
};

DPKEY DpGetKey()
{
    return DpKey;
}

static void FocusNextApps(void)
{
    int OldFocus = AppsKeyFocus;

    do {                                      /* find next apps with KEYPR. */
        if (!DpAppsActive[++AppsKeyFocus])   /* wrap around */
            AppsKeyFocus = 0;
    } while ((AppsKeyFocus != OldFocus) &&
             !(DpAppsActive[AppsKeyFocus]->EventMask & DPE_KEYPRESSED));
    FocusApps();
}

static void FocusPrevApps(void)
{
    int OldFocus = AppsKeyFocus;

    do {                                    /* find prev apps with KEYPR. */
        if (AppsKeyFocus == 0)              /* wrap around */
            while (DpAppsActive[++AppsKeyFocus]);
        AppsKeyFocus--;
    } while ((AppsKeyFocus != OldFocus) &&
             !(DpAppsActive[AppsKeyFocus]->EventMask & DPE_KEYPRESSED));
    FocusApps();
}

static void FocusApps(void)
{
}

static int ProcActionMenu(int Element)
{
    DPAPPS *pApps = DpAppsActive[SelectApps];
    DPEVENT EventMask;

    switch (Element)
    {
    case 0: /* Show  */
    case 1: /* Start */
    case 2: /* Stop  */
    case 3: /* Hide  */
        EventMask = (1 << Element);
        if ((pApps->EventMask & EventMask) &&
            !(pApps->Status & EventMask))
            DpAppsEvent(SelectApps, EventMask);
        if (Element < 3)
            Element++;
        else
            Element = 0;
        break;
    case 4: /* Reset */
        if ((pApps->EventMask & DPE_RESET))
            DpAppsEvent(SelectApps, DPE_RESET);
        break;
    case 5: /* Update */
        DpAppsEvent(SelectApps, DPE_FREETIME);
        break;
    }
    return Element;
}

static int ProcAppsMenu(PWWIN *pWin, int Action, int Element)
{
    switch (Action)
    {
    case PWA_INIT:
        pw_shade(pWin);
        break;
    case PWA_COUNT:
        Element = 0;                        /* count applications */
        while (DpAppsActive[Element])
            Element++;
        Element++;                          /* add 1 for 'Quit' */
        break;
    case PWA_DISPLAY:
        pw_puts(pWin, (DpAppsActive[Element]) ? DpAppsActive[Element]->Name : "Quit");
        break;
    case PWA_FIRSTCHAR:
        Element = (DpAppsActive[Element]) ? *(DpAppsActive[Element]->Name) : 'Q';
        break;
    case PWA_ENTER:
        if (DpAppsActive[Element])           /* application */
        {
            SelectApps = Element;
            pw_menu(7, 71, 0, 0, "Action", ActionMenu, ProcActionMenu, &ActionElement);
        }
        else                                /* 'Quit' */
            Element = -1;                   /* exit menu immediately */
        break;
    }
    return Element;
}

int DpKbHit(void)
{
    return pwl_kbhit();
}

int DpKbHitEvent(void)
{
    int ret = 0;
    int apps, i;
    DPAPPS *pApps;
    DPTYPEFILT *pTypeFilt;
    PWWIN *pWin;

    pwl_kbwait(DpInternalLoop);
    DpKey = pw_getkey();
    switch (DpKey)
    {
    case PWK_ESC: /* action menu */
        AppsElement = 0;
        pw_select(7, 64, 9, 12, "Apps", ProcAppsMenu, &AppsElement);
        if (!DpAppsActive[AppsElement])      /* Quit ? */
            ret = -1;                       /* stop DP */
        break;
    case PWK_TAB:
        FocusNextApps();
        break;
    case PWK_STAB:
        FocusPrevApps();
        break;
    case PWK_F2:  /* info */
        pWin = pw_open(4, 4, 16, 50, "Info", PWM_DEFAULT, PWW_HELP);
        pw_shade(pWin);
        pw_keyinfo(pWin, NULL, NULL);

        pw_putsat(pWin, 0,  1, "BUFFERS:");
        pw_printfat(pWin, 1,  3, "S: %4d of %4d Bytes", DpInitTable.nSmall, DpInitTable.SmallSize);
        pw_printfat(pWin, 2,  3, "L: %4d of %4d Bytes", DpInitTable.nLarge, DpInitTable.LargeSize);
        pw_printfat(pWin, 3,  3, "Free:  %8u Bytes", FreeMem());

        pw_putsat(pWin, 5,  1, "PRE-FILTERS:");
        apps = 0;
        while ((pTypeFilt=DpTypeFiltAvailable[apps++]) && (apps < 11))
        {
            pw_putsat(pWin, 5+apps, 3, pTypeFilt->Name);
            pw_printfat(pWin, 5+apps, 14, "%d ", pTypeFilt->TypeLen);
            for (i=0; i<pTypeFilt->TypeLen; i++)
                pw_printf(pWin, "%02x", pTypeFilt->TypeData[i]);
        }

        pw_putsat(pWin, 0, 25, "APPLICATION PROGRAMS:");
        apps = 0;
        while ((pApps=DpAppsActive[apps++]) && (apps < 16))
        {
            pw_putsat(pWin, apps, 27, pApps->Name);
            if (pApps->Status & DPE_START)
                pw_putsat(pWin, apps, 39, "Start");
            else
                pw_putsat(pWin, apps, 39, "Stop");
            if (pApps->Status & DPE_SHOW)
                pw_putsat(pWin, apps, 45, "Show");
            else
                pw_putsat(pWin, apps, 45, "Hide");
        }
        pw_getkey();
        pw_close(pWin);
        break;
    case PWK_CF3: /* DOS shell */
/*        pw_system(NULL); */
        pw_warning("DOS Shell is disabled!!!");
        break;
    default:
        DpAppsEvent(AppsKeyFocus, DPE_KEYPRESSED);
    }
    pwl_kbwait(NULL);
    return ret;
}
