/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPU.H
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Include file for the Network DisPatcher's
**              Packet Driver Handling Library.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DPU.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUUTI.C_V  $
**              
**                 Rev 1.1   17 Sep 1991 11:49:23   tirza
**              Added FDFIELD-definitions from DPUINI.C. Cleaning-up.
**              
**                 Rev 1.0   25 Oct 1990 15:27:08   etstjan
**              Initial revision.
*************************************************************************/
#include <power3.h>

#define FIELDDEF            struct _fielddef
#define FIELDINFO           struct _fieldinfo
#define FDFIELD             struct _fdfield
#define FIELDDEFPAIR        struct _fielddefpair
#define MAX_FIELDKEYLEN     6
#define MAX_FIELDDESCLEN    20


FIELDDEF {
    BYTE key[MAX_FIELDKEYLEN];
    char desc[MAX_FIELDDESCLEN];
    FIELDDEF *next;
};
FIELDINFO {
    FIELDDEF *first;
    int hex;
    int keylen;
    int desclen;
};
FDFIELD {
    int id;
    int type;
    int off;
    int offbit;
    int len;
    int lenbit;
};
FIELDDEFPAIR {
    BYTE key[MAX_FIELDKEYLEN];
    char desc[MAX_FIELDDESCLEN];
};
typedef BYTE KEY[MAX_FIELDKEYLEN];
typedef char DESC[MAX_FIELDDESCLEN];
extern FIELDINFO fieldinfo[];

/* DPUFILT.C */
extern void      DpuSelectFilt(int srow, int scol, DPFILT **pFilt);

/* DPUREF.C */
extern void      DpuSelectPreFilt(int srow, int scol, int Dev);

/* DPUUTI.C */
extern int       DpuProcSelect(PWWIN *pWin, int Action, int Element);
#ifdef FUTURE
extern void      DpuTrace(int Level, char *format, ...);
extern void      DpuError(char *format, ...);
#endif

/*DPUFILE.C */
extern DPKEY     DpuGetFile(char *header, char *filemask, char *fname, int *OldElem);

/* DPUSTAT.C */
extern void      DpuSelectStation(int row, int col, int nrow, char *Station, int *Element);

/* DPUDUMP.C */
extern int       DpuDumpInit(char *dumpfile, int mode);
extern unsigned int       
                 DpuDumpCount(long *fpos, unsigned int maxframes, char *TimeStamp);
extern void      DpuDumpSeek(long fpos);
extern void      DpuDumpReadFrame(DPBUF *frp, BYTE *buf);
extern void      DpuDumpWriteFrame(DPBUF *frp);
extern void      DpuDumpEnd(void);

/*DPUINI.C */
extern int       DpuIniInit(char *infile);
extern int       DpuIniFindId(char *fname);
extern FIELDDEF *DpuIniFindDef(int id, BYTE *key);
extern int       DpuIniCountDefs(int id);
extern void      DpuIniGetDefPairs(int id, FIELDDEFPAIR *array);
extern void      DpuIniGetKeys(int id, KEY *array);
extern void      DpuIniGetDefs(int id, DESC *array);
extern void      DpuIniEnd(void);

/* DPULOGO.C */
extern void      DpuLogoDNPAP(int row, int col, int size);

/* DPUPERC.C */
extern void      DpuPerc(PWWIN *pWin, int row, int col, int Perc);
