/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pkt.h
**     SYSTEM   NAME:       Beholder
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1990/10/25
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PKT.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKT.H_V  $
**              
**                 Rev 1.0   25 Oct 1990 14:34:46   etstjan
**              Initial revision.
*************************************************************************/
#ifndef PKT_OK

#define PKT_OK              0               /* succesfull call */
#define PKT_BAD_HANDLE      1               /* error codes */
#define PKT_NO_CLASS        2
#define PKT_NO_TYPE         3
#define PKT_NO_NUMBER       4
#define PKT_BAD_TYPE        5
#define PKT_CANT_TERMINATE  7
#define PKT_BAD_MODE        8
#define PKT_NO_SPACE        9
#define PKT_TYPE_INUSE      10
#define PKT_BAD_COMMAND     11
#define PKT_CANT_SEND       12
#define PKT_CANT_SET        13
#define PKT_BAD_ADDRESS     14
#define PKT_NO_INIT         15
#define PKT_BAD_INTNO       16

#define PKTNAMELEN          10

#define PKT_MODE_OFF        1
#define PKT_MODE_NORMAL     2
#define PKT_MODE_BROAD      3
#define PKT_MODE_LIMMULTI   4
#define PKT_MODE_MULTI      5
#define PKT_MODE_ALL        6

typedef struct _PKTSTAT {
    long PktsIn;
    long PktsOut;
    long BytesIn;
    long BytesOut;
    long ErrsIn;
    long ErrsOut;
    long PktsDropped; /* NB: This number represents the number of packets
                         that are dropped, due to the TYPE filter,
                         specified by PktAccessType.  It does NOT
                         represent the number of times that the application
                         did not return a buffer pointer in ReceivePkt() */
} far PKTSTAT;

typedef struct _PKTINFO {
    int Version;
    int Type;
    char far *Name;
    unsigned char Class;
    unsigned char Number;
    unsigned char Installed;   /* 1-Basic, 2-Extended, FF-Not installed */
} PKTINFO;

typedef int (* ADDDEVFUNC)(int PktInt);
typedef int (far *PKTUPCALL)();
#endif

int     PktInit(ADDDEVFUNC pInit);
int     PktEnd(void);
int     PktAccessType(int PktInt, char far *fpType, int TypeSize,
                      PKTUPCALL pRecFunc, int *pHandle);
int     PktReleaseType(int PktInt, int Handle);
int     PktSendPkt(int PktInt,char far *fpBuf, int BufSize);
int     PktTerminate(int PktInt);
int     PktGetAddress(int PktInt,char far *fpBuf, int *BufSize);
int     PktResetInterface(int PktInt);
int     PktSetRcvMode(int PktInt, int Handle, int Mode);
int     PktGetStatistics(int PktInt, PKTSTAT **ppStat);
int     PktResetStatistics(int PktInt);
PKTINFO *PktDriverInfo(int PktInt);

