/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWCVPW1.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       POWER v1.xx conversion program for POWER v3.00
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <stdio.h>
#include "pwconv.h"                         /* prototyping */
#include "pwcvpw1.h"                        /* POWER 1.xx */

static void writecoord_pw1(int i);
void conv_pw1(char *word);

static void writecoord_pw1(i)
int i;
{
        writeparam(param[i+1]);             /* srow */
        writeword(", ");
        writeparam(param[i]);               /* scol */
        writeword(", ");
        writeparam(param[i+3]);             /* nrow */
        writeword(", ");
        writeparam(param[i+2]);             /* ncol */
        writeword(", ");
}

void conv_pw1(word)
char *word;
{
    int key = array_to_number(pw1_keyword, word);

    if (key >= 0)
    {
        if (key >= npwkeys)
        {
            writeword("\n/* ???: POWER v3.00 can't support: */\n");
            writeword(word);
        }
        else
            writeword(pw_keyword[key]);
    }
    else
        writeword(word);

    switch(key)
    {
    case PW1_KEY_block:
        initparam(6);
        writeparam(param[0]);   /* win */
        writeword(", ");
        writecoord_pw1(1);
        writeparam(param[5]);   /* ttype */
        break;
    case PW1_KEY_choice:
    case PW1_KEY_menu:
    case PW1_KEY_select:
        initparam(7);
        writecoord_pw1(0);
        writeparam(param[4]);   /* header */
        writeword(", ");
        writeparam(param[5]);   /* text */
        writeword(", ");
        writeparam(param[6]);   /* proc_func */
        break;
    case PW1_KEY_init:
        initparam(2);
        writeparam(param[0]);   /* argv0 */
        writeword(", \"INIT\", 0");
        break;
    case PW1_KEY_input:
        initparam(9);
        writeparam(param[0]);   /* win */
        writeword(", ");
        writeparam(param[2]);   /* trow */
        writeword(", ");
        writeparam(param[1]);   /* tcol */
        writeword(", ");
        writeparam(param[5]);   /* text */
        writeword(", ");
        writeparam(param[4]);   /* srow */
        writeword(", ");
        writeparam(param[3]);   /* scol */
        writeword(", ");
        writeparam(param[7]);   /* ncol */
        writeword(", ");
        writeparam(param[6]);   /* buf */
        writeword(", ");
        writeparam(param[7]);   /* bufsize */
        writeword(", ");
        writeparam(param[8]);   /* mode */
        writeword(", \"\"");    /* "" */
        break;
    case PW1_KEY_open:
        initparam(6);
        writecoord_pw1(0);
        writeparam(param[4]);   /* header */
        writeword(", ");
        writeparam(param[5]);   /* type */
        break;
    case PW1_KEY_putcat:
        initparam(4);
        writeparam(param[0]);   /* win */
        writeword(", ");
        writeparam(param[2]);   /* srow */
        writeword(", ");
        writeparam(param[1]);   /* scol */
        writeword(", ");
        writeparam(param[3]);   /* c */
        break;
    case PW1_KEY_putsat:
        initparam(4);
        writeparam(param[0]);   /* win */
        writeword(", ");
        writeparam(param[2]);   /* srow */
        writeword(", ");
        writeparam(param[1]);   /* scol */
        writeword(", ");
        writeparam(param[3]);   /* s */
        break;
    }
}

