/* [DOC] File ***********************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pwgdir.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/6/27
**
** Descr:       File select function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif
#include <stdio.h>
#include <string.h>                         /* for str*() */
#include "pwinc.h"

static int pwg_fileinit(unsigned int maxfiles, char *mask);
static int fnamecmp(const char **fname1, const char **fname2);
static void pwg_fileend(void);
static char **filearray;
static unsigned int attrib = PWA_NORMAL | PWA_ARCH | PWA_RDONLY;

/* [DOC] Function *********************************************
** Name:        pw_fileselect                             [API]
** SYNOPSIS:    int pw_fileselect(srow, scol, nrow,
**                                maxfiles, element,
**                                mask, fname)
**              int     srow        Top left row of menu window
**              int     scol        Top left col of menu window
**              int     nrow        Menu window height
**              int     maxfiles    Array size
**              char    *mask       File mask
**              unsigned attrib     File attribs
**              char    *fname      Buffer to return selected
**                                    file.
** Descr:       Provides a file selection window.
**              The 'pw_fileselect' function fills a select
**                window at 'srow', 'scol' with the filenames
**                that match the file mask 'mask'.
**              'mask' may contain pathnames and wildcards.
**              'nrow' is the menu window height, or 0 to make
**                the window as large as needed or possible.
**              The filename ('mask's pathname and selected
**                filename) will be returned in 'fname'.
** RETURNS:     0:  Successful call
**              -1: No files found matching 'mask'.
**************************************************************/
int pw_fileselect(int srow, int scol, int nrow, int maxfiles, int *element,
                  char *mask, char *fname)
{
    int ret;

    if (!(ret = pwg_fileinit(maxfiles, mask)))
    {
        if (strcmp(filearray[0], mask))
            ret = pw_choice(srow, scol, nrow, 14, "Select files", filearray, element);
        else
            *element = 0;
        if (ret == PWK_ENTER && fname != NULL)
        {
            strcpy(fname, filearray[*element]);
            ret = 0;
        }
        pwg_fileend();
    }
    return ret;
}

static int pwg_fileinit(unsigned int maxfiles, char *mask)
{
    unsigned int ui;
    unsigned int nfiles = 0;
#if defined __MSC__ || defined __TSC__
#ifdef __OS2__
    HDIR hdir = 0xffff;
    USHORT usSearchCount = 1;
    FILEFINDBUF findbuf;
#else
    struct find_t buffer;
#endif
#endif
#ifdef __TURBOC__
    struct ffblk ffblk;
#endif

    if ((filearray = malloc(sizeof(char *)*maxfiles)) == NULL)
        return -9;
    for (ui=0; ui<maxfiles; ui++)
        filearray[ui] = NULL;
#if defined __MSC__ || defined __TSC__
#ifdef __OS2__
    if (DosFindFirst( mask, &hdir,
                      attrib,
                      &findbuf, sizeof(findbuf),
                      &usSearchCount, 0L) ==0)
    {
        /* fill filearray */
        do
        {
            if ((findbuf.attrFile & attrib) || /* file attrib match ? */
                !(findbuf.attrFile))           /* NORMAL files match always */
            {
                if ((nfiles+1 == maxfiles) ||   /* reserve one for NULL ptr */
                    !(filearray[nfiles] = malloc(strlen(findbuf.achName)+1)))
                {
                    pw_warning("Not enough memory to store ALL files");
                    pwg_fileend();
                    return -9;
                }
                else
                    strcpy(filearray[nfiles++], findbuf.achName);
            }
        } while (DosFindNext(hdir, &findbuf, sizeof(findbuf), &usSearchCount)==0);
    }
#else
    if (_dos_findfirst(mask, attrib, &buffer) == 0)
    {
        /* fill filearray */
        do
        {
            if ((buffer.attrib & attrib) || /* file attrib match ? */
                !(buffer.attrib))           /* NORMAL files match always */
            {
                if ((nfiles+1 == maxfiles) ||   /* reserve one for NULL ptr */
                    !(filearray[nfiles] = malloc(strlen(buffer.name)+1)))
                {
                    pw_warning("Not enough memory to store ALL files");
                    pwg_fileend();
                    return -9;
                }
                else
                    strcpy(filearray[nfiles++], buffer.name);
            }
        } while (_dos_findnext(&buffer) == 0);
    }
#endif
#endif
#ifdef __TURBOC__
    if (findfirst(mask, &ffblk, attrib) == 0)
    {
        /* fill filearray */
        do
        {
            if ((ffblk.ff_attrib & attrib) || /* file attrib match ? */
                !(ffblk.ff_attrib))           /* NORMAL files match always */
            {
                if ((nfiles+1 == maxfiles) ||   /* reserve one for NULL ptr */
                    !(filearray[nfiles] = malloc(strlen(ffblk.ff_name)+1)))
                {
                    pw_warning("Not enough memory to store ALL files");
                    pwg_fileend();
                    return -9;
                }
                else
                    strcpy(filearray[nfiles++], ffblk.ff_name);
            }
        } while (findnext(&ffblk) == 0);
    }
#endif
    if (nfiles)
        qsort(filearray, nfiles, sizeof(char *), fnamecmp);
    else
    {
        pw_warning("No files found matching the mask '%s'", mask);
        return -1;
    }
    return 0;
}

static int fnamecmp(const char **fname1, const char **fname2)
{
    return strcmp(*fname1, *fname2);
}

static void pwg_fileend(void)
{
    int i = 0;

    while (filearray[i])
        free(filearray[i++]);
    free(filearray);
}


