/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWTEST.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.20
**
** Descr:       Demo source code file for
**              Programmer Oriented Window Environment Routines.
**              (C) 1989,1990 - CSE Computer Systems Expertise.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      July 1991
**      CHANGES:            none
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>                         /* for exit() */
#include <string.h>                         /* for str*() */
#include <ctype.h>                          /* for toupper() */
#include "power3.h"                         /* for pw_*() */

#define MAX_FILES   100

static char *MainMenuTable[] = {
    "Special coordinates",
    "Text types",
    NULL
};

static void TestSpecialCoord(int mode)
{
    PWWIN *pWin;

    pWin = pw_open(PWC_TOP, PWC_LEFT, PWC_BOTTOM, PWC_RIGHT,
        "Special coordinates", mode, PWW_NORMAL);
    pw_puts(pWin, "pw_open(PWC_TOP, PWC_LEFT, PWC_BOTTOM, PWC_RIGHT, ...");
    pw_keyinfo(pWin, NULL, NULL);
    pw_getkey();
    pw_close(pWin);

    pWin = pw_open(PWC_CENTER, PWC_CENTER, 19, 76,
        "Special coordinates", mode, PWW_NORMAL);
    pw_puts(pWin, "pw_open(PWC_CENTER, PWC_CENTER, 19, 76, ...");
    pw_keyinfo(pWin, NULL, NULL);
    pw_close(pWin);

    pWin = pw_open(4, 4, PWC_CENTER, PWC_CENTER,
        "Special coordinates", mode, PWW_NORMAL);
    pw_puts(pWin, "pw_open(4, 4, PWC_CENTER, PWC_CENTER, ...");
    pw_keyinfo(pWin, NULL, NULL);
    pw_getkey();
    pw_close(pWin);
}

static void TestTextTypes(void)
{
    PWWIN *pWin;

    pWin = pw_open(PWC_CENTER, PWC_CENTER, 3, 34, "Text types", PWM_DEFAULT, PWW_NORMAL);
    pw_puts(pWin, " Normal @rReverse@h Highlight @sSpecial@p\n");
    pw_puts(pWin, " Normal @rReverse@p @hHighlight@p @sSpecial@p\n");
    pw_puts(pWin, " Normal Reverse Highlight Special");
    pw_block(pWin, 2,  1, 1, 6, PWT_NORMAL);
    pw_block(pWin, 2,  8, 1, 7, PWT_REVERSE);
    pw_block(pWin, 2, 16, 1, 9, PWT_HIGHLIGHT);
    pw_block(pWin, 2, 26, 1, 7, PWT_SPECIAL);
    pw_getkey();
    pw_close(pWin);
}

static int ProcMainMenu(int element)
{
    switch (element) {
    case 0: TestSpecialCoord(PWM_NOBORDER);
            TestSpecialCoord(PWM_DEFAULT);  break;
    case 1: TestTextTypes();                break;
    }
    return (element<sizeof(MainMenuTable)/sizeof(MainMenuTable[0])-1) ? element+1 : 0;
}

static void ArgError(char *progname)
{
    fprintf(stderr, "%s: Argument error.\n", progname);
    fprintf(stderr, "Usage: %s [/MDA] [/MONO] [/COLOR]\n", progname);
}

static int ExitFunc(void)
{
    if (pw_question("Do you relly want to quit? [N/Y]", "NY", PWW_ERROR) == 'Y')
        return PWR_EXIT;                        // quit program
    return PWR_CONTINUE;                        // continue program
}

int main(int argc, char **argv)
{
    int narg;

    narg = pw_options(argc, argv);              // parse POWER options
    if (narg != 1) { ArgError(argv[0]); return -1; }
    pw_init(argv[0], ExitFunc);                 // ExitFunc for <Shift-F3>.
    pw_header("POWER v3.20 test program - CSE Computer Systems Expertise");
    pw_menu(3, 4, PWC_AUTO, PWC_AUTO, "Main", MainMenuTable, ProcMainMenu, NULL);
    pw_quit();
    return 0;
}


