IFDEF M_SMALL
.MODEL SMALL
CODE_FAR equ 0
DATA_FAR equ 0
ENDIF

IFDEF M_MEDIUM
.MODEL MEDIUM
CODE_FAR equ 1
DATA_FAR equ 0
ENDIF

IFDEF M_COMPACT
.MODEL COMPACT
CODE_FAR equ 0
DATA_FAR equ 1
ENDIF

IFDEF M_LARGE
.MODEL LARGE
CODE_FAR equ 1
DATA_FAR equ 1
ENDIF

IFDEF M_HUGE
.MODEL HUGE
CODE_FAR equ 1
DATA_FAR equ 2
ENDIF

IFNDEF CODE_FAR
.ERR
ENDIF

SEGMOFFS    STRUC
    offs    dw (?)
    segm    dw (?)
SEGMOFFS    ENDS

WINDOW      STRUC
    srow    dw (?)
    scol    dw (?)
    nrow    dw (?)
    ncol    dw (?)
    crow    dw (?)
    ccol    dw (?)
    lev     dw (?)
    buf     dd (?)
    winptr  dd (?)
    scrptr  dd (?)
    levptr  dd (?)
    status  dw (?)
WINDOW      ENDS

.DATA
IFDEF __MSC__
COMM NEAR __pwv_scrbuf:   DWORD
COMM NEAR __pwv_levbuf:   DWORD
ELSE
EXTRN    __pwv_scrbuf:   DWORD
EXTRN    __pwv_levbuf:   DWORD
ENDIF

EXTRN    __pwv_scrncol:  WORD
EXTRN    __pwv_scrsnow:  BYTE
IFDEF __OS2__
EXTRN   VIOSHOWBUF:FAR
ENDIF

.CODE

PUBLIC  _pwv_cursor     ; void   pwv_cursor(PWVCURSOR far *pCursor);
PUBLIC  _pwv_putc       ; void   pwv_putc(PWVCURSOR far *pCursor, int c);
PUBLIC  _pwv_putattr    ; void   pwv_putattr(PWVCURSOR far *pCursor, int attr);
PUBLIC  _pwv_putcell    ; void   pwv_putcell(PWVCURSOR far *pCursor, PWCELL cell);
PUBLIC  _pwv_getcell    ; PWCELL pwv_getcell(PWVCURSOR far *pCursor);

PUBLIC  _pwv_rawputcell ; void   pwv_rawputcell(offset, cell);
PUBLIC  _pwv_rawgetcell ; PWCELL pwv_rawgetcell(offset);

PUBLIC  _pwv_display    ; (int srow, int scol, int nrow, int ncol,
                        ;  PWCELL far *buffer, int bufncol);
PUBLIC  _pwv_save
PUBLIC  _pwv_levelblock
PUBLIC  _pwv_moveleft
PUBLIC  _pwv_moveright
PUBLIC  _pwv_fillblock

; void   pwv_cursor(pWin);
IF CODE_FAR
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 6]
    ELSE
        PWIN    equ  word ptr [bp + 6]
    ENDIF
ELSE
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 4]
    ELSE
        PWIN    equ  word ptr [bp + 4]
    ENDIF
ENDIF
_pwv_cursor PROC
    push    bp
    mov     bp, sp

IF DATA_FAR
    les     bx, PWIN                        ; es:bx = win ptr
ELSE
    mov     ax, ds
    mov     es, ax
    mov     bx, PWIN                        ; es:bx = win ptr
ENDIF
    ; calculate windowbuf offset
    mov     al, byte ptr es:[bx.ncol]       ; al =  window width
    add     al, 2                           ; al = ncol (add side borders)
    mov     dl, byte ptr es:[bx.crow]       ; dl = crow (sub top border)
    inc     dl                              ; dl =  crow+1
    imul    dl                              ; ax = (crow+1)*ncol
    add     ax, es:[bx.ccol]
    inc     ax                              ; ax = (crow+1)*ncol + ccol+1
    shl     ax, 1
    ; winptr = window buffer + window offset
    add     ax, es:[bx.buf].offs
    mov     es:[bx.winptr].offs, ax
    mov     ax, es:[bx.buf].segm
    mov     es:[bx.winptr].segm, ax

    ; calculate level offset
    mov     ax, word ptr es:[bx.srow]       ; ax = (srow)
    add     al, byte ptr es:[bx.crow]       ; al = (srow+crow)
    imul    word ptr __pwv_scrncol          ; ax = (srow+crow)*ncol

    add     ax, es:[bx.scol]
    add     ax, es:[bx.ccol]                ; ax = (srow+crow)*ncol + scol+ccol
    ; levptr = level buffer + level offset
    mov     cx, __pwv_levbuf.offs
    add     cx, ax
    mov     es:[bx.levptr].offs, cx

    ; calculate screenbuf offset
    shl     ax, 1
    ; scrptr = screen buffer + screen offset
    mov     cx, __pwv_scrbuf.offs
    add     cx, ax
    mov     es:[bx.scrptr].offs, cx

    pop     bp
    ret
_pwv_cursor ENDP


; void   pwv_putc(pWin, c);
IF CODE_FAR
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 6]
        CHAR    equ  byte ptr [bp +10]
    ELSE
        PWIN    equ  word ptr [bp + 6]
        CHAR    equ  byte ptr [bp + 8]
    ENDIF
ELSE
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 4]
        CHAR    equ  byte ptr [bp + 8]
    ELSE
        PWIN    equ  word ptr [bp + 4]
        CHAR    equ  byte ptr [bp + 6]
    ENDIF
ENDIF
_pwv_putc   PROC
    push    bp
    mov     bp, sp
    push    ds
    push    si

IFDEF __OS2__
    mov     dx, __pwv_scrbuf.offs
ENDIF
IF DATA_FAR
    les     bx, PWIN                        ; es:bx = win ptr
ELSE
    mov     ax, ds
    mov     es, ax
    mov     bx, PWIN                        ; es:bx = win ptr
ENDIF
IFNDEF __OS2__
    mov     ch, __pwv_scrsnow
ENDIF
    lds     si, es:[bx.winptr]              ; ds:si = win buf ptr
    mov     al, CHAR
    mov     byte ptr ds:[si], al
    mov     cl, byte ptr es:[bx.lev]        ; cl = win->level
    lds     si, es:[bx.levptr]              ; levbuf[lev offset]
    ; update screen only if level >= pwv_level
    cmp     cl, byte ptr ds:[si]
    jl      putcell2scr_end
    ; update screen only if not in DOS shell
    test    byte ptr es:[bx.status], 006h
    jnz     putcell2scr_end
    lds     si, es:[bx.scrptr]              ; ds:si = scr buffer

IFNDEF __OS2__
    test    ch, 0ffh
    jz      putc_skipsnow                   ; --> User don't want no sync
    call    hretrace_byte
    jmp     SHORT putc_skip
putc_skipsnow:
ENDIF                                       ; OS/2 writes to logical buffer
    mov     byte ptr ds:[si], al            ; --> OS/2 needs no retrace sync
putc_skip:
    jmp     SHORT putcell2scr               ; now put attrib + char (ax)
_pwv_putc ENDP


; void   pwv_putattr(pWIn, attr)
IF CODE_FAR
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 6]
        ATTR    equ  byte ptr [bp +10]
    ELSE
        PWIN    equ  word ptr [bp + 6]
        ATTR    equ  byte ptr [bp + 8]
    ENDIF
ELSE
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 4]
        ATTR    equ  byte ptr [bp + 8]
    ELSE
        PWIN    equ  word ptr [bp + 4]
        ATTR    equ  byte ptr [bp + 6]
    ENDIF
ENDIF
_pwv_putattr PROC
    push    bp
    mov     bp, sp
    push    ds
    push    si

IFDEF __OS2__
    mov     dx, __pwv_scrbuf.offs
ENDIF
IF DATA_FAR
    les     bx, PWIN                        ; es:bx = win ptr
ELSE
    mov     ax, ds
    mov     es, ax
    mov     bx, PWIN                        ; es:bx = win ptr
ENDIF
IFNDEF __OS2__
    mov     ch, __pwv_scrsnow
ENDIF
    lds     si, es:[bx.winptr]              ; ds:si = win buf ptr
    mov     al, ATTR
    mov     byte ptr ds:[si+1], al
    mov     cl, byte ptr es:[bx.lev]        ; cl = win->level
    lds     si, es:[bx.levptr]              ; levbuf[lev offset]
    ; update screen only if level >= pwv_level
    cmp     cl, byte ptr ds:[si]
    jl      putcell2scr_end
    ; update screen only if not in DOS shell
    test    byte ptr es:[bx.status], 006h
    jnz     putcell2scr_end
    lds     si, es:[bx.scrptr]              ; ds:si = scr buffer

IFNDEF __OS2__
    test    ch, 0ffh;
    jz      putattr_skipsnow
    inc     si                              ; attrib is odd byte
    call    hretrace_byte
    dec     si
    jmp     SHORT putattr_skip
putattr_skipsnow:
ENDIF

    mov     byte ptr ds:[si+1], al
putattr_skip:
    jmp     SHORT putcell2scr               ; now put attrib + char (ax)
_pwv_putattr ENDP


putcell2scr:
IFDEF __OS2__
    ; PASCAL FAR style function call
    mov     ax, es:[bx.scrptr].offs
    sub     ax, dx                          ; ax = offset to log viobuf
    push    ax
    mov     ax, 02h                         ; 1 cell = 2 bytes
    push    ax
    xor     ax, ax                          ; hvio = 0
    push    ax
    call    FAR PTR VIOSHOWBUF              ; VioShowBuf(offset, 2, 0);
ENDIF

putcell2scr_end:
    ; allways increase buffer, screen and level offsets
    add     es:[bx.winptr].offs, 2
    add     es:[bx.scrptr].offs, 2
    inc     es:[bx.levptr].offs

    pop     si
    pop     ds
    pop     bp
IF CODE_FAR
    retf
ELSE
    ret
ENDIF


; pwv_putcell(pWin, cell);
IF CODE_FAR
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 6]
        CELL    equ  word ptr [bp +10]
    ELSE
        PWIN    equ  word ptr [bp + 6]
        CELL    equ  word ptr [bp + 8]
    ENDIF
ELSE
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 4]
        CELL    equ  word ptr [bp + 8]
    ELSE
        PWIN    equ  word ptr [bp + 4]
        CELL    equ  word ptr [bp + 6]
    ENDIF
ENDIF
_pwv_putcell PROC
    push    bp
    mov     bp, sp
    push    ds
    push    si

IFDEF __OS2__
    mov     dx, __pwv_scrbuf.offs
ENDIF
IF DATA_FAR
    les     bx, PWIN                        ; es:bx = win ptr
ELSE
    mov     ax, ds
    mov     es, ax
    mov     bx, PWIN                        ; es:bx = win ptr
ENDIF
IFNDEF __OS2__
    mov     ch, __pwv_scrsnow
ENDIF
    lds     si, es:[bx.winptr]              ; ds:si = win buf ptr
    mov     ax, CELL
    mov     word ptr ds:[si], ax
    mov     cl, byte ptr es:[bx.lev]        ; cl = win->level
    lds     si, es:[bx.levptr]              ; levbuf[lev offset]
    ; update screen only if level >= pwv_level
    cmp     cl, byte ptr ds:[si]
    jl      putcell2scr_end
    ; update screen only if not in DOS shell
    test    byte ptr es:[bx.status], 006h
    jnz     putcell2scr_end
    lds     si, es:[bx.scrptr]              ; ds:si = scr buffer

IFNDEF __OS2__
    test    ch, 0ffh;
    jz      putcell_skipsnow
    call    hretrace_word
    jmp     SHORT putcell_skip
putcell_skipsnow:
ENDIF

    mov     word ptr ds:[si], ax
putcell_skip:
    jmp     SHORT putcell2scr               ; now put attrib + char (ax)
_pwv_putcell ENDP


; void   pwv_rawputcell(offset, cell);
IF CODE_FAR
    OFFSE   equ  word ptr [bp + 6]
    CELL    equ  word ptr [bp + 8]
ELSE
    OFFSE   equ  word ptr [bp + 4]
    CELL    equ  word ptr [bp + 6]
ENDIF
_pwv_rawputcell PROC
    push    bp
    mov     bp, sp

    les     bx, __pwv_scrbuf
    mov     ax, OFFSE
    shl     ax, 1
IFDEF __OS2__
    push    ax
ENDIF
    add     bx, ax
    mov     ax, CELL
    mov     es:[bx], ax
IFDEF __OS2__
    ; PASCAL FAR style function call
;    pop     ax
;    push    ax
    mov     ax, 02h                         ; 1 cell = 2 bytes
    push    ax
    xor     ax, ax                          ; hvio = 0
    push    ax
    call    FAR PTR VIOSHOWBUF
ENDIF

    pop     bp
    ret
_pwv_rawputcell ENDP


; PWCELL pwv_rawgetcell(offset);
IF CODE_FAR
    OFFSE   equ  word ptr [bp + 6]
ELSE
    OFFSE   equ  word ptr [bp + 4]
ENDIF
_pwv_rawgetcell PROC
    push    bp
    mov     bp, sp

    les     bx, __pwv_scrbuf
    mov     ax, OFFSE
    shl     ax, 1
    add     bx, ax
    mov     ax, es:[bx]

    pop     bp
    ret
_pwv_rawgetcell ENDP


; PWCELL pwv_getcell(pWin)
IF CODE_FAR
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 6]
    ELSE
        PWIN    equ  word ptr [bp + 6]
    ENDIF
ELSE
    IF DATA_FAR
        PWIN    equ dword ptr [bp + 4]
    ELSE
        PWIN    equ  word ptr [bp + 4]
    ENDIF
ENDIF
_pwv_getcell PROC
    push    bp
    mov     bp, sp

IF DATA_FAR
    les     bx, PWIN                        ; es:bx = win ptr
ELSE
    mov     ax, ds
    mov     es, ax
    mov     bx, PWIN                        ; es:bx = win ptr
ENDIF
    les     bx, es:[bx.winptr]              ; ds:si = win buf ptr
    mov     ax, es:[bx]

    pop     bp
    ret
_pwv_getcell ENDP


IF CODE_FAR
    ROW     equ  word ptr [bp+ 6]
    COL     equ  word ptr [bp+ 8]
    LROW    equ  byte ptr [bp+10]
    WLROW   equ  word ptr [bp+10]
    LCOL    equ  word ptr [bp+12]
    BUFFER  equ dword ptr [bp+14]
    BUFNCOL equ  word ptr [bp+18]
ELSE
    ROW     equ  word ptr [bp+ 4]
    COL     equ  word ptr [bp+ 6]
    LROW    equ  byte ptr [bp+ 8]
    WLROW   equ  word ptr [bp+ 8]
    LCOL    equ  word ptr [bp+10]
    BUFFER  equ dword ptr [bp+12]
    BUFNCOL equ  word ptr [bp+16]
ENDIF
; void pwv_display(int srow, int scol, int nrow, int ncol,
;                  PWCELL far *buffer, int bufncol);
_pwv_display PROC
    push    bp                              ; entry sequence
    mov     bp, sp

    push    ds
    push    si
    push    di

    mov     ax, ROW
    imul    word ptr __pwv_scrncol          ; ax = (srow)*ncol

    add     ax, COL
    shl     ax, 1                           ; ax = (ROW*scrncol + COL)*2
IFDEF __OS2__
    push    ax                              ; save offset
    mov     bx, ax
    mov     ax, WLROW
    imul    word ptr __pwv_scrncol          ; ax = (nrow)*ncol

    shl     ax, 1                           ; # of bytes = # cells * 2
    push    ax                              ; save byte count
    mov     ax, bx
ENDIF

    les     di, __pwv_scrbuf
    add     di, ax                          ; es:di = dest (screen)
    mov     dl, LROW                        ; dl = nrow
    mov     cx, LCOL                        ; cx = ncol
    mov     ax, BUFNCOL
    sub     ax, LCOL
    shl     ax, 1                           ; ax = src add
    mov     bx, __pwv_scrncol
    sub     bx, LCOL
    shl     bx, 1                           ; bx = dest add
    lds     si, BUFFER                      ; ds:si = src (buffer)
    call    CopyBlock

IFDEF __OS2__
;    pop     cx                              ; restor byte count
;    pop     ax                              ; restore offset
;    push    ax
;    push    cx
    xor     ax, ax                          ; hvio = 0
    push    ax
    ; PASCAL FAR style function call
    call    FAR PTR VIOSHOWBUF
ENDIF

    pop     di
    pop     si
    pop     ds
display_e:
    pop     bp                              ; exit sequence
    ret
_pwv_display ENDP

IF CODE_FAR
    ROW     equ  word ptr [bp+ 6]
    COL     equ  word ptr [bp+ 8]
    LROW    equ  byte ptr [bp+10]
    LCOL    equ  word ptr [bp+12]
    BUFFER  equ dword ptr [bp+14]
    BUFNCOL equ  word ptr [bp+18]
ELSE
    ROW     equ  word ptr [bp+ 4]
    COL     equ  word ptr [bp+ 6]
    LROW    equ  byte ptr [bp+ 8]
    LCOL    equ  word ptr [bp+10]
    BUFFER  equ dword ptr [bp+12]
    BUFNCOL equ  word ptr [bp+16]
ENDIF
; void pwv_save(int srow, int scol, int nrow, int ncol, unsigned int far *buffer, int size);
_pwv_save PROC
    push    bp                              ; entry sequence
    mov     bp, sp

    push    ds
    push    si
    push    di


    mov     ax, ROW
    imul    word ptr __pwv_scrncol          ; ax = (srow)*ncol

    add     ax, COL
    shl     ax, 1                           ; ax = (ROW*scrncol + COL)*2
    mov     dx, ax

    mov     ax, __pwv_scrncol
    sub     ax, LCOL
    shl     ax, 1                           ; ax = add src
    mov     bx, BUFNCOL
    sub     bx, LCOL
    shl     bx, 1                           ; bx = add dest
    les     di, BUFFER                      ; es:[di] = dest (buffer)
    lds     si, __pwv_scrbuf
    add     si, dx                          ; ds:si = src (screen)
    mov     dl, LROW                        ; dl = nrow
    mov     cx, LCOL                        ; cx = ncol
    call    CopyBlock

    pop     di
    pop     si
    pop     ds
    pop     bp                              ; exit sequence
    ret
_pwv_save ENDP

IF CODE_FAR
    ROW    equ  word ptr [bp + 6]
    COL    equ  word ptr [bp + 8]
    LROW    equ  byte ptr [bp +10]
    LCOL    equ  word ptr [bp +12]
    BUFFER  equ dword ptr [bp+14]
    LEVEL   equ  byte ptr [bp+18]
ELSE
    ROW    equ  word ptr [bp + 4]
    COL    equ  word ptr [bp + 6]
    LROW    equ  byte ptr [bp + 8]
    LCOL    equ  word ptr [bp +10]
    BUFFER  equ dword ptr [bp+12]
    LEVEL   equ  byte ptr [bp+16]
ENDIF

;void pwv_levelblock(int srow, int scol, int nrow, int ncol, unsigned char far *buffer, int level)
_pwv_levelblock PROC
    push    bp                              ; entry sequence
    mov     bp, sp
    push    di

    mov     ax, ROW
    imul    word ptr __pwv_scrncol        ; ax=       (srow*ncol)
    add     ax, COL                       ; ax=       (srow*ncol)+scol
    les     di, BUFFER
    add     di, ax
    mov     dl, LROW                        ; dl = nrow
    mov     al, LEVEL
levelblock1:
    push    di
    mov     cx, LCOL                        ; cx = ncol
    repnz   stosb
    pop     di
    add     di, word ptr __pwv_scrncol
    dec     dl
    jnz     levelblock1

levelblock_e:
    pop     di
    pop     bp                              ; exit sequence
    ret
_pwv_levelblock ENDP

IF CODE_FAR
    DEST  equ   dword ptr [bp+ 6]
    DNCOL equ   word  ptr [bp+10]
    SRC   equ   dword ptr [bp+12]
    SNCOL equ   word  ptr [bp+16]
    LROW  equ   byte  ptr [bp+18]
    LCOL  equ   word  ptr [bp+20]
ELSE
    DEST  equ   dword ptr [bp+ 4]
    DNCOL equ   word  ptr [bp+ 8]
    SRC   equ   dword ptr [bp+10]
    SNCOL equ   word  ptr [bp+14]
    LROW  equ   byte  ptr [bp+16]
    LCOL  equ   word  ptr [bp+18]
ENDIF

;void pwv_moveleft(PWCELL far *dest, int destncol, PWCELL far *src, int srcncol, int nrow, int ncol)
_pwv_moveleft PROC
    push    bp                              ; entry sequence
    mov     bp, sp
    push    ds
    push    si
    push    di

    shl     DNCOL, 1
    shl     SNCOL, 1
    les     di, DEST                        ; es:di = dest
    lds     si, SRC                         ; ds:si = src
    mov     dl, LROW                        ; dl = nrow
moveleft1:
    push    di
    push    si
    mov     cx, LCOL                        ; cx = ncol
    repnz   movsw                           ; es:[di++] = ds:[si++]
    pop     si
    pop     di
    add     si, SNCOL
    add     di, DNCOL
    dec     dl
    jnz     moveleft1

moveleft_e:
    pop     di
    pop     si
    pop     ds
    pop     bp                              ; exit sequence
    ret
_pwv_moveleft ENDP

;void pwv_moveright(PWCELL far *dest, int destncol, PWCELL far *src, int srcncol, int nrow, int ncol)
_pwv_moveright PROC
    push    bp                              ; entry sequence
    mov     bp, sp
    push    ds
    push    si
    push    di
    std

    shl     DNCOL, 1
    shl     SNCOL, 1
    shl     LCOL, 1
    les     di, DEST                        ; es:di = dest
    add     di, LCOL
    lds     si, SRC                         ; ds:si = src
    add     si, LCOL
    mov     dl, LROW                        ; dl = nrow
    shr     LCOL, 1
moveright1:
    push    di
    push    si
    mov     cx, LCOL                        ; cx = ncol
    repnz   movsw                           ; es:[di--] = ds:[si--]
    pop     si
    pop     di
    sub     si, SNCOL
    sub     di, DNCOL
    dec     dl
    jnz     moveright1

moveright_e:
    cld
    pop     di
    pop     si
    pop     ds
    pop     bp                              ; exit sequence
    ret
_pwv_moveright ENDP

IF CODE_FAR
    DEST  equ   dword ptr [bp+ 6]
    DNCOL equ   word  ptr [bp+10]
    LROW  equ   byte  ptr [bp+12]
    LCOL  equ   word  ptr [bp+14]
    CELL  equ   word  ptr [bp+16]
ELSE
    DEST  equ   dword ptr [bp+ 4]
    DNCOL equ   word  ptr [bp+ 8]
    LROW  equ   byte  ptr [bp+10]
    LCOL  equ   word  ptr [bp+12]
    CELL  equ   word  ptr [bp+14]
ENDIF

;void pwv_fillblock(PWCELL far *dest, int destncol, int nrow, int ncol, PWCELL cell)
_pwv_fillblock PROC
    push    bp                              ; entry sequence
    mov     bp, sp
    push    di

    mov     bx, DNCOL
    sub     bx, LCOL
    shl     bx, 1                           ; bx = dest add

    les     di, DEST                        ; es:di = dest
    mov     ax, CELL                        ; ax = cell
    mov     dl, LROW                        ; dl = nrow
fillblock1:
    mov     cx, LCOL                        ; cx = ncol
    repnz   stosw                           ; es:[di++] = ax
    add     di, bx
    dec     dl
    jnz     fillblock1

fillblock_e:
    pop     di
    pop     bp                              ; exit sequence
    ret
_pwv_fillblock ENDP

CopyBlock PROC NEAR
    ; DS:SI = src
    ; ES:DI = dest
    ; CX    = word count
    ; AX    = src add
    ; BX    = dest add
    push    cx
    repnz   movsw                           ; es[di++] = ds[si++]
    add     si, ax
    add     di, bx
    pop     cx
    dec     dl
    jnz     CopyBlock
    ret
CopyBlock ENDP

; AL    = byte to write
; DS:SI = pointer to write buffer
hretrace_byte PROC NEAR
    push    dx
    push    ax
    mov     dx, 03dah                       ; video status port
hretrace_byte1:                             ; wait 4 end of retrace
    in      al, dx                          ; read port
    and     al, 1                           ; test bit 0 (horiz. retrace)
    jne     hretrace_byte1                  ; until low
hretrace_byte2:                             ; wait 4 start of retrace
    in      al, dx                          ; read port
    and     al, 1                           ; test bit 0
    je      hretrace_byte2                  ; until raised
    pop     ax
    mov     byte ptr ds:[si], al            ; it's save to write now
    pop     dx
    ret
hretrace_byte ENDP

; AX    = word to write
; DS:SI = pointer to write buffer
hretrace_word PROC NEAR
    push    dx
    push    ax
    mov     dx, 03dah                       ; video status port
hretrace_word1:                             ; wait 4 end of retrace
    in      al, dx                          ; read port
    and     al, 1                           ; test bit 0 (horiz. retrace)
    jne     hretrace_word1                  ; until low
hretrace_word2:                             ; wait 4 start of retrace
    in      al, dx                          ; read port
    and     al, 1                           ; test bit 0
    je      hretrace_word2                  ; until raised
    pop     ax
    mov     word ptr ds:[si], ax            ; it's save to write now
    pop     dx
    ret
hretrace_word ENDP

;__pwv_retrace PROC NEAR
;    push    dx
;    mov     dx, 03dah                       ; video port
;retrace1:
;    in      al, dx                          ; read port
;    and     al, 8                           ; test bit 0
;    je      retrace1                        ; until raised
;retrace2:
;    in      al, dx                          ; read port
;    and     al, 8                           ; test bit 0
;    jne     retrace2                        ; until low
;    pop     dx
;    ret
;__pwv_retrace ENDP

;    cmp     dl, 17                          ; max 18 lines per retrace
;    jne     display_f
;display_s2:
;    cmp     word ptr __pwcf_mode, 2         ; bios video ?
;    je      display_s3
;    cmp     word ptr __pwcf_mode, 1         ; slow video ?
;    jne     display_f
;display_s3:
;IF CODE_FAR
;    call FAR PTR __pwv_retrace
;ELSE
;    call    __pwv_retrace
;ENDIF
;display_f:

; reduce code by one standard calc_scroff function for:
;   _pwv_cursor
;   _pwv_getcellat
;   _pwv_rawsat

END


