/*************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IP.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/2/26
**
** DESCRIPTION: Supplies the interface and the typedefs for
**              the IP package.
**
**************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** CHANGER:     $Author:   etstjan  $
** WORKFILE:    $Workfile:   IP.H  $
** LOGFILE:     $Logfile:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IP.H_V  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IP.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:40:40   etstjan
**              No explicit note
*************************************************************************/
#define DEBUGALL
#ifdef DEBUGALL
#  define DEBUGROUT
#  define DEBUGBM
#  define DEBUGANY 
#else
#  ifdef DEBUGROUT
#    define DEBUGANY
#  endif
#  ifdef DEBUGBM
#    define DEBUGANY
#  endif
#endif
 
#define LITTLE_ENDIAN                       /* define byte order          */

/* masks for option copying and fragmentation */
#define   COPY_MASK        0x80          /* copy option on fragmentation   */
#define   DONT_FRAGMENT    0x2           /* don't fragment bit             */
#define   MORE_FRAGMENT    0x1           /* more fragments bit             */

/* masks for IP header option state byte */
#define   LOOSE_SRC        0x1           /* loose source route completed   */
#define   STRICT_SRC       0x2           /* strict source route completed  */
#define   REC_ROUTE        0x4           /* packet with recorded route     */
#define   TIME_ST          0x8           /* packet with timestamp          */

/* masks for routing table entry status flags */
#define   HOST             0x1           /* host or gateway entry          */
#define   UP               0x2           /* interface up or down           */
#define   STATIC           0x4           /* entry may not be modified      */
#define   MODIFIED         0x8           /* entry has been modified        */

/* type of data in a datalink */
#define   ARPDATAHD        0             /* it's an ARP packet             */
#define   RARPDATAHD       1             /* RARP is also possible          */
#define   IPHD             2             /* it's a IP header block         */
#define   OPTIONSHD        3             /* block contains the options     */
#define   UDPHD            4             /* UDP header block               */
#define   ICMPHD           5             /* ICMP header block              */
#define   SNMPHD           6             /* SNMP header block              */
#define   DATAHD           7             /* data block                     */


typedef enum {
          NETSTAT,                        /* add static net routing entry  */
          NETMODIFY,                      /* modify net routing table      */
          HOSTSTAT,                       /* add static host routing entry */
          HOSTMODIFY                      /* modify host routing table     */
          } NETHOST;

typedef enum {                            /* select a network device       */
          ND0,                            /* ethernet interface            */
          LO0                             /* loopback interface            */
          } NETDEVICE;

typedef enum {
          UNMASKED,                       /* don't mask when searching     */
          MASKED                          /* do mask                       */
          } MASKCHOICE;

typedef enum {
          DO_ROUTE,                       /* allow IP routing of rec'd     */
          DONT_ROUTE                      /* do not allow IP routing       */
          } RT_CHOICE;

typedef enum {
          DIRECT_ONLY,                    /* only to connected network     */
          HOPS_ALLOWED                    /* using gateways allowed        */
          } DIR_CHOICE;

typedef enum {                            /* possible priorities           */
          HIGH = 0,
          LOW  = 1
          } PRIORITY;

typedef   int               TOS_KIND;     /* type of service               */

typedef   ULONG             ADDRESS_T;    /* type of an IP address         */

typedef   BYTE              HARDW_ADD[6]; /* hardware add. type (ethernet) */

typedef struct _datalink {                /* structure of a datalink block */
          BYTE              ThisType;     /* what is in this datalink?     */
          BYTE              SaveData;     /* save data in this link?       */
          struct _datalink  *NextOne;     /* pointer to next datalink      */
          BYTE              *DataArea;    /* pointer to data area          */
          BYTE              *DataStart;   /* pointer to start of data      */
          USHORT            Length;       /* length of data area           */
          struct _datalink  *NextLink;    /* for queueing purposes         */
          } DATALINK;

typedef struct _ciphead {                 /* IP Header in C structure      */
          BYTE              Version;      /* Version Number                */
          BYTE              HLength;      /* IP Header length (bytes)      */
                                          /* must be a multiple of 4       */
          BYTE              Tos;          /* Type of service               */
          USHORT            TLength;      /* Total packet length           */
          USHORT            Ident;        /* Identification                */
          BYTE              Flag;         /* Flags (in 3 bits)             */
          USHORT            Offset;       /* Fragment offset               */
          BYTE              Time;         /* Time to live                  */
          BYTE              Protocol;     /* Protocol number               */
          USHORT            CheckSum;     /* Header checksum               */
          ADDRESS_T         Source;       /* Source Address                */
          ADDRESS_T         Destin;       /* Destination Address           */
          USHORT            OLength;      /* length of options (bytes)     */
          BYTE              Options[44];  /* Option space                  */
          USHORT            OpState;      /* State of rec'd option space   */
          ADDRESS_T         ExtraAddress; /* First hop & specific destin.  */
          } CIPHEAD;

typedef struct _cudphead {                /* UDP Header in C structure     */
          USHORT            SPort;        /* Source Port Specification     */
          USHORT            DPort;        /* Destination Port Spec         */
          USHORT            DLength;      /* Length of datagram + header   */
          USHORT            CheckSum;     /* Header checksum               */
          } CUDPHEAD;

typedef struct _cicmphead {               /* ICMP Header in C structure    */
          BYTE              Type;         /* Message type                  */
          BYTE              Code;         /* Message code                  */
          USHORT            CheckSum;     /* Messager checksum             */
          union _moreinfo {
            ADDRESS_T       GateWayAdd;   /* Gateway Internet Address      */
            BYTE            Pointer;      /* Pointer in header             */ 
            USHORT          IdSeq[2];     /* Identifier and Sequence       */ 
            } MoreInfo;
          } CICMPHEAD;

typedef struct _ifaddress {               /* interface address structure   */
          ADDRESS_T         ThisAddress;  /* if local address              */
          ADDRESS_T         BroadCastAd;  /* broadcast / pnt-pnt address   */
          struct _ifaddress *NextAddress; /* next interface address        */
          } IFADDRESS;

typedef enum {                            /* kind of link layer requests   */
          SENDREQ,                        /* request to send               */
          BROADREQ                        /* request to broadcast          */
          } LLREQ;

typedef struct _ifdesc {                  /* general if descriptor         */
          char              IfName[16];   /* interfaces logical name       */
          struct _ifdesc    *NextIf;      /* linked list pointer           */
          struct _ifdesc    *BCastLink;   /* interfaces for broadcasting   */
          USHORT            Mms_S;        /* maximum packet size send      */
          USHORT            Mms_R;        /* or received                   */
          USHORT            Flags;        /* if characteristics            */
          IFADDRESS         *FirstAdd;    /* pointer to if addresses       */
                                          /* pointer to send function      */
          int (*SendFun)(LLREQ, DATALINK *, ADDRESS_T);
          int (*IoContrlFun)(void *);     /* pointer to control function   */
          HARDW_ADD         HardwAddr;    /* hardware address (ethernet)   */
          USHORT            IntNo;        /* send interrupt number         */ 
          USHORT            NrSend;       /* statistic info                */
          USHORT            NrReceived;
          USHORT            NrOutErrors;
          USHORT            NrInErrors;
          USHORT            NrSendReq;    /* number of send requests       */
          USHORT            NrRecReq;     /* number of receive requests    */
          USHORT            NrBufFull;    /* # times send buffer full      */    
          USHORT            NrSysErrors;  /* errors in schedule, buffer    */
                                          /* allocation etc.               */           
          } IFDESCRIPTOR;


typedef struct {                          /* reassembly structure          */
          CIPHEAD           *ReassHeader; /* header packet in reass.       */
          BYTE              *ReassBuffer; /* reassembly buffer             */
          DATALINK          *SavePack;    /* save packet for icmp mes.     */ 
          USHORT            ReassLen;     /* total reassembled length      */
          int               FirstHole;    /* offset first hole descriptor  */
          } REASSTYPE;

/***************************************************************************/
typedef struct {                          /* IP layer statistics           */
          /* IP section */
          ULONG             NrPackRec;    /* # packets received            */
          ULONG             NrFragRec;    /* # fragments received          */
          ULONG             NrPackSend;   /* # send requests               */
          ULONG             NrFragSend;   /* # fragments send              */
          ULONG             NrIllOptions; /* # times illegal options in p. */
          ULONG             NrBCastS;     /* # broadcasts sent             */
          ULONG             NrBadVersion; /* # rec. with bad version       */
          ULONG             NrCheckErr;   /* # bad checksums               */
          ULONG             NrTooShort;   /* # rec. with insuf. length     */
          ULONG             NrBadLength;  /* # TLength > packet length     */
          ULONG             IllBCast;     /* IP broadcast, link layer not  */
          ULONG             LimBroadCast; /* # limited broadcasts          */
          ULONG             DirecBrdC;    /* # directed broadcasts         */
          ULONG             SubNetDir;    /* # subnet directed broadc.     */
          ULONG             IllSndOption; /* # illegal options on sending  */
          ULONG             IllHeader;    /* # illegal headers on sending  */
          ULONG             NrReassError; /* # reass error occured         */
          ULONG             NoReassSpace; /* # no reass space available    */
          ULONG             ErrSrcRoute;  /* # errors in source routing    */
          ULONG             ReassTimeOut; /* # reassembly time outs        */
          ULONG             RoutTimExc;   /* # TTL->0 on routing           */
          ULONG             NotForwarded; /* # fails to forward a packet   */
          ULONG             RouteNotAll;  /* # no forwarding allowed       */
          ULONG             Forwarded;    /* # packets forwarded           */
          /* Received options statistics */
          ULONG             NrRecRoute;   /* # record route options        */
          ULONG             NrTimeStamp;  /* # timestamp options           */
          ULONG             NrLooseSrc;   /* # loose source route options  */
          ULONG             NrStrictSrc;  /* # strict source route options */
          /* ARP section */
          ULONG             NrARPShort;   /* # times ARP request too short */
          ULONG             ARPRec[3];    /* # ARP received                */
                                          /* [0] = error                   */
                                          /* [1] = ARP request             */
                                          /* [2] = ARP reply               */
          ULONG             NrARPReqS;    /* # ARP requests send           */
          ULONG             NrARPRepS;    /* # ARP replies send            */
          /* ICMP section */
          ULONG             NrICMPChkErr; /* # ICMP checksum errors        */
          ULONG             NrICMPShort;  /* # ICMP < 8 bytes              */
          ULONG             NrICMPIncom;  /* # ICMP messages incomplete    */
          ULONG             NrEchoReqR;   /* # ICMP echo requests rec'd    */
          ULONG             NrEchoRepR;   /* # ICMP echo replies rec'd     */
          ULONG             NrTimeStReqR; /* # ICMP timestamp req. rec'd   */
          ULONG             NrTimeStRepR; /* # ICMP timestamp reply rec'd  */
          ULONG             UnRchR[7];    /* # unreachable received        */
                                          /* [0] = net unreachable         */
                                          /* [1] = host unreachable        */
                                          /* [2] = protocol unreachable    */
                                          /* [3] = port unreachable        */
                                          /* [4] = frag. needed & DF set   */
                                          /* [5] = source route failed     */
                                          /* [6] = other                   */
          ULONG             TimExR[3];    /* # time exceeded received      */
                                          /* [0] = time to live exceeded   */
                                          /* [1] = fragment reass. time    */
                                          /* [2] = other                   */
          ULONG             RedirecR[5];  /* # redirects received          */
                                          /* [0] = network redirect        */
                                          /* [1] = host redirect           */
                                          /* [2] = tos & net redirect      */
                                          /* [3] = tos & host redirect     */
                                          /* [4] = other                   */
          ULONG             NrModRed;     /* # routing entries modified    */
          ULONG             NrSrcQueR;    /* # source quench received      */
          ULONG             NrParamProbR; /* # parameter problem rec'd     */
          ULONG             NrEchoRepS;   /* # ICMP echo replies send      */
          ULONG             UnRchS[7];    /* # unreachable send            */
                                          /* [0] = net unreachable         */
                                          /* [1] = host unreachable        */
                                          /* [2] = protocol unreachable    */
                                          /* [3] = port unreachable        */
                                          /* [4] = frag. needed & DF set   */
                                          /* [5] = source route failed     */
                                          /* [6] = other                   */
          ULONG             TimExS[3];    /* # time exceeded send          */
                                          /* [0] = time to live exceeded   */
                                          /* [1] = fragment reass. time    */
                                          /* [2] = other                   */
          ULONG             NrEchoReqS;   /* # ICMP echo requests send     */
          ULONG             NrTimeStReqS; /* # ICMP timestamp req. send    */
          ULONG             NrRedirecS;   /* # redirects send              */
          ULONG             NrSrcQueS;    /* # source quench send          */
          ULONG             NrTimeStRepS; /* # ICMP timestamp reply send   */
          ULONG             NrParamProbS; /* # parameter problem send      */
          ULONG             NrOtherS;     /* # other ICMP send             */
          /* UDP section */
          ULONG             NrUDPRec;     /* # UDP received                */   
          ULONG             NrUDPShort;   /* # UDP < 8 bytes               */
          ULONG             NrUDPChkErr;  /* # UDP checksum errors         */
          ULONG             NrNoUDPCheck; /* # no UDP checksum             */
          ULONG             NrNoUDPSock;  /* # no UDP socket               */    
          /* Raw section */
          ULONG             NrRawRec;     /* # packets for raw socket      */
          ULONG             NrNoRawSock;  /* # no Raw socket               */ 
          /* General section */
          ULONG             TimesNoBuf;   /* # times no buffer available   */
          ULONG             QueueFull;    /* # socket queue full           */
          } IPSTAT;

/***************************************************************************/

typedef struct _ipaddress {               /* IP host address structure     */
          ADDRESS_T         HostAddress;  /* IP host address               */
          ADDRESS_T         NetWorkPart;  /* network part of IP address    */ 
          ADDRESS_T         SubNetPart;   /* subnet part (includes network)*/ 
          ADDRESS_T         NetWorkMask;  /* IP network mask               */
          ADDRESS_T         SubNetMask;   /* IP subnet mask                */
          ADDRESS_T         NetMask;      /* complete IP network mask      */
          ADDRESS_T         HostMask;     /* mask for host part            */
          ADDRESS_T         SubHostMask;  /* mask for subnet and host part */
          ADDRESS_T         FirstHop;     /* first hop for this destination*/ 
          IFDESCRIPTOR      *AddressIf;   /* interface for this address    */
          USHORT             Flags;        /* status flags for routing entry*/ 
          struct _ipaddress *NextAddress; /* next interface address        */
          } IPADDRESS;

typedef struct _arp_entry {               /* ARP table entry               */
          struct _arp_entry *NextEntry;   /* for linked list               */
          struct _arp_entry *PrevEntry;   /* double linked list            */
          ADDRESS_T         IPAddress;    /* IP address                    */
          HARDW_ADD         EthAddress;   /* associated ethernet address   */
          USHORT            TimeValue;    /* time out value for this entry */
          USHORT            RetryTimer;   /* time out for retries          */ 
          USHORT            RefCount;     /* # times entry used            */
          USHORT            RetryCount;   /* # solving tries               */
          BYTE              *Waiting;     /* packet waiting for ARP entry  */
          USHORT            WaitLen;      /* length of waiting packet      */
          IFDESCRIPTOR      *ThisIf;      /* interface for this entry      */
          } ARP_ENTRY;

typedef union {                           /* union for scheduling events   */
        struct {                          /* used when receiving packets   */
          IFDESCRIPTOR      *If;          /* if which received message     */
          DATALINK          *RecPacket;   /* Received packet               */
          int               LinkBrdCst;   /* Received by broadcast?        */
          } RecData;                      
        struct {                          /* timeout reassembly buffer     */
          REASSTYPE         *ReassStruct; /* pnt to reassembly structure   */
          } ReassData;                    
        struct {                          /* time out on ARP entry         */
          ARP_ENTRY         *ARPEntry;    /* entry to be timed out         */
          } ARPData;
        struct {                          /* for test purposes             */
          char              *TestString;         
          int               TestInt;
          } TestData;                     
        } EVENTUNION;


/* define macro's */
#define   UPDSTAT(Ar, MxIn)  IPStat.Ar[(ICMPHeader->Code < MxIn) ? \
                                       ICMPHeader->Code : MxIn]++;

