//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-05-93	created
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TDeskTop
#define Uses_THistory
#define Uses_TButton
#include"tdoslynx.h"
#include"trace.h"
#include"turlwind.h"
#include<ctype.h>

void TDosLynx::OpenURL(const char *cp_URL)	{
//	Purpose:	Open a URL
//	Arguments:	cp_URL	The url to load.
//	Return Value:   void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created
//		12-30-93        Disabled passing in URL name as argument
//				Added dialog to ask for URL name
//		01-05-94	Modified not to use a derived dialog since
//				unable to make buttons draw correctly.
//				Still didn't work.
//				Increased button rectangle size to two lines,
//				worked!
//				Why the hell isn't that documented anywhere?
//		04-07-94	Added ability to pass in a URL.

#ifndef RELEASE
	trace("Opening URL");
#endif // RELEASE

	if(cp_URL == NULL)	{
		//	General use rectangle
		TRect TR(0, 0, 74, 15);

		//	Create the URL dialog to get the URL name.
		TDialog *TURLD = (TDialog *)validView(new TDialog(TR,
			"Open URL"));

		//	Center the dialog
		TURLD->options |= ofCentered;

		//	Make the input line.
		TR = TRect(5, 4, 68, 5);
		TInputLine *TIL_URLEntry = (TInputLine *)validView(new
			TInputLine(TR, usi_TILURLSize - 1));
		TURLD->insert(TIL_URLEntry);

		//	Make the input line's label.
		TR = TRect(4, 3, 68, 4);
		TURLD->insert(validView(new TLabel(TR, "~U~RL",
			TIL_URLEntry)));

		//	Make the input line's history list.
		TR = TRect(69, 4, 72, 5);
		TURLD->insert(validView(new THistory(TR, TIL_URLEntry,
			usi_OpenURLHist)));

		//	Make the OK, Cancel, and Help buttons.
		TR = TRect(21, 11, 33, 13);
		TURLD->insert(validView(new TButton(TR, "~O~K", cmOK,
			bfDefault)));
		TR = TRect(40, 11, 52, 13);
		TURLD->insert(validView(new TButton(TR, "~C~ancel", cmCancel,
			bfNormal)));

		//	Stay in the URL field
		TURLD->selectNext(False);

		//	Draw the dialog
		TURLD->drawView();

		//	Ensure creation, execution.
		//	If user cancelled, code will do nothing.
		if(TURLD != NULL && deskTop->execView(TURLD) != cmCancel)
		{
			//	Small temporary buffer to hold URL name.
			auto char ca_buffer[usi_TILURLSize];

			//	Get information from the Input line.
			TIL_URLEntry->getData(ca_buffer);

			//	Remove whitespace from the front of the line.
			if(isspace(ca_buffer[0]))	{
				char *cp_temp = ca_buffer + 1;

				while(isspace(*cp_temp))
					cp_temp++;

				int i_traverse;
				for(i_traverse = 0; *cp_temp != '\0';
					i_traverse++)	{
					ca_buffer[i_traverse] = *cp_temp++;
				}

				ca_buffer[i_traverse] = '\0';
			}

			//	Only if we actually received a URL entry do we
			//		to process it.
			if(ca_buffer[0] != '\0')	{
				//	Create our new valid window.
				TView *TV_new = validView((TView *)new
					TURLWindow(ca_buffer));

				//	If not created, don't insert.
				if(TV_new != NULL)
					deskTop->insert(TV_new);
			}
		}

		//	Release the dialog.
		if(TURLD != NULL)	{
			destroy(TURLD);
		}
	}
	else	{
		//	URL name passed in.  Load it.
		//	Create our new valid window.
		auto TView *TV_new2 = validView((TView *)new
			TURLWindow(cp_URL));

		//	If not created, don't insert onto the desktop.
		if(TV_new2 != NULL)
			deskTop->insert(TV_new2);
	}
}