//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-94	Split all members into seperate files to
//				enhance overlay support.
#define Uses_TDeskTop
#include"tdoslynx.h"
#include"tcapture.h"
#include"gridtext.h"
#include"globals.h"
#include<new.h>

TDosLynx::~TDosLynx()	{
//	Purpose:	Destructor
//	Arguments:	void
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created

	doslynxmessage("Shutting down application.  Please wait...");

	//	Go through the loaded HTexts and destroy them.
	HText *HTp_text;
	while(::TNSCp_LoadedHTexts->getCount() > 0)	{
		//	Remove the HText from the collection first.
		HTp_text = (HText *)(::TNSCp_LoadedHTexts->at(0));
		//	Free it.  HText_free removes the HText from the
		//	collection.
		::HText_free(HTp_text);
	}
	//	Destroy the HText collection.
	destroy(::TNSCp_LoadedHTexts);

	//	Free our global ini path
	if(cp_inipath != NULL)
		delete(cp_inipath);
	//	Free the global temp dir
	if(cp_TempDir != NULL)
		delete(cp_TempDir);
	//	Free the global mail address
	if(cp_ReplyTo != NULL)	{
		delete(cp_ReplyTo);
	}
	//	Free the global printer
	if(cp_Printer != NULL)	{
		delete(cp_Printer);
	}
	//	Free the global home address
	if(cp_Home != NULL)	{
		delete(cp_Home);
	}
	//	Free the global hotlist path
	if(cp_HotList != NULL)	{
		delete(cp_HotList);
	}
	//	Free the global errorhtml filename
	if(cp_ErrorHTML != NULL)	{
		delete(cp_ErrorHTML);
	}
	//	Free the global news host.
	if(cp_nntphost != NULL)	{
		delete(cp_nntphost);
	}
	//	Free the proxy variables.
	if(cp_http_proxy != NULL)	{
		delete(cp_http_proxy);
	}
	//	Free the proxy variables.
	if(cp_gopher_proxy != NULL)	{
		delete(cp_gopher_proxy);
	}
	//	Free the proxy variables.
	if(cp_ftp_proxy != NULL)	{
		delete(cp_ftp_proxy);
	}
	//	Free the proxy variables.
	if(cp_wais_proxy != NULL)	{
		delete(cp_wais_proxy);
	}

	//	Reset the old memory handler.
	set_new_handler(vfp_old_new_handler);
}