//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		THeapView
//	Include File:	THeapView.H
//	Purpose:	Display amount of remaining heap memory
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created
//		02-10-94	Split all members into seperate files.
#include"theapview.h"
#include"tcapture.h"
#include<alloc.h>
#include<strstrea.h>
#include<string.h>
#include<iomanip.h>

long THeapView::GetHeapSize()	{
//	Purpose:	Return the free heap size
//	Arguments:	void
//	Return Value:	long	the free heap size
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created

	//	get a total on free far memory
	long total = farcoreleft();
	struct farheapinfo heap;
	ostrstream totalStr(HeapInAscii, sizeof(HeapInAscii));

	//	switch and print an return the appropriate value.
	//	Note an ascii message correlating to the return value is
	//	put in the data member HeapInAscii.
	switch(farheapcheck())	{
	case _HEAPEMPTY:
		strcpy(HeapInAscii, "     No heap");
		total = -1L;
		break;
	case _HEAPCORRUPT:
		if(B_tolduser == False)	{
			doslynxmessage("Heap found to be corrupt.");
			doslynxmessage("Consider leaving the application.");
			B_tolduser = True;
		}
		strcpy(HeapInAscii, "Heap corrupt");
		total = -2L;
		break;
	case _HEAPOK:
		heap.ptr = NULL;
		while(farheapwalk(&heap) != _HEAPEND)
			if(!heap.in_use)
				total += heap.size;
		totalStr << setw(12) << total << ends;
		break;
	}

	return(total);
}