;		bufs.inc
;========================================================================

; Copyright (C) 1991-94 by Jan.Engvald@ldc.lu.se, see file COPYING.

GIANTTR         equ     4096
BUFBODYSML	equ	2*6+2+34+NBUFSMALM	; optimized for ping length sweep

BUFSIZE 	equ	4*((GIANT+DESCRLEN + 2*MAX_ADDR_LEN - 2*EADDR_LEN + SNAPLEN+3)/4)
BUFSIZETR       equ     4*((GIANTTR+DESCRLEN + 2*MAX_ADDR_LEN - 2*EADDR_LEN + SNAPLEN+3)/4)
BUFSIZESML	equ	4*((BUFBODYSML+DESCRLEN+3)/4)

NBUFS		equ	(StackLow-BufStart-NBUFSMALM*BUFSIZESML)/BUFSIZE
NBUFSTR         equ     (StackLow-BufStart-NBUFSMALM*BUFSIZESML)/BUFSIZETR
NBUFSMALL	equ	(StackLow-BufStart-NBUFS*BUFSIZE)/BUFSIZESML

LinkStruc	struc
dNext		dd	0			; forward link
dPrev		dd	0			; back link
dHomeList	dw	0			; list to release it to
LinkStruc	ends

LinkHead	struc
lNext		dd	0			; forward link
lPrev		dd	0			; back link
lBufsAvail	dw	0			; number of buffers
LinkHead	ends
LINKHEADLEN	equ	SIZE LinkHead

		even
MyGiant         dw      GIANT
MyNbufs         dw      NBUFS
MyBufsize       dw      BUFSIZE

if DEBUG
MaxAvail	dw	0
MinAvail	dw	-1
endif ; DEBUG


SendToDo LinkHead <offset SendToDo, offset SendToDo> ; arp reply list
FreeBufs LinkHead <offset FreeBufs, offset Freebufs> ; head of free buffer chain

ifdef SMALLBUFS
FreeSmal LinkHead <offset FreeSmal, offset FreeSmal> ; head of free buffer chain
endif ; SMALLBUFS

if RFCC
IcmpToDo LinkHead <offset IcmpToDo, offset IcmpToDo> ; icmp reply list
FragList LinkHead <offset FragList, offset FragList> ; fragm reassembly
endif ; RFCC

if TBLBUILD or PINGCLIENT
NameToDo LinkHead <offset NameToDo, offset NameToDo> ; name server replies
endif ; TBLBUILD or PINGCLIENT

if TBLBUILD
TblToDo  LinkHead <offset TblToDo, offset TblToDo>  ; build hw addr tbl
endif ; TBLBUILD

LINKHEADS	equ	($-SendToDo)/LINKHEADLEN

;========================================================================
;		endinclude
