/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/ftpbin.c_v   1.0   15 Jan 1990 19:26:20   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/ftpbin.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:20   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   ftpbin.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*
*  User FTP
*  6/8/87
****************************************************************************
*                                                                          *
*      by Tim Krauskopf and Swami Natarajan                                *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*                                                                          *
****************************************************************************
*/
#include "stdio.h"
#include <process.h>
#include "fcntl.h"
#include "nkeys.h"
#include "ctype.h"
#include "hostform.h"
#include "whatami.h"

#include "newwin.h"
#ifdef	__TURBOC__
#include <string.h>
#include <stdlib.h>
#include <io.h>
#else
#ifdef	_MSC_
#include <signal.h>
#include <direct.h>
#include <string.h>
#include <stdlib.h>
#else
extern unsigned char *malloc();
#endif
#endif
#ifdef  PC
#if defined(_MSC_)|defined(__TURBOC__)
#define O_RAW O_BINARY
#ifdef	_MSC_
#define	_SIZE_T	1
#include <sys/types.h>
#endif
#include <sys/stat.h>
#endif
#endif

#define FASCII  0
#define FIMAGE  1

#define HFTP  21

#define FALSE	   0
#define TRUE	   1
#define SUCCESS	   2
#define ERROR	  -1
#define NONE	  -2
#define ABORT	  -3
#define INCOMPLETE -4
#define AMBIGUOUS -5
#define HAVEDATA   4

#define DOMAININFO      1

#if     defined(DOMAININFO)||defined(BOOTP)
#include "windat.h"

struct twin x,*console={&x},*current = {&x};
unsigned _ovrbuffer = 2048;

int numberoflines;
extern char *env_config;
nbgets()
{


}

vprint(int d, char *s)
{
	nprintf(SCREEN,"%s",s);
}

#endif

#ifdef  FTPPW
long    ftppassword;
#endif

int 
	xp=0,					/* general pointer */
	towrite=0,				/* file transfer pointer */
	len=0,					/* file transfer length */
	ftpnum,					/* current command port */
	ftpdata=-1,				/* current data port */
	ftpfh,					/* file handle for ftp */
	ftpstate=0,				/* state for background process */
	fcnt = 0,				/* counter for ftpd */
	ftpfilemode=0,				/* file open mode for transfer */
	foundbreak=0,				/* cntrl-break pending */
	connected=0,				/* not connected */
	debug=0,				/* debug level */
	hash=0,					/* hash mark printing */
	sendport=1,				/* to send ports or not */
	verbose=1,				/* informative messages */
	bell=0,					/* sound bell */
	autologin=1,				/* login on connect */
	prompt=1,				/* check on multiple commands */
	glob=1,					/* expand wildcards */
	slashflip=1,				/* change \ to / */
	capture=0,				/* capture data or not */
	fromtty=1;				/* default input from tty */

FILE
	*fromfp=NULL;				/* file pointer for input */

        
unsigned int curftpprt = 0,			/* port to use */
			ftpport();

unsigned char destname[50],			/* who to connect to */
		s[2048],			/* temporary string */
		captlist[2001],			/* response string */
		ftpcommand[200],		/* command to execute */
		*neterrstring();

char printline[100];				/* line to display */

#ifdef	__TURBOC__
extern int breakstop();
#else
static int breakstop();
#endif
static int userftpd();
char *stpblk(),*stptok();

#define BUFFERS 4096				/* size of buffer */
#define READSIZE 128				/* how much to read */

static unsigned char disaster[256];
static unsigned char xs[BUFFERS+4096];	/* buffer space for file transfer */
static unsigned char badme[256];

long
	time(),
	start=0L,				/* timing var */
	filesiz=0L;				/* length of current file for transfer */

VSwrite()		/* called from PCutil.c LoadWrite */
{
}

/************************************************************************/
/* main - main procedure.  Displays opening message, parses arguments,
/*	  initializes network, reads user commands and executes them, and
/*	  cleans up.
/************************************************************************/


main(argc,argv)
	int argc;
	char *argv[];
	{
	int i,c;
	static char Configfile[50]="config.tel";
	static char fromfile[20]="";

	n_which();
	n_window(0,0,rows-1,cols-1);			/* vt100 size */
	n_clear();
	nputs("");
#ifdef	__TURBOC__
	ctrlbrk(breakstop);
#else
#ifdef	_MSC_
	signal(SIGINT,&breakstop);		/* Microsoft intercept of break */
#else	
	onbreak(&breakstop);		/* break handler */
#endif
#endif

        if(getenv("CONFIGTEL"))
                strcpy(Configfile,getenv("CONFIGTEL"));
/*
*  initialize network
*/
	destname[0] = '\0';		/* destination unknown */
	
		/* parse arguments */
        botl = rows;                      /* a cheap hack for screen */

	for (i=1; i<argc; i++) {
	    if (argv[i][0]=='-') {
		switch(tolower(argv[i][1])) {
		    case 'v':		/* display informative messages */
			verbose = TRUE;
			break;
		    case 'n':		/* do not login on connect */
			autologin = FALSE;
			break;
		    case 'i':		/* interactive prompting off */
			prompt = FALSE;
			break;
		    case 'g':		/* wildcard expansion off */
			glob = FALSE;
			break;
		    case 'd':		/* debug, optional level */
			if (sscanf(&argv[i][2],"%d",&debug)<=0)
			    debug = TRUE;
			break;
		    case 's':		/* do not change \ to / */
			slashflip = FALSE;
			break;
		    case 'e' :			/* config.tel data */
		       	 env_config = argv[++i];
		  	 break;
		    case 'h':		/* host file name */
			strcpy(Configfile,argv[++i]);
			break;
		    case 'f':		/* noninteractive, optional filename */
			fromtty = FALSE;	/* noninteractive input */
			strcpy(fromfile,&argv[i][2]);
			if (fromfile[0]) {
			   fromfp = fopen(fromfile,"r");
			   if (fromfp==NULL) {
				nprintf(SCREEN,"Could not open file: %s\n",fromfile);
				return(1);
			   }
			}
			break;
		    default:		/* unknown option */
			nprintf(SCREEN,"Unrecognized option -%c ignored\n",argv[i][1]);
			break;
		}
	    }
	    else sscanf(argv[i],"%s",destname);		/* destination host */
	}


	if (Shostfile(Configfile)<0) {		/* cannot open host file */
	    nprintf(SCREEN,"Could not find hosts file.  Exiting.\n");
	    return(1);
	}
	if (Snetinit()) {			/* cannot initialize network */
	    printerr();				/* display TCP/IP message */
	    nprintf(SCREEN,"Error initializing network\n");
	    return(1);
	}

	if (destname[0]) sprintf(ftpcommand,"open %s",destname);
		/* if destination specified, connect to it */


	do {
		if (*ftpcommand) ftppi(ftpcommand);
			/* if command available, execute it */

		if (fromtty) n_row();		/* in case screen messed up */

		putstring("ftp> ");		/* prompt */
		c = ftpgets(ftpcommand,200,1);	/* read cmd from user */

	} while (c != AF3);			/* Alt-F3 aborts */


	netclose(ftpnum);			/* close command connection */
	netshut();				/* terminate network stuff */

	return(0);
}

/************************************************************************/
/* ftpgets - read a line from the keyboard
/*	     returns ABORT if aborted, non-zero on success
/************************************************************************/

ftpgets(s,lim,echo)
	char *s;		/* where to put the line */
	int lim,echo;		/* max chars to read, echo? */
	{
	unsigned int c;
	int count,i;
	char *save, *ret;

	count = 0;		/* none read */
	save = s;		/* beginning of line */

	if (foundbreak) {
	    foundbreak = 0;
	    *s = '\0';
	    nprintf(SCREEN,"\n");
	    return(ABORT);
	}
	if (!fromtty) {
	   if (fromfp==NULL) {
		ret = fgets(s,lim,stdin);
	   }
	   else {
		ret = fgets(s,lim,fromfp);
	   }
	   if (ret==NULL) {
		nprintf(SCREEN,"EOF or error on read from file\n");
		if (connected) {
		    ftpdo("QUIT","");
		    connected = FALSE;
		}
		netshut();
		exit(1);
	   }
	   s[strlen(s)-1] = '\0';	/* remove newline */
	   if (echo && fromfp) nprintf(SCREEN,"%s\n",s);
	   return (strlen(s));
	}
	while (1) {
		if (foundbreak) {	/* abort */
		    s = save;		/* reset line */
		    *s = '\0';		/* null line */
		    nprintf(SCREEN,"\n");		/* newline */
		    foundbreak = 0;	/* break processed */
		    return(ABORT);	
		}

		c = n_chkchar();	/* char available to read? */

		if (c == 0xffff) {		/* none available */
			checkevent();		/* check event queue */
			c = 0;
		}

		switch (c) {		/* allow certain editing chars */
			case 8:		/* backspace */
			case BACKSPACE:
				if (count) {
					if (echo) {
						nputchar(8);
						nputchar(' ');
						nputchar(8);
					}
					count--;	/* one less character */
					s--;		/* move pointer backward */
				}
				break;
			case 13:		/* carriage return, = ok */
				nprintf(SCREEN,"\n");	/* newline */
				*s = '\0';	/* terminate the string */
				return(c);	/* return ok */
				break;
			case 21:		/* kill line */
				for (i=0; i < s-save; i++) {	/* length of line */
					if (echo) {		/* erase */
						nputchar(8);
						nputchar(' ');
						nputchar(8);
					}
				}
				s = save;	/* reset line */
				break;
			case 0:			/* do nothing */
				break;
			default:		/* not special char */
				if (c > 31 && c < 127) {	/* printable */
					if (echo) nputchar(c);	/* display */
					*s++ = c;	/* add to string */
					count++;	/* length of string */
				}
				else		/* acts as eol */
					return(c);	/* value of special char */

				if (count == lim) {	/* to length limit */
					*s = '\0';	/* terminate */
					return(c);	
				}
			break;
		}

	}
}


/************************************************************************/
/* dumpcon
*  take everything from a connection and send it to the screen
*  return -1 on closed connection, else 0, 1 if paused
/************************************************************************/

dumpcon(cnum)
	int cnum;
	{
	int cnt;

	if (fromtty && n_scrlck()) return(TRUE);	/* if paused, nothing to do */

	do {
		cnt = netread(cnum,s,64);		/* get some from queue */

		telnet(cnt);				/* display on screen, etc.*/

					/* demux all packets */
	} while (cnt > 0);

	return(cnt);			/* 0 normally, -1 if connection closed */
}


/************************************************************************/
/*  telnet
*   filter telnet options on incoming data
/************************************************************************/

telnet(cnt)
	int cnt;
	{
	int i;


	for (i=0; i < cnt; i++) {			/* put on screen */
		if (s[i] & 128) {			/* if over ASCII 128 */
			nprintf(SCREEN," %d ",s[i]);	/* show as number */
		}
		else
			nprintf(SCREEN,"%c",s[i]);
	}

	return(TRUE);
}


#include "ftppi.h"		/* list of commands, help strings */

/********************************************************************/
/* FTP PI
*  Protocol interpreter for user interface commands
*  Will permit any command to be abbreviated uniquely.
*  Recognizes commands, translates them to the protocol commands to be
*  sent to the other server, and uses userftpd, the daemon, to do data
*  transfers.
/************************************************************************/

ftppi(command)
char *command;
{

int cmdno,i;
char cmdname[20],word[51],line[100],answer[20],ofilename[50];
char *p,*firstname(),*nextname();
struct machinfo *mp,*Sgethost();

if (debug>1) {			/* print command */
    nprintf(SCREEN,"command: %s\n",command);
}

	/* get command number */
if (!getword(command,cmdname)) return(FALSE);	/* get command name */
	/* removes first word from command */
lowercase(cmdname);
cmdno = finduniq(cmdname,ftp_cmdlist,NCMDS);	/* search cmdlist for prefix */
if (cmdno==AMBIGUOUS) {		/* not unique abbreviation */
	nprintf(SCREEN,"?Ambiguous command\n");
	return(FALSE);
}
if (cmdno==NONE) {		/* not a prefix of any command */
	nprintf(SCREEN,"?Invalid command\n");
	return(FALSE);
}

		/* change \ to / and check if command output redirected */
if (cmdno!=BANG) {		/* don't alter shell escape */
    if (cmdno!=LLS)		/* do not flip slashes for LLS */
        checkoredir(command,ofilename,slashflip);	/* check redirection, flip \ */
    else
        checkoredir(command,ofilename,FALSE);		/* check redirection */
}

	/* process commands */
switch (cmdno) {
	case QMARK:
	case HELP:
		if (!command[0]) {	/* no argument */
		    nprintf(SCREEN,"Commands may be abbreviated. Commands are:\n");

			/* display command list */
		    printline[0] = '\0';
		    for (i=0; i<NCMDS; i++) {
			sprintf(word,"%-16s",ftp_cmdlist[i]);	/* get word from list */
			strcat(printline,word);		/* add to line */
			if (i%5==4) {			/* display line */
			    printline[79] = '\0';
			    nprintf(SCREEN,"%s\n",printline);
			    printline[0] = '\0';
			}
		    }
		    if (i%5!=4) nprintf(SCREEN,"%s\n",printline);	/* last line */
		    return(TRUE);
		}

			/* help for specific commands */
		else {
		    while (getword(command,word)) {	/* loop for all args */
		        i = finduniq(word,ftp_cmdlist,NCMDS);   /* which command? */
			if (i==AMBIGUOUS)	/* non-unique command name */
			    sprintf(printline,"?Ambiguous help command %s",word);
			else if (i==NONE)	/* no such command */
			    sprintf(printline,"?Invalid help command %s",word);
			else			/* display help string */
		            sprintf(printline,"%s",helpstrings[i-1]);
			nprintf(SCREEN,"%s\n",printline);
		    }
		    return(TRUE);
		}
		break;
	case BANG:		/* shell escape */
		if (*(stpblk(command))) {	/* command specified */
		    system(command);	/* execute command */
		    return(TRUE);
		}
		dosescape();		/* subshell */
		return(TRUE);
	case BELL:
		if (getword(command,word)) {	/* scan arg */
		    lowercase(word);
		    if (!strcmp(word,"off")) bell = FALSE;
		    else if (!strcmp(word,"on")) bell = TRUE;
		    else bell = !bell;
		}
		else bell = !bell;
		if (bell) nprintf(SCREEN,"Bell mode on.\n");
		else nprintf(SCREEN,"Bell mode off.\n");
		return(TRUE);
	case BYE:
	case QUIT:
		if (connected) {
		    ftpdo("QUIT",ofilename);
		    connected = FALSE;
		}
		if (fromtty) n_cur(24,0);	/* go to bottom of screen */
		netshut();
		exit(0);
	case DEBUG:		/* turn on/off debugging, optional level */
		if (sscanf(command,"%d",&i)>0) debug = i;	/* level */
		else if (getword(command,word)) {	/* scan arg */
		    lowercase(word);
		    if (!strcmp(word,"off")) debug = FALSE;
		    else if (!strcmp(word,"on")) debug = TRUE;
		    else debug = !debug;
		}
		else debug = !debug;
		if (debug) {
		    nprintf(SCREEN,"Debugging on (debug=%d).\n",debug);
		}
		else nprintf(SCREEN,"Debugging off.\n");
		return(TRUE);
	case GLOB:		/* wildcard expansion */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) glob = FALSE;
		    else if (!strcmp(word,"on")) glob = TRUE;
		    else glob = !glob;
		}
		else glob = !glob;
		if (glob) nprintf(SCREEN,"Globbing on.\n");
		else nprintf(SCREEN,"Globbing off.\n");
		return(TRUE);
	case HASH:		/* hash mark printing */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) hash = FALSE;
		    else if (!strcmp(word,"on")) hash = TRUE;
		    else hash = !hash;
		}
		else hash = !hash;
		if (hash) nprintf(SCREEN,"Hash mark printing on (1024 bytes/hash mark).\n");
		else nprintf(SCREEN,"Hash printing off.\n");
		return(TRUE);
	case INTERACTIVE:	/* prompting on multiple transfers */
		prompt = TRUE;
		nprintf(SCREEN,"Interactive mode on.\n");
		return(TRUE);
	case LCD:		/* change local directory */
		if (command[1]==':') {		/* if disk specified */
#ifdef	__TURBOC__
		    setdisk(tolower(command[0]-'a'));
#else
#ifdef	_MSC_
		_dos_setdrive(tolower(command[0])-'a'+1,&i);
#else
		    chgdsk(tolower(command[0])-'a');
#endif
#endif
		    strcpy(command,&command[2]);
		}
		if (*(stpblk(command)) && chdir(command)) {	/* CD */
		    nprintf(SCREEN,"Unable to change directory\n");
		}
		getdir(0,line);		/* current directory */
		nprintf(SCREEN,"Local directory now %s\n",line);
		return(TRUE);
	case LLS:		/* local DIR */
		sprintf(line,"DIR %s",command);
		system(line);
		return(TRUE);
	case NONINTERACTIVE:	/* turn off interactive prompting */
		prompt = FALSE;
		nprintf(SCREEN,"Interactive mode off.\n");
		return(TRUE);
	case OPEN:		/* open connection to host */
		if (connected) {
		    nprintf(SCREEN,"Already connected.\n");
		    return(FALSE);
		}
		while (!(*(stpblk(command)))) {		/* no argument */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		getword(command,destname);		/* host name */
		mp = Sgethost(destname);		/* get host info */
		if (foundbreak) {			/* abort */
			foundbreak = FALSE;
			return(FALSE);
		}
		if (mp==NULL) {				/* try domain serving */
		    Sdomain(destname);
		    while (mp==NULL)
		      switch (checkevent()) {
		        case ABORT: return(FALSE);	/* abort */
			case DOMFAIL:
		    		printerr();
		    		nprintf(SCREEN,"Unknown host: %s\n",destname);
		    		return(FALSE);
			case DOMOK:
				mp = Slooknum(ftpnum);	/* get host info */
				break;
			default: break;
		      }
		}
		if (sscanf(command,"%d",&i)>0)    /* port number specified */
		    ftpnum = Snetopen(mp,i);
		else {
		    ftpnum = Snetopen(mp,HFTP);		/* default port */
		}
		if (foundbreak) {			/* abort */
			foundbreak = FALSE;
			return(FALSE);
		}
		if (ftpnum<0) {				/* error on open */
		    printerr();
		    nprintf(SCREEN,"Unable to connect to %s\n",destname);
		    return(FALSE);
		}
		ftpreplies(ftpnum,&i);		/* response from other end */
		if (foundbreak) {
			foundbreak = FALSE;
			return(FALSE);
		}

		nprintf(SCREEN,"[Connected to %s]\n",destname);

		connected = TRUE;
		if (autologin) {		/* execute login command */
		    strcpy(command,"user");
		    ftppi(command);
		}
		return(TRUE);
	case PROMPT:			/* interactive prompting */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) prompt = FALSE;
		    else if (!strcmp(word,"on")) prompt = TRUE;
		    else prompt = !prompt;
		}
		else prompt = !prompt;
		if (prompt) nprintf(SCREEN,"Interactive mode on.\n");
		else nprintf(SCREEN,"Interactive mode off.\n");
		return(TRUE);
	case SENDPORT:			/* send PORT commands for each transfer */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) sendport = FALSE;
		    else if (!strcmp(word,"on")) sendport = TRUE;
		    else sendport = !sendport;
		}
		else sendport = !sendport;
		if (sendport) nprintf(SCREEN,"Use of PORT cmds on.\n");
		else nprintf(SCREEN,"Use of PORT cmds off.\n");
		return(TRUE);
	case SLASHFLIP:			/* change \ to / */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) slashflip = FALSE;
		    else if (!strcmp(word,"on")) slashflip = TRUE;
		    else slashflip = !slashflip;
		}
		else slashflip = !slashflip;
		if (slashflip) nprintf(SCREEN,"Slash translation on.\n");
		else nprintf(SCREEN,"Slash translation off.\n");
		return(TRUE);
	case STATUS:		/* display status info */
		if (connected) {
		    nprintf(SCREEN,"Connected to %s\n",destname);
		}
		if (ftpfilemode==FASCII) nprintf(SCREEN,"Transfer mode is ascii.\n");
		else nprintf(SCREEN,"Transfer mode is binary.\n");
		if (bell) nprintf(SCREEN,"Bell on.\n"); else nprintf(SCREEN,"Bell off.\n");
		if (debug) {
		    sprintf(printline,"Debugging on. (Debug=%d)",debug);
		    nprintf(SCREEN,printline);
		}
		else nprintf(SCREEN,"Debugging off.\n");
		if (glob) nprintf(SCREEN,"Filename globbing on.\n"); else nprintf(SCREEN,"Filename globbing off.\n");
		if (hash) nprintf(SCREEN,"Hash-mark printing on.\n"); else nprintf(SCREEN,"Hash-mark printing off.\n");
		if (prompt) nprintf(SCREEN,"Interactive prompting on.\n"); else nprintf(SCREEN,"Interactive prompting off.\n");
		if (sendport) nprintf(SCREEN,"Sending of port commands on.\n"); else nprintf(SCREEN,"Sending of PORT cmds off.\n");
		if (slashflip) nprintf(SCREEN,"Flipping \\ to / on.\n"); else nprintf(SCREEN,"Flipping \\ to / off.\n");
		if (verbose) nprintf(SCREEN,"Verbose mode on.\n"); else nprintf(SCREEN,"Verbose mode off.\n");
		if (connected) {		/* send STAT command */
		    nprintf(SCREEN,"\nRemote status:\n");
		    ftpdo("STAT",ofilename);
		}
		return(TRUE);
	case VERBOSE:		/* display informative messages */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off\n")) verbose = FALSE;
		    else if (!strcmp(word,"on\n")) verbose = TRUE;
		    else verbose = !verbose;
		}
		else verbose = !verbose;
		if (verbose) nprintf(SCREEN,"Verbose mode on.\n");
		else nprintf(SCREEN,"Verbose mode off.\n");
		return(TRUE);
	default:		/* The other commands valid only if connected */
		if (!connected) {
		    nprintf(SCREEN,"Not connected.\n");
		    return(FALSE);
		}
		switch (cmdno) {
	    case ASCII:			/* transfer mode */
		ftpdo("TYPE A",ofilename);
		return(TRUE);
	    case BGET:			/* get file in binary mode */
		i = ftpfilemode;	/* save current mode */
		if (i==FASCII) ftpdo("TYPE I",ofilename);
		while (!(*(stpblk(command)))) {
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"RETR %s",command);
		ftpdo(line,ofilename);		/* get file */
		if (i==FASCII) ftpdo("TYPE A",ofilename);	/* restore mode */
		return(TRUE);
	    case BINARY:		/* binary mode */
		ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case BPUT:			/* put file in binary mode */
		i = ftpfilemode;
		if (i==FASCII) ftpdo("TYPE I",ofilename);
		while (!(*(stpblk(command)))) {		/* if no arg */
		    putstring("File: ");	/* get from user */
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"STOR %s",command);
		ftpdo(line,ofilename);
		if (i==FASCII) ftpdo("TYPE A",ofilename);
		return(TRUE);
	    case CD:		/* change remote directory */
		while (!(*(stpblk(command)))) {		/* if no arg, get from user */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		getword(command,word);
		if (!strcmp(word,"..")) {	/* special case */
		    i = ftpdo("CDUP",ofilename);
		    if (i!=ERROR) return(TRUE);		/* if CDUP understood */
		    nprintf(SCREEN,"Trying again...");
		    i = ftpdo("XCUP",ofilename);	/* try alternative */
		    if (i!=ERROR) return(TRUE);
		    nprintf(SCREEN,"Trying again...");		/* else try usual CD */
		}
		sprintf(line,"CWD %s",word);		/* try CWD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"XCWD %s",word);		/* try XCWD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case CLOSE:				/* drop connection */
		ftpdo("QUIT",ofilename);
		connected = FALSE;
		return(TRUE);
	    case DEL:
	    case RM:
		getword(command,word);
		while (!word[0]) {	/* get arg from user */
		    putstring("File: ");
		    if (ftpgets(word,100,1)==ABORT) return(FALSE);	/* abort */
		}
		if (prompt) {		/* check interactively */
		    sprintf(printline,"Delete %s? ",word);
		    putstring(printline);
		    ftpgets(answer,20,1);
		    if (tolower(*(stpblk(answer)))!='y') return(TRUE);
		}
		sprintf(line,"DELE %s",word);
		ftpdo(line,ofilename);
		return(TRUE);
	    case DIR:		/* get list of remote files */
		i = ftpfilemode;	/* save mode */
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		if (getword(command,word)) {	/* do DIR */
		    sprintf(line,"LIST %s",word);
		    ftpdo(line,ofilename);
		}
		else ftpdo("LIST",ofilename);
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case GET:
	    case RECV:		/* get remote file */
		while (!(*(stpblk(command)))) {		/* if no arg */
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		sprintf(line,"RETR %s",command);
		ftpdo(line,ofilename);
		return(TRUE);
	    case LS:		/* get remote file list - short */
		i = ftpfilemode;
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		if (getword(command,word)) {
		    sprintf(line,"NLST %s",word);
		    ftpdo(line,ofilename);
		}
		else ftpdo("NLST",ofilename);
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MDELETE:
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Files: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* wildcard expansion */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);	/* put exapnsion in captlist */
			capture = FALSE;
		    }
		    else strcpy(captlist,word);	/* captlist has name(s) now */
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mdelete %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"DELE %s",word);	/* delete */
		        ftpdo(line,ofilename);
		    }
		}
		return(TRUE);
	    case MDIR:		/* remote multiple DIR */
		i = ftpfilemode;	/* save mode */
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directories: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* expand wildcards */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mdir %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"LIST %s",word);	/* DIR */
		        ftpdo(line,ofilename);
		    }
		}
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MGET:		/* get multiple files */
		getword(command,line);
		while (!line[0]) {	/* no arg */
		    putstring("Files: ");
		    if (ftpgets(line,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(line,word)) {	/* for each arg */
		    if (glob) {		/* expand wildcards */
		        sprintf(command,"NLST %s",word);
			capture = TRUE;
		        ftpdo(command,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mget %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(command,"RETR \"%s\"",word);
		        ftpdo(command,ofilename);
		    }
		}
		return(TRUE);
	    case MKDIR:		/* create directory */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directory: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		sprintf(line,"XMKD %s",command);	/* try XMKD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"MKD %s",command);		/* else try MKD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case MLS:
		i = ftpfilemode;
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directories: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* exapnd wildcards */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {		/* check */
			    sprintf(printline,"mls %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {  /* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"NLST %s",word);	/* DIR */
		        ftpdo(line,ofilename);
		    }
		}
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MODE:		/* set stream mode */
		getword(command,word);
		lowercase(word);
		if (strncmp(word,"stream",strlen(word)))
		    nprintf(SCREEN,"We only support stream mode, sorry.\n");
		else nprintf(SCREEN,"Mode is stream.\n");
		return(TRUE);
	    case MPUT:		/* put multiple files */
		getword(command,line);
		while (!line[0]) {	/* no arg */
		    putstring("Files: ");
		    if (ftpgets(line,100,1)==ABORT) return(FALSE);	/* abort */
		}
		p = NULL;	/* no names expanded yet */
		while (getword(line,word)) {	/* for each arg */
		  do {		/* for each name */
		    if (glob) {		/* local wildcard expansion */
			if (p==NULL) {	/* if no expansions yet */
			    p = firstname(word,1);	/* get first name */
			    if (p==NULL) {	/* if no expansions */
				nprintf(SCREEN,"No match for %s\n",word);
				continue;
			    }
                            else {
                                char *c;
                                c = strchr(p,' ');
                                if(c)
                                        *c = 0;
                            }
			}
			else {		/* not first name */
			    p = nextname(word,1);		/* get next name */
			    if (p==NULL) continue;	/* if no names, next arg */
                            { char *c;
                                c = strchr(p, ' ');
                                if(c)
                                        *c = 0;
                            }
			}
		    }
		    else p = word;		/* no expansion */
		    if (prompt) {	/* check */
			sprintf(printline,"mput %s? ",p);
			putstring(printline);
			if (ftpgets(answer,20,1)==ABORT) {	/* abort */
			    command[0] = '\0';	/* no more processing */
			    break;			/* quit immediately */
			}
			if (tolower(*(stpblk(answer)))!='y') continue;
		    }
		    sprintf(command,"STOR \"%s\"",p);	/* name may have spl chars */
		    ftpdo(command,ofilename);
		  } while (glob && p!=NULL);		/* Not last expansion */
		}
		return(TRUE);
	    case PUT:			
	    case SEND:		/* put file */
		while (!(*(stpblk(command)))) {		/* no args */
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"STOR %s",command);	/* put file */
		ftpdo(line,ofilename);
		return(TRUE);
	    case PWD:
		i = ftpdo("XPWD",ofilename);		/* try XPWD */
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		ftpdo("PWD",ofilename);			/* else try PWD */
		return(TRUE);
	    case QUOTE:
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Command: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		ftpdo(command,ofilename);		/* send command */
		return(TRUE);
	    case REMOTEHELP:				/* get help */
		if (*(stpblk(command))) {		/* for specific command */
		    sprintf(line,"HELP %s",command);
		    ftpdo(line,ofilename);
		}
		else ftpdo("HELP",ofilename);		/* generic help */
		return(TRUE);
	    case RENAME:		/* rename remote file */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("From: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		getword(command,word);
		sprintf(line,"RNFR %s",word);
		ftpdo(line,ofilename);		/* send rename from name */
		while (!(*(stpblk(command)))) {		/* no second arg */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) {
			ftpdo("ABOR",ofilename);
			return(FALSE);
		    }
		}
		sprintf(line,"RNTO %s",command); /* send rename to name */
		ftpdo(line,ofilename);
		return(TRUE);
	    case RMDIR:			/* remove remote dir */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directory: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"XRMD %s",command);	/* try XRMD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"RMD %s",command);		/* try RMD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case STRUCT:		/* set structure type - only file */
		getword(command,word);
		lowercase(word);
		if (strncmp(word,"file",strlen(word)))
		    nprintf(SCREEN,"We only support file structure, sorry.\n");
		else nprintf(SCREEN,"Structure is file.\n");
		return(TRUE);
	    case TYPE:		/* set transfer type */
		if (!getword(command,word)) {	/* no arg, just show */
		   if (ftpfilemode==FASCII) nprintf(SCREEN,"Transfer type is ascii.\n");
		   else nprintf(SCREEN,"Transfer type is binary.\n");
		}
		lowercase(word);
		if (!strncmp(word,"ascii",strlen(word)))
		    ftpdo("TYPE A",ofilename);
		else if (!strncmp(word,"binary",strlen(word)) ||
			!strncmp(word,"image",strlen(word)))
		    ftpdo("TYPE I",ofilename);
		else {
		    nprintf(SCREEN,"Unrecognized type: %s\n",word);
		}
		return(TRUE);
	    case USER:			/* login to remote machine */
		if (!(*(stpblk(command)))) {	/* null response to prompt ok */
		    putstring("Username: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"USER %s",command);	/* username */
		if (ftpdo(line,ofilename)==TRUE) return(TRUE);
		putstring("Password: ");
		if (ftpgets(word,50,0)==ABORT) return(FALSE);		/* no echoing */
		sprintf(line,"PASS %s",word);		/* password */
		if (ftpdo(line,ofilename)==INCOMPLETE) {	/* if account needed */
		    do {
		        putstring("Account: ");
		        if (ftpgets(command,100,1)==ABORT) return(FALSE);
		    } while (!(*(stpblk(command))));
		    sprintf(line,"ACCT %s",command);
		    ftpdo(line,ofilename);
		}
		return(TRUE);		
	default:	/* unknown command */
		nprintf(SCREEN,"***Program error: Unknown command no: %d\n",cmdno);
		break;
	}
	}
}


/************************************************************************/
/* ftpdo
*  Do whatever command is sent from the user interface using
*  userftpd, the background file handler
*  Returns code from ftpreplies
/************************************************************************/

ftpdo(s,ofile)
	char *s,*ofile;
	{
	int i,rcode;
	char name[50],name2[50];

	for (i=0; i<4; i++) {
		s[i] = toupper(s[i]);	/* command to upper case */
	}

	if (!strncmp(s,"STOR",4)) {	/* put file */
		getword(&s[5],name);	/* first arg - local file */
		if (!s[5]) strcpy(&s[5],name);		/* if only one argument */
	        else {
		    getword(&s[5],name2);	/* second arg - removes quotes etc. */
		    strcpy(&s[5],name2);	/* copy back into command */
		}
#if  defined(__TURBOC__)||defined(_MSC_)
		if (0 > (ftpfh = open(name,O_BINARY|O_RDONLY))) {	/* open local file */
#else
		if (0 > (ftpfh = open(name,O_RAW))) {	/* open local file */
#endif
			nprintf(SCREEN," Cannot open file to transfer.\n");
			return(-1);
		}
		ftpdata = netlisten(ftpport());		/* open data connection */
		ftpstate = 20;
	}
	else if (!strncmp(s,"RETR",4)) {	/* get file */
		getword(&s[5],name);			/* remote file */
		if (s[5]) {		/* two args present */
		    getword(&s[5],name2);	/* local file */
#if  defined(__TURBOC__)||defined(_MSC_)
		    ftpfh  = open(name2, O_BINARY|O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
#else
		    ftpfh = creat(name2,O_RAW);		/* open local file */
#endif
		}
#if  defined(__TURBOC__)||defined(_MSC_)
		else ftpfh  = open(name, O_BINARY|O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
#else
		else ftpfh = creat(name,O_RAW);	/* local name same as remote */
#endif
		if (ftpfh<0) {
			nprintf(SCREEN,"Cannot open file to receive: %s\n",name);
			return(-1);
		}
		strcpy(&s[5],name);	/* put remote name back into command */
		ftpdata = netlisten(ftpport());		/* open data connection */
		ftpstate = 30;
	}
	else if (!strncmp(s,"LIST",4) || !strncmp(s,"NLST",4)) {
		if (capture) captlist[0] = '\0';	/* where to put incoming data */
		ftpdata = netlisten(ftpport());		/* data connection */
		ftpstate = 40;
	}
	else if (!strncmp(s,"TYPE",4)) {
		if (toupper(s[5]) == 'I')
			ftpfilemode = FIMAGE;	/* remember mode */
		else if (toupper(s[5]) == 'A')
			ftpfilemode = FASCII;
	}

	dumpcon(ftpnum);			/* clear command connection */
	netpush(ftpnum);
	netwrite(ftpnum,s,strlen(s));		/* send command */
	netwrite(ftpnum,"\r\n",2);		/* <CRLF> terminates command */
	if (!capture && ofile[0]) {		/* command redirected */
		if ((ftpstate!=20) && (ftpstate!=30)) {	/* not get or put */
		     if (0 > (ftpfh = open(ofile,O_CREAT|O_APPEND|O_WRONLY,S_IWRITE)))
			nprintf(SCREEN," Cannot open output file.\n");
		     else
		        if (ftpdata > -1) {
			    ftpstate = 30;	/* act as get, since data goes into file */
			}
			else {
			    close(ftpfh);
			    ftpfh = 0;
			}
		}
	}
	
	if (debug) {
	    nprintf(SCREEN,"---> %s\n",s);	/* show command sent */
		if (debug>=7) {
		    for (i=0; i<strlen(s); i++) {
			sprintf(&printline[4*i],"%3X ",s[i]);
		    }
		    nprintf(SCREEN,"%s\n",printline);
		}
	}

	i = ftpreplies(ftpnum,&rcode);		/* get remote response */
	if ((i==NONE) && strncmp(s,"QUIT",4)) {	/* unexpected connection drop */
	    nprintf(SCREEN,"lost connection\n");
	    connected = FALSE;
	}
	if (i==ABORT || i==NONE || i==ERROR)  {
	    ftpstate = 0;		/* if error, no transfer */
	    if (ftpdata>-1) netclose(ftpdata);
	    if (ftpfh!=0) close(ftpfh);
	    ftpdata = -1;
	    ftpfh = 0;
	}
	return(i);
}

/************************************************************************/
/*   ftpport
*   return a new port number so that we don't try to re-use ports
*   before the mandatory TCP timeout period.  (lifetime of a packet)
*   use a time-based initial port selection scheme.
/************************************************************************/

long int time();			/* global */

unsigned int ftpport()
	{
	unsigned int i,rcode;
	unsigned char hostnum[5];
	char sendline[60];		/* for port command */

	if (!sendport) {		/* default port */
	    return(HFTP-1);
	}
	if (curftpprt < 40000) {	/* restart cycle */
		i = (unsigned int)time(NULL);
		curftpprt = 40000 + (i & 0x3fff);
	}

	i = curftpprt--;	/* get port, update for next time */

	netgetip(hostnum);	/* get my ip number */
	sprintf(sendline,"PORT %d,%d,%d,%d,%d,%d\r\n",hostnum[0],hostnum[1],hostnum[2],
		hostnum[3],i/256,i&255);	/* full port number */
	if (debug>1) nprintf(SCREEN,sendline);

	netpush(ftpnum);	/* empty command connection */
	netwrite(ftpnum,sendline,strlen(sendline));	/* send PORT command */
	/* check result of command, make sure port was okay */
	/* return 0 on error */		/* ????? */
	dumpcon(ftpnum);
	ftpreplies(ftpnum,&rcode);	/* get response */
	return(i);		/* port number */

}


/************************************************************************/
/* ftpreplies
* get responses to commands to server
* return TRUE on successful completion, FALSE on transient negative
* completion, INCOMPLETE if more commands needed for operation,
* NONE on lost connection, ABORT on user abort and ERROR on failure
*
/************************************************************************/

ftpreplies(cnum,rcode)
int cnum,*rcode;
{
int cnt,ev,j=0;
	int myrc;
	int contin=0;

while (1) {
    cnt = rgetline(cnum);			/* get line form remote host */
    if (cnt==NONE) return(NONE);		/* lost connection */
    if (cnt==ABORT) {				/* user abort */
	netpush(cnum);
	netwrite(cnum,"ABOR\r\n",6);		/* send abort */
	return(ABORT);
    }
    sscanf(s,"%d",(int *) &myrc);

    if ( (!contin) && (s[3]=='-') ){
	contin=1;
	j=myrc;
    }

    if ( (contin) && (s[3]==' ') && (myrc==j) ){
	contin=0;
	myrc=j;
    }
    *rcode = myrc;

    if (((myrc/100)==2) && (! contin)) {	/* positive completion */
        dumpcon(ftpnum);			/* clear command connection */
	while (ftpdata>=0) {			/* wait till transfers complete */
	    ev = checkevent();
	    if (ev==NONE) return(NONE);	/* lost connection */
	    if (ev==ABORT) break;		/* user abort */
	    if (ev==HAVEDATA) dumpcon(ftpnum);	/* msg on command connection */
	}
    }
    if (verbose || (contin) || (myrc>500) || (cnt > 0)) telnet(cnt);	/* informative/error msg or display on */

    if (contin) {
    	continue;			/* end of continuation */
    }

    switch(myrc/100) {			/* first digit */
	case 1:					/* preliminary */
	    continue;
	case 2:					/* positive completion */
	    return(TRUE);
	    break;
	case 3:					/* intermediate */
	    return(INCOMPLETE);
	    break;
	case 4:					/* transient negative completion */
	    return(FALSE);
	    break;
	case 5:					/* Permanent negative completion */
	    return(ERROR);
	    break;
	default:
	       {
	       	    char buff[256];
		    nprintf(SCREEN,"Server response not understood. Terminating command (rcode %d)\n'%s'\n",myrc,s);
		}
	    return(ERROR);
    }
}
}


/************************************************************************/
/* rgetline - get a line from remote server
* return ABORT on user ABORT, NONE on lost connection,
* length of received line on success
*
/************************************************************************/

rgetline(cnum)
int cnum;
{
int cnt,i=0,ev;
while (1) {
	ev = checkevent();
	switch (ev) {
	    case ABORT:				/* user abort */
	    case NONE:				/* lost connection */
		return(ev);
	    case HAVEDATA:
		if (fromtty && n_scrlck()) cnt = 0;		/* if paused, nothing to do */
		else while (1) {
		    cnt = netread(cnum,&s[i],1);	/* get some from queue */
		    if (!cnt) {
                        break;		/* nothing available */
		    }
	            if ((s[i++]=='\n')) {		/* end of line */
	                s[i] = '\0';
	            	return(i);		/* return line length */
	            }
		}
		break;
	    default:		/* ignore other events */
		break;
	}
}
return(0);
}


/************************************************************************/
/* breakstop
* handle cntrl-break
/************************************************************************/

int
breakstop()
	{
	foundbreak = 1;
#ifdef	__TURBOC__
	return(1);
#else
	return(0);
#endif
}


/************************************************************************/
/* userftpd
*  FTP receive and send file functions
/************************************************************************/

userftpd()	{
	int i,r1,r2;
	double rate;
	static int stopcapture=FALSE;	/* bytes xferred % 1024 */
	static long tbytes;

	switch (ftpstate) {
		default:	/* unknown */
			break;
		case 40:		/* start LIST */
			if (!netest(ftpdata)) {
				start = time(NULL);	/* current time */
				tbytes = 0;		/* received so far */
				ftpstate = 41;
			}
			break;
		case 41:		/* get started */
			do {
                                int     cnt = strlen(captlist);

			        if (capture && !stopcapture) {	/* into captlist */
			            fcnt = netread(ftpdata,xs,READSIZE);
				    if (cnt+fcnt>=1999) { /* full */
				        if (!fromtty || !n_scrlck())
					    nprintf(SCREEN,&xs[2000-cnt]);	/* display excess chars */
					strncat(captlist,xs,1999-cnt);
                                        captlist[1999] = 0;     /* make sure its terminated */
					nprintf(SCREEN,"Error: capture list too long\n");
					stopcapture = TRUE;
				    }
				    else {
                                        strncat(captlist,xs,fcnt); /* append */
                                        captlist[cnt+fcnt] = 0; /* make sure buffer is terminated */
                                    }
				}
				else {
				    if (fromtty && n_scrlck()) break;	/* paused */
				    fcnt = netread(ftpdata,xs,READSIZE);
				    for (i=0; i < fcnt; i++) 
				       nprintf(SCREEN,"%c",xs[i]);	/* display */
				}
				if (fcnt>0) tbytes += fcnt;	/* how much */
			} while (fcnt>0);	/* till no more input */
			break;
		case 30:		/* receive */
			if (!netest(ftpdata)) {		/* connection made */
				start = time(NULL);
				ftpstate = 31;
				len = xp = 0;
				tbytes = 0;
			}
			break;
		case 31:
/*
* file has already been opened, take everything from the connection
* and place into the open file: ftpfh
*/
			do {
			/* wait until xs is full before writing to disk */
				if (len <= 0) {
					if (xp) {
						write(ftpfh,xs,xp);
						xp = 0;
					}
					len = BUFFERS;		/* expected or desired len to go */
				}
					/* how much to read */
				if (len < BUFFERS)	/* ### was READSIZE */
					i = len;
				else
					i = BUFFERS;

				fcnt = netread(ftpdata,&xs[xp],i);

				if (fcnt>0) {	/* adjust counts */
				    len -= fcnt;
				    xp += fcnt;
				    tbytes += fcnt;
				}

				if (debug>1) {
				    nprintf(SCREEN,"len %d xp %d fcnt %d\n",len,xp,fcnt);
				}

				if (fcnt < 0) {		/* connection closed */
					write(ftpfh,xs,xp);		/* write last block */
#ifdef	STUPID
					if (ftpfilemode == FASCII) {
						write(ftpfh,"\032",1);	/* EOF char */
					}
#endif
					close(ftpfh);
					ftpfh = 0;
				}

				if (hash) {	/* hash mark printing */
				    for (i=((tbytes-fcnt)%1024+fcnt)/1024; i; i--)
					nprintf(SCREEN,"#");
				}

			} while (fcnt > 0);
			break;

		case 20:	/* send */
			if (!netest(ftpdata)) {		/* connection made */
				start = time(NULL);
				ftpstate = 21;
#ifdef  __TURBOC__
                                filesiz = filelength(ftpfh);
#else
				filesiz = lseek(ftpfh,0L,2);	/* how long is file? */
				lseek(ftpfh,0L,0);				/* back to beginning */
#endif
				if (ftpfilemode == FASCII) {
					filesiz--;			/* leave off ctrl-Z */
				}
				towrite = 0;
				xp = 0;
				tbytes = 0;
			}
			break;

		case 21:
/*
*  transfer file(s) to the other host via ftp request
*  file is already open = ftpfh
*/
			if (towrite <= xp) {	/* need to read again */
/*				if (filesiz < (long)BUFFERS)
					i = (int)filesiz;
				else */
					i = BUFFERS;
				towrite = read(ftpfh,xs,i);
				if(towrite == -1) {
					perror("read in send mode 21:");
					towrite = 0;
				}
				if(towrite > BUFFERS) {

					nprintf(SCREEN,"Fatal, read %d bytes, only wanted %d\n",towrite, i);
				}
				xp = 0;
			}

                        if(towrite > 0 && !netest(ftpdata))
        			i = netwrite(ftpdata,&xs[xp],towrite-xp);
			netpush(ftpdata); 

			if (i > 0) {	/* send successful, adjust counts */
				xp += i;
				filesiz -= i;
                                if(filesiz < 0L)
                                        filesiz = 0;
				tbytes += i;
			}

			if (debug>1) {
			    nprintf(SCREEN,"i %d xp %d towrite %d filesiz %ld tbytes %ld  fcnt %d\n",i,xp,towrite, filesiz, tbytes,fcnt);
			}
			if (hash) {	/* hash printing */
			    for (r1=((tbytes-i)%1024+i)/1024; r1; r1--)
			        nprintf(SCREEN,"#");
			}

/*
*  done if:  the file is all read from disk and all sent
*  or other side has ruined connection
*/
			if ((filesiz <= 0L && xp >= towrite) || (i=netest(ftpdata))) {
				ftpstate = 22;
                                if(debug>1)
                                        nprintf(SCREEN,"File Ended, xp %d towrite %d netest %d filelen %ld\n",xp,towrite,filesiz, i);
			}
			break;

		case 22:	/* send done */
		/* wait for other side to accept everything and then close */
			if ( 0 >= (r1=netpush(ftpdata)))
				fcnt = -1;
			if (debug>1) {
			    nprintf(SCREEN,"fcnt %d r1 %d\n",fcnt,r1);
			}
			break;

	}  /* end of switch */

/*
*  after reading from connection, if the connection is closed,
*  reset up shop.
*/
	if (fcnt < 0) {		/* connection lost */
		if (ftpfh > 0) {	/* close file */
			close(ftpfh);
			ftpfh = 0;
		}
		ftpstate = 0;	/* done */
		fcnt = 0;
		i = (int) (time(NULL)-start);	/* how long to transfer */
		if (!i) rate = ((double) tbytes) / 1024.0;
		else rate = ((double) tbytes) / (i * 1024.0);
		r1 = (int) rate;	/* integer part of rate */
		r2 = (int) ((rate - (double) r1) * 1000);
	 	if(hash || verbose)
			nprintf(SCREEN,"Transferred %ld bytes in %d seconds (%d.%03d Kbytes/sec)\n",tbytes,i,r1,r2);
		netclose(ftpdata);	/* close connection */
		ftpdata = -1;
		if (bell) n_sound(1200,24);
	}
	return(TRUE);
}


/************************************************************************/
/* getword: remove a word from a string.  Things within quotes are
* assumed to be one word.
* return TRUE on success, FALSE on end of string
/************************************************************************/

char
*stpblk(s)
	char *s;
{
	while(*s == ' ')
		s++;
	return(s);
}

getword(string,word)
char *string,*word;
{
char *p,*q;
int i=0;

if (debug>4) {
	nprintf(SCREEN,"getword: string is %s\n",string);
}
p = stpblk(string);			/* skip leading blanks */
if (!(*p)) {				/* no words in string */
	word[0] = '\0';
	return(FALSE);
}
if (*p=='!') {				/* ! is a word */
	word[0] = *p;
	word[1] = '\0';
	strcpy(string,++p);
	return(TRUE);
}
if (*p=='\"') {				/* word delimited by quotes */
    while (p[++i] && p[i]!='\"') word[i-1] = p[i];
    word[i-1] = '\0';
    if (!p[i]) nprintf(SCREEN,"Missing \". Assumed at end of string.\n");
    else i++;
    q = p+i;
}
#if	defined(__TURBOC__)||defined(_MSC_)
else   {
	q = strpbrk(p, " \t\r\n");
	if(!q) {
		strcpy(word,p);
		*(string) = 0;
	}
	else {
		*q = 0;
		strcpy(word,p);
		string[0] = 0;
		q = stpblk(q+1);
		if(*q)
			strcpy(string,q);
	}
	return(TRUE);
}
q = stpblk(q);
if(q)
	strcpy(string,q);
#else
else q = stptok(p, word, 50, " \t\r\n"); /* get word, max len 50 */
p = stpblk(q);				/* remove trailing blanks */
strcpy(string,p);			/* remove extracted stuff */
#endif
return(TRUE);
}


/************************************************************************/
/* lowercase: convert a string to lowercase
*
/************************************************************************/

lowercase(word)
char *word;
{
int i;

for (i=0; word[i]=tolower(word[i]); i++);
return(TRUE);
}


/************************************************************************/
/* checkoredir: check for output redirection.  If the command contains a
* >, assume a filename follows and extract it.  Remove the redirection
* from the original command.
* Also change \ to /
* return TRUE if redirection specified, FALSE otherwise 
/************************************************************************/

checkoredir(command,filename,slashflip)
char *command,*filename;
int slashflip;
{
int i;

filename[0] = '\0';
#ifdef	JUNK
/* 7/20/90 disable command line redirection */

for (i=0; (command[i]!='>'); i++) {	/* process command part */
#else
for (i=0; 1 ; i++) {	/* process command part */
#endif
	if (slashflip && command[i] == '\\') command[i] = '/';
        if (!command[i]) return(FALSE);	/* no redirection */
}
getword(&command[i+1],filename);	/* get redirected filename */
command[i] = '\0';
return(TRUE);
}


/************************************************************************/
/* getdir: get current directory.  Finds current drive and current path
* on drive, returns a string.
*
/************************************************************************/

getdir(drive,path)
int drive;
char *path;
{
char partpath[64];
#ifdef	__TURBOC__
	if(!drive)
		drive = getdisk();
#else
#ifdef	_MSC_
	if(!drive) {
	   	_dos_getdrive(&drive);
		drive--;
	}
#else
if (!drive) drive = getdsk();	/* current disk */
#endif
#endif

#ifdef	__TURBOC__
	getcurdir(drive+1, partpath);
#else
#ifdef	_MSC_
	getcwd(partpath,63);
#else
getcd(drive+1,partpath);	/* current dir */
#endif
#endif
sprintf(path,"%c:\\%s",'A'+drive,partpath);
return(TRUE);
}


/************************************************************************/
/* finduniq: find name that is a unique prefix of one of the entries in
* a list.  Return position of the entry, NONE if none, AMBIGUOUS if more
* than one.
*
/************************************************************************/

finduniq(name,list,listsize)
char *name, *list[];
int listsize;
{
int i,j=NONE,len;

len = strlen(name);
for (i=0; i<listsize; i++) {
    if (!strncmp(name,list[i],len)) {		/* prefix */
	if (len==strlen(list[i])) return(i+1);	/* exact match */
	if (j!=NONE) j = AMBIGUOUS;	/* more than one match */
	else j = i+1;			/* note prefix found */
    }
}
return(j);			/* prefix */
}


/************************************************************************/
/* checkevent
* get and process network events
* returns ABORT on user abort, HAVEDATA if data available on command
* connection, NONE if connection lost, DOMOK if domain search succeeds,
* DOMFAIL if domain search fails, TRUE if no relevant event.
/************************************************************************/

checkevent()
{
int ev,class=0,data;

kbhit();			/* check for cntrl-break */
if (foundbreak) {
	foundbreak = FALSE;
	return(ABORT);
}
userftpd();			/* do ftp stuff */
Stask();			/* keep connections alive */
ev = Sgetevent(CONCLASS|ERRCLASS|USERCLASS, &class,&data);
if (class==CONCLASS) {
    if (data==ftpnum) {		/* command connection */
	if (ev==CONCLOSE) {	/* connection lost */
	    netclose(ftpnum);
	    if (!netest(ftpdata)) netclose(ftpdata);	/* close data connection */
	    connected = FALSE;
	    return(NONE);
	}
	if (ev==CONDATA) return(HAVEDATA);	/* data received */
    }
}
else if (class==USERCLASS) {		
    if (ev==DOMOK) {		/* domain search succeeded */
	ftpnum = data;
	return(DOMOK);
    }
    else if (ev==DOMFAIL) return(DOMFAIL);	/* domain search failed */
}
/* else if (class==ERRCLASS && ev==ERR1) nprintf(SCREEN,neterrstring(data)); */
return(TRUE);
}


/************************************************************************/
/* putstring: display string using vt100 emulation routines
/************************************************************************/

putstring(string)
char *string;
{

for (; *string; string++) nputchar(*string);
return(TRUE);
}


/************************************************************************/
/* printerr: display TCP error messages - disabled
/************************************************************************/

printerr()
{

int data,class;

while (ERR1==Sgetevent(ERRCLASS,&class,&data)) {
    if(debug > 2) {
	    nprintf(SCREEN,"%s\n",neterrstring(data));
    }
}
return(TRUE);
}


/************************************************************************/
/* getnname: get next name from captured list
* names delimited by newlines - <CR> or <LF>
/************************************************************************/

getnname(string,word)
char *string,*word;
{
char *s;

s = string;
while ((*string=='\n') || (*string=='\r')) string++;	/* skip initial newlines */
if (!(*string)) return(FALSE);		/* end of captlist */
while ((*string!='\n') && (*string!='\r') && (*string)) *(word++) = *(string++);
while ((*string=='\n') || (*string=='\r')) string++;	/* skip trailing newline */
*word = '\0';
strcpy(s,string);
return(TRUE);
}



/***************************************************************************/
/*  dosescape
*  escape to dos for processing
*  put the connections to automated sleep while in DOS
/************************************************************************/

dosescape()
{
	int i;
	char	*com;

	nprintf(SCREEN,"Warning, some programs will interfere with network communication and can\n");
	nprintf(SCREEN,"cause lost connections.  Do not run any network programs from this DOS shell.\n");
	nprintf(SCREEN,"Type 'EXIT' to return to FTP\n");
/*
*  invoke a put-to-sleep routine which calls netsleep every 8/18ths of a sec
*/
#ifdef	BADWAY

	i = system("command");		/* call DOS */
#else
	com = getenv("COMSPEC");
     	if(!com) {
	   	nprintf(SCREEN,"COMSPEC variable not found, can not escape to DOS\n");
		i = -1;
	}
     	else 
	   	i = spawnl(P_WAIT,com,com,NULL);
#endif


	if (i < 0) {
		nprintf(SCREEN,"\n\nError loading Shell\n");
		nprintf(SCREEN,"Make sure COMMAND.COM is specified under COMSPEC.\n");
		nprintf(SCREEN,"It must also be in a directory which is in your PATH statement.\n");
	}

	if (fromtty) n_row();
	return(0);
}

static int scrsetup;

nputs(line)
char *line;
{
if (!scrsetup) {
    scrsetup = 1;
	if (fromtty) {
	    n_clear();			/* clear screen */
	    n_wrap(1);			/* cursor positioning */
	    n_cur(0,0);
	    n_color(7);			/* set color to white */
	}

	nprintf(SCREEN,"             National Center for Supercomputing Applications\n");
       nprintf(SCREEN,"             Modified by the Educational Resources Center of Clarkson University\n");
	nprintf(SCREEN,"                      FTP version " FTPVERSION "\n");
}
	nprintf(SCREEN,"%s\n",line);
	return(TRUE);
}

nputchar(ch)
char ch;
{
	nprintf(SCREEN,"%c",ch);
	return(TRUE);
}
