/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/look.c_v   1.0   15 Jan 1990 19:26:14   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/look.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:14   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   look.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/
/* #define	DEBUGMEM	1 */

/*
*    LOOK.C
*    User interface code for NCSA Telnet
****************************************************************************
*                                                                          *
*      NCSA Telnet for the PC                                              *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      Packet Driver, Domain Search list by Brad Clements, Clarkson        *
*               University.                                                *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*      This program is in the public domain.                               *
*                                                                          *
****************************************************************************
*   Revisions:
*   10/1/87  Initial source release, Tim Krauskopf
*   7/5/88   Version 2.2 Tim Krauskopf
*   10/25/88 Version 2.3 Brad Clements (packet, turbo C, domainlist, CMU compat
*/

#define WINMASTER
#define USETEK
/* #define USERAS */
#define HTELNET 23

#ifndef USETEK
#define leavetek() 0
#endif

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include "signal.h"
#include "fcntl.h"
#include "nkeys.h"
#include <process.h>
#ifdef	_MSC_
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <dos.h>

#define TELCMDS 1
#define TELOPTS 1
#ifdef  FTPPW
#include        <stdlib.h>
#else
extern unsigned char 		*getenv();
#endif

#include "arpa/telnet.h"
#include "protocol.h"
#include "data.h"
#include "windat.h"
#include "hostform.h"
#include "newwin.h"
#ifdef	AUTOVID
#ifdef	__TURBOC__
#include <graphics.h>
#endif
#ifdef	_MSC_
#include <graph.h>
#endif
#endif
#include "vsdata.h"
extern struct config Scon;
#include "mem.h"

#ifdef	NEWKEY
#include "newkeys.h"
extern int kbcodes;
extern unsigned n_chkchar();
unsigned int newkey();
#endif
extern	char	dotop;			/* true if topview detected */
extern int slip_mode;
struct twin *creatwindow(),*newin;

FILE *tekfp;

extern struct	twin	*addsess();
int     numberoflines=DEFAULTLINES;             /* the default number of lines */
extern	char	*env_config;
unsigned char	start_color;
int stand=0,
	basetype = VTTYPE,
	ftpact=0,					/* ftp transfer is active */
	rcpact=0,					/* rcp transfer is active */
	viewmode=0,					/* What are we looking at? */
	transok=1,					/* is file transfer enabled? */
	temptek,					/* where drawings go by default */
	indev,outdev,				/* for copying tek images */
	rgdevice=0,					/* tektronix device to draw on */
	vton=1,
	capon=0,					/* overall capture on or not */
	foundbreak=0,				/* trap Ctrl-C */
	machparm=0;
#define SSIZE   64
extern	unsigned int	rawbuff_size;
unsigned char s[SSIZE+2],parsedat[12],
		colors[NCOLORS] = {7,5,0x70,0},		/* base colors */
		myipnum[4],
*blankline =
{"                                                                                                                                      "};
int	seenlines=0;		/* set if user requested lines ... */

#define	scmode()	SCMODE_VALUE
extern	int	SCMODE_VALUE;
int breakstop(),errhandle();
long time(),n_clicks(),lastt;
long	lastftp_time;
struct config def;				/* Default settings obtained from host file */
struct machinfo *mp=NULL;		/* Pointer to a machine information structure */
static  int     saving;
static  int     cleardata={1};                 /* set if currently saving screen */
static  int32   cleartime;
static  unsigned clear_delay={18*60*5};   /* time to clear screen 5 minutes default */

#define PSDUMP 128


#ifdef  FTPPW
unsigned long ftppassword;      /* used to store onboard random password */
#endif
int autovideo={-1};             /* set to allow auto video mode switching */
static char *large_usage[]={
		" -c 172471    sets the basic color scheme for console screen",
		" -h file      full path specification of host information file",
                " -l numlines  specify number of lines on screen. Must already be in",
                "              proper video mode.",
                "              if you have an EGA, -l 35 or -l 43 automatically sets the mode",
                " -n           disables automatic setting of the video mode for ega display",
		" -s           standalone (server) mode for rcp and ftp",
		" -t           disable direct writes to screen",
                " -d delay     specifies screen saver time in minutes [0,60].",
                "              A delay time of zero disables the screen saver.",
		 "-e 'config_data'  command line config.tel data",
		 "-r Raw_buff_size  Set raw I/O buffer size",
		NULL
};

#ifdef	__TURBOC__
unsigned _ovrbuffer = 2048;	/* paragraphs 32K */
#endif

#if	COMIO
#include <bios.h>
struct twin	*com_tw;
int		com_port;
#endif

main(argc,argv)
	int argc;
	char *argv[];
	{
	int i,j;
	int memmode = 0;
                        /* these breakstop routines where moved up here so that
                           you can ^C out of BOOTP if you're using it
                        */
	n_getchar();
	n_which();
#ifdef  __TURBOC__
        status_setup();
        ctrlbrk(breakstop);
#else
#ifdef _MSC_
	signal(SIGINT,SIG_IGN);		/* Microsoft intercept of break */
#else
	onbreak(&breakstop);			/* Lattice intercept of break */
#endif
#endif
#ifdef	NEWKEY
	n_chkchar();
#endif
#ifdef	MEM_DEBUG
	mem_init();
#endif
	n_window(0,0,rows-1,cols-1);			/* vt100 size */
	n_clear();						/* do you know where your BP is? */
	n_cur(0,0);
	start_color = n_color(7);
	nprintf(SCREEN,"CUTCP/CUTE " VERSION ", reading configuration file . . .\n");

	if(getenv("CONFIGTEL"))
		if(Shostfile(getenv("CONFIGTEL")) < 0) {
			fprintf(stderr,"Error, couldn't open configtel file %s\n",getenv("CONFIGTEL"));
			exit(1);
		}

#define  USAGE   printf("\n\nUsage: telnet [-s] [-t] [-e 'config_data'] [-c color] [-h hostfile] \
\n\t[-l numlines] [-n]  [-d saver_delay] [machinename] ...")
	if (*argv[1] == '?') {
		USAGE;
		n_row();
		for(i=0; large_usage[i];i++)
			nprintf(SCREEN,"%s\n",large_usage[i]);
		exit(1);
	}

	machparm = 1000;			/* large number */
/*
*  work on parms
*/
	for (i=1; i<argc; i++) {        /* look at each parm */
		if (*argv[i] == '-') {
			switch ( *(argv[i]+1)) {
#define	EMS		1
#define	EXTENDED 	2
#if   defined(__TURBOC__) && defined(OVERLAY)
				case 'm' :
				       	{
						unsigned kbytes = 0, offset =0;

					       	if(!strcmp(argv[i]+1,"me")) {
						       	sscanf(argv[i]+4,"%u",&kbytes);
							if(!_OvrInitEms(0, 0, kbytes)) {
							       	memmode = EMS;
							}
						}
					 	else if(!strcmp(argv[i]+1,"mx")) {
						        unsigned long start, size;
						       	sscanf(argv[i]+4,"%u,%u",&kbytes, &offset);
							start = offset * 1024L;
							size = kbytes * 1024L;
							if(!_OvrInitExt(start, size)) {
							       	memmode = EXTENDED;
							}
						 }
					  	 else
							goto usage;
				 }
					break;
#endif
			       	case 'r' :
				       	sscanf(argv[++i],"%u",&rawbuff_size);
				 	break;
                                case 'd':                       /* screen saver delay */
                                        sscanf(argv[++i],"%d",&clear_delay);
                                        if(clear_delay > 60)
                                                clear_delay = 60;
                                        clear_delay *= 18*60;      /* from 0 to 60 minutes */
                                        break;
				case 'e' :			/* config.tel data */
				       	 env_config = argv[++i];
				  	 break;
				case 'c':				/* set foreground color */
					i++;
					for (j=0; j < NCOLORS && *(argv[i]+j*2); j++)
						colors[j] = hexbyte(argv[i]+j*2);

					break;
                                case 'l':                               /* set number of lines */
                                        j = -1;
                                        sscanf(argv[++i],"%d",&j);
                                        j -= 2;
                                        if(j < DEFAULTLINES) {
                                                nprintf(SCREEN,"Number of lines is too small, must be greater than 23\n");
                                                exit(1);
                                        }
                                        if(j > MAXLINES-1) {
                                                nprintf(SCREEN,"Number of lines is too large, must be less than 60\n");
                                                exit(1);
                                        }
                                        NUMLINES = j;
                                       	n_window(0,0,NUMLINES+1,cols-1);			/* vt100 size */
					 seenlines = -1;
                                        break;
                                case 'n' :                      /* disable auto video */
                                        autovideo = 0;
                                        break;
				case 's':
					stand = 1;
					break;
				case 't':              /*  Disable direct writes to screen  */
					Scwritemode(0);
					break;
				case 'h':
					Shostfile(argv[++i]);	/* set new name for host file */
					break;
				default:
usage:;
					USAGE;
					exit(1);
			}
		}
		else {
			if (i < machparm)
				machparm = i;			/* where first machine name is */
		}

	}
	if(!seenlines)
	       	NUMLINES = rows - 2;

	for (i=0; i < NPORTS; i++)
		wins[i] = NULL;						/* we are using no windows yet */
/*
* create console window for errors, informative messages, etc.
*/
	if (0 > VSinit(NUMLINES+8))	{				/* initialize GPs virtual screens */
		nprintf(SCREEN,"Virtual screen initialization failed.\n");
		exit(1);
	}

	if (NULL == (console = creatwindow())) {
		nprintf(SCREEN,"Console memory allocation failed\n");
		exit(1);
	}

	strcpy(console->mname,"Console");

/*
* introductions on the console window
*/
	i = console->vs;
	RSvis(-1);
	nprintf(CONSOLE,"\n\n Console messages: CUTCP/CUTE\n");
	vhead(i);
	wrest(console);
/*
* initialize network stuff
*/

	if (j = Snetinit()) {
		wrest(console);
		errhandle();
		nprintf(CONSOLE,"Error initializing network or getting configuration file\n");
		if (j == -2)	/* RARP failure, special case */
			netshut();
		exit(1);
	}

	netgetip(myipnum);			/* what is my ip number? */
	Sgetconfig(&def);			/* get information provided in hosts file */

#ifdef USETEK
/*
*  install tektronix
*/
	if (stmode())
		tekinit(def.video);
#endif
#ifdef USERAS
	if (!VRinit()) {
		vprint(i,"Error initializing raster support\r\n");
	}
#endif
        ega43();        /* switch to ega 43 line text mode if ega and 43 lines */
/*
*  Display my ethernet and IP address for the curious people
*/
#ifdef  TN3270
        tn3270_init();
#endif
	pcgetaddr(&s[0],def.address,def.ioaddr);
	nprintf(CONSOLE,"My Ethernet address: %x:%x:%x:%x:%x:%x\n",s[0],s[1],
	s[2],s[3],s[4],s[5]);
	nprintf(CONSOLE,"My IP address: %d.%d.%d.%d\n\n",
		myipnum[0],myipnum[1],myipnum[2],myipnum[3]);
#ifdef	NEWKEY
	nprintf(CONSOLE,"Keyboard type is %s.\n",kbcodes & 0x10 ? "extended" : "notextended");
	Key_Init();
#endif
	if(dotop)
	       	nprintf(CONSOLE,"Using Topview Video mode\n");
#ifdef	__TURBOC__
	if(memmode) {
		nprintf(CONSOLE,"Using %s memory for swap area\n", memmode == EMS ? "Ems" : "Extended");
	}
#endif
	Stask();					/* any packets for me? (return ARPs) */

/*
*   With the parameters left on the command line, open a connection
*   to each machine named.  Start up all of the configuration on open
*   connections. 
*/
	for (i = machparm; i < argc; i++) 
		addsess(argv[i],0);

	if (current == NULL) {   		/* special viewmode for server mode */
		current = console;			/* special enter sequence avoids flicker */
		viewmode = 6;
	}

	wrest(current); 				/* paint the first session's screen */
#ifdef  FTPPW
#ifdef	_MSC_
	srand(time(NULL) & 0xffff);
#else
        randomize();
#endif
#endif
#ifdef  CLOCK
        Stimerset(USERCLASS,E_CLOCK,0,1);
#endif
	while (AF3 != dosessions()) 	/* serve all sessions, events */
		;

	endall();
#ifdef	MEM_DEBUG
	mem_check();
	mem_term();
#endif
}

/************************************************************************/
/*  dosessions
*   dosessions is an infinite loop serving three sources of external
*   input in order of precedence:
*   - changes to the video display properties
*   - keyboard strokes
*   - network events
*
*   What the user sees is top priority followed by servicing the keyboard
*   and when there is time left over, looks for network events.
*
*   viewmode is a state variable which can determine if the screen should
*   be re-drawn, etc.
*/

dosessions() 
	{
	int i,j,cl,dat,cvs;
#ifdef	NEWKEY
	unsigned int c;
#else
	int c;
#endif
	unsigned int sw;
	struct twin *t1;
	unsigned char *p;

	c = i = 0;
	switch (viewmode) {
		case 0:					/* no special mode, just check scroll lock */
		default:
			if (n_scrlck()) {	/* scroll lock prevents text from printing */
				viewmode = 1;
				i = n_row();
				j = n_col();
				c = n_color(current->colors[2]);
				n_bordcol(current->colors[0] >> 4);
				n_cur(NUMLINES+1,60);
				n_draw("* Scroll Lock *",16);	/* status in lower left */
				n_color(c);
				n_cur(i,j);
			}
/*
*  This gives precedence to the keyboard over the network.
*/
#ifdef	NEWKEY
			while ((c = newkey(current)) != 0xffff && c) {	/* do all key translations */
#else
			while (0 <= (c = newkey(current))) {	/* do all key translations */
#endif
				if (c == AF3)
					return(AF3);
                                cleardata = 1;
                        }
                        break;
		case 1:						/* scrollock is active */
			if (!n_scrlck()) {
				VSsetrgn(current->vs,0,0,cols-1,NUMLINES);
				viewmode = 0;		/* set back if appropriate */
				statline();
			}
/* 
*  In scroll lock mode, take keys only for the scrollback, 
*  The scrollback routine will never block, so we keep servicing events.
*/
			scrollback();
			break;
		case 2:						/* console is visible */
			viewmode = 9;			/* check keypress before redrawing */
			break;
		case 3:						/* help screen view1 */
		case 4:						/* help screen view2 */
#ifdef	NEWKEY
			while ((c = n_chkchar()) != 0xffff) {
#else
			while((c = n_chkchar()) > 0) {
#endif
				if (c == AF3)
					return(AF3);
				if (viewmode == 3 && c == 27) {
					viewmode = 4;
					help2(c);
				}
#ifdef  __TURBOC__
                                else if(viewmode == 3 && c == 13) {
                                        viewmode = 4;
                                        program_status();
                                }
#endif
				else { 	 			/* restore view 0 */
					if (c > 128)
						dokey(current,c);
/*    dokey might change view, if so, don't reset view 0 */
					if (viewmode >= 3 && viewmode <= 4)
						viewmode = 10;
				}
			}
			break;

		case 5:						/* DOS screen view */
			viewmode = 9;			/* wait for keypress */
			break;

		case 6:						/* server mode */
			nprintf(CONSOLE,
		"\nServer mode, press ESC to exit or ALT-A to begin a session\n");
			viewmode = 7;
		case 7:						/* server mode 2 */
			j = n_chkchar();
			switch (j) {
				case 27:
					nprintf(CONSOLE,"\n Ending server mode \n");
					return(AF3);	/* leave the program */
					break;
				case ALTA:
					if (addsess(NULL,23)) {	/* start up a new one */
						viewmode = 10;
					}
					else {
						current = console;
						viewmode = 6;
					}
					break;
				case ALTZ:
					if (addsess(NULL,513)) {	/* start up a new one */
						viewmode = 10;
					}
					else {
						current = console;
						viewmode = 6;
					}
					break;
				case ALTV:
					if (addsess(NULL,514)) {	/* start up a new one */
						viewmode = 10;
					}
					else {
						current = console;
						viewmode = 6;
					}
					break;


                                case ALTE:                      /* dos shell escape */
        				n_window(0,0,NUMLINES+1,cols-1);
	        			i = n_color(7);
					wrest(console);
		        		dosescape();
				        n_color(i);
                                        wrest(console);
                                        viewmode = 6;
                                        break;
				case -1:
					break;				/* no keypress */
				default:
					nprintf(CONSOLE,
					"\nYou must have an open session to use other commands.\n");
					viewmode = 6;
					break;
			}
			break;

		case 8:
			if (graphit())				/* graphics menu screen */
				viewmode = 10;
			break;

		case 9:							/* reset current screen on keypress */
#ifdef	NEWKEY
			if (0xffff != n_chkchar())
#else
			if (0 < n_chkchar())
#endif
				viewmode = 10;	
			break;

		case 10:						/* Display current screen */
			wrest(current);
                        if(saving)  {  /* if we were saving the screen */
                                viewmode = saving - 1;
                                saving = 0;
                                cleardata = 1;
                        }
                        else
			        viewmode = 0;				/* return to standard mode */
			statline();	
			break;
        
	}

/*
*  Check for any relevant events that need to be handled by me
*/
	if (0 < (i = Sgetevent(USERCLASS | CONCLASS | ERRCLASS, &cl, &dat))) {

		sw = cl*256 + i;				/* class and event combination */
		cvs = console->vs;

		switch (sw) {
			case CONCLASS*256+CONOPEN:
			       {
			       	struct port *p;

				/* a connection has just opened */
			        t1 = wins[dat];			/* where the window pointer is stored */
				if (!t1)
					break;
				t1->sstat = '/';		/* connection status */
				if (current != t1) {
					current = t1;
					viewmode = 10;
				}
				if(t1->telstate == RLOGIN)
				       	RloginInit(t1);
				}
			 	if(t1->telstate == RSHELL)
				       	RshellInit(t1);
#ifdef	SCRIPT
				if(t1->Script)
					Script_Event(SCRIPT_DATA, t1->Script, 0);
#endif
				break;
			case CONCLASS*256+CONCLOSE:	/* connection is closing */
				if (0 < netqlen(dat))
					netputuev(CONCLASS,CONCLOSE,dat);  /* call me again */
					/* drop through, process any data */
			case CONCLASS*256+CONDATA:
                                if(saving)
                                        viewmode = 10; 
                                cleardata = 1;
				if (viewmode && !saving) {			/* not ready for it */
					netputuev(CONCLASS,CONDATA,dat);
					break;
				}
			        t1 = wins[dat];			/* where the window pointer is stored */
				if (!t1)
					break;
				if (inprocess(t1)) {
bug_out:;
                                        if(stand) {
                                                viewmode = 6;
                                                current = console;
						 clearstat();
                                                wrest(current);
                                                return(0);
                                        }
					return(AF3);
                                }
				break;
			case CONCLASS*256+CONFAIL:	/* can't open connection */
			    t1 = wins[dat];			/* where the window pointer is stored */
				if (!t1)
					break;				/* this don't count */
				nprintf(CONSOLE,"\nCan't open connection, timed out\n");
				netclose(dat);			/* close out attempt */
				if (!t1->next) {
					delwindow(t1,1);
					goto bug_out;
				}
				if (t1 == current) {
					current = current->next;
					viewmode = 10;
				}
				delwindow(t1,1);
				statline();
				break;
/*
*  domain nameserver results.
*/
			case USERCLASS*256+DOMFAIL:			/* domain failed */
				mp = Slooknum(dat);	/* get machine info */
				nprintf(CONSOLE,"\nDOMAIN lookup failed for: %s\n",
				       		mp && mp->hname ? mp->hname :
						     mp && mp->sname ? mp->sname : "UNKNOWN!");
				break;
			case USERCLASS*256+DOMOK:
				mp = Slooknum(dat);	/* get machine info */
				if (mp) {
					nprintf(CONSOLE,"\nDOMAIN lookup OK for: %s %s\n",
					       	mp->hname ? mp->hname : "",
						       mp->sname ? mp->sname : "");
					/* print session name and host name */
#ifdef	SCRIPT
					if(mp->flags & MFLAGS_SCRIPT) {
						Script_Event(SCRIPT_DOMAIN,mp,0);
					}
				 	else
#endif
					{					
						if (mp->sname) {
							addsess(mp->sname,0);
						}
						else
							addsess(mp->hname,0);
						viewmode = 10;
					}
				}
				
				break;
/*
*  FTP status events.
*/
			case USERCLASS*256+FTPBEGIN:		/* data connection */
				ftpact = dat;
				Sftpname(s);					/* get name */
				nprintf(CONSOLE,"FTP transferring: %s\n",s);
				ftpstart(ftpact+2,s);
				lastt = n_clicks();
				break;
			case USERCLASS*256+FTPLIST:			/* LIST or NLST */
				nprintf(CONSOLE,"FTP directory beginning\n");
				break;
			case USERCLASS*256+FTPEND:			/* data connection ending */
				ftpact = 0;
				statline();
				nprintf(CONSOLE,"FTP transfer done\n");
				break;
			case USERCLASS*256+FTPCOPEN:		/* command connection */
				Sftphost(s);
				if(time(NULL) > (lastftp_time + 5) ) {
				        n_play(sounds[SOUND_FTP]);
				}
				if ((NULL == (mp = Slookip(s))) || (NULL == mp->sname)) 
					sprintf(&s[4],"%d.%d.%d.%d",s[0],s[1],s[2],s[3]);
				else
					sprintf(&s[4],"%s",mp->sname);
				nprintf(CONSOLE,"FTP server initiated from host: %s\n",&s[4]);
				break;
			case USERCLASS*256+FTPUSER:			/* user name entered */
				Sftpuser(s);
				nprintf(CONSOLE,"FTP user %s login request\n",s);
				break;
			case USERCLASS*256+FTPPWOK:			/* user password verified */
				nprintf(CONSOLE,"FTP Password verified\n");
				break;
			case USERCLASS*256+FTPPWNO:			/* user password failed */
				nprintf(CONSOLE,"FTP Password failed verification\n");
				break;
			case USERCLASS*256+FTPCLOSE:		/* command connection ends */
				nprintf(CONSOLE,"FTP server ending session\n");
				break;
			case USERCLASS*256+RCPBEGIN:		/* rcp starting */
				nprintf(CONSOLE,"rcp file transfer\n");
				rcpact = 1;
				break;
			case USERCLASS*256+RCPEND:			/* rcp ending */
				nprintf(CONSOLE,"rcp ending\n");
				rcpact = 0;
				break;
#ifdef USETEK
			case USERCLASS*256+PSDUMP:			/* dump graphics screen */
				if (VGpred(indev,outdev)) {
					if (dat) {
						endump();
						nprintf(CONSOLE,"Graphics writing finished\n");
						wrest(console);
						viewmode = 2;
					}
				}
				else
					netputevent(USERCLASS,PSDUMP,dat);	/* remind myself */
				break;
#endif
#ifdef  CLOCK
                        case USERCLASS*256+E_CLOCK:
                                showclock(1);
                                Stimerset(USERCLASS,E_CLOCK,0,1);
                                break;
#endif
#ifdef	SCRIPT
			case USERCLASS*256 + SCRIPT_FUNC:
			       	Script_Event(SCRIPT_EVENT,NULL,dat);
			 	break;
#endif
			case ERRCLASS*256+ERR1:						/* error message */
				p = neterrstring(dat);
				VSwrite(cvs,p,strlen(p));
				VSwrite(cvs,"\r\n",2);
			default:
				break;
		}
	}
/*
*   update the FTP spinner if we are in ftp
*/
	else if (ftpact && (n_clicks() > lastt + 10)) {
		ftpstart(ftpact+2,s);
		lastt = n_clicks();
	}

#if	COMIO
	if(capon && com_port) {		/* poll the com port for data to send back to the host */
		if((bioscom(3,0,com_port-1) & 0x0120) == 0x120) {	/* data ready */
			int val = bioscom(2,0,com_port-1);
		 	if(!(val & 0xff00)) {
				netwrite(com_tw->pnum, &val, 1);
		        }
	       }
	}
#endif
	return(c);

}

/*********************************************************************/
/* inprocess
*  take incoming data and process it.  Close the connection if it
*  is the end of the connection.
*/
inprocess(tw)
	struct twin *tw;
	{
	int cnt;

	cnt = netread(tw->pnum,s,SSIZE);	/* get some from incoming queue */

	if (cnt < 0) {					/* close this session, if over */
		netclose(tw->pnum);
		leavetek();
		if (tw->capon) {
			fclose(tw->capfp);		/* close the capture file */
			tw->capon = capon = 0;
		}
		n_color(tw->colors[0]);
#ifdef	TN3270
		if(tw->tnmode && tw->tn3270_data) {
		 	mem_free(tw->tn3270_data);	/* free the tnbuffer */
			tw->tn3270_data = NULL;
	        }
#endif	
		if (tw->next == NULL) { 		/* if this is the last one */
                       delwindow(tw,1);
			return(-1);				/* signal no sessions open */
                }

#ifdef USETEK
		leavetek();					/* make Tek inactive */
#endif
		if (tw != current) {
			wrest(tw);
		}

		if(!(tw->flags & TWIN_FLAGS_CLOSE_NOWAIT)) {
			nprintf(SCREEN,"\n\rConnection closed, press a key . . .\n");
			viewmode = 9;
		}
		else
			viewmode = 10;
		if (tw == current)
			current = tw->next;
		delwindow(tw,1);
		return(0);
	}

	if (cnt) {
	        if((Scon.bios == 2) && (tw == current)) {
		       	Scwritemode(0);
			parse(tw,s,cnt);
			Scwritemode(1);
		}
	 	else
			parse(tw,s,cnt);			/* display on screen, etc.*/
       }
	return(0);

}


#define STNORM	0
#define GOAHEAD 249
#define WILLTEL 251
#define WONTTEL 252
#define DOTEL	253
#define DONTTEL 254
#define ESCFOUND 5
#define IACFOUND 6

#define SUBSIZE 32
/*  parse
*   Do the telnet negotiation parsing.
*
*   look at the string which has just come in from outside and
*   check for special sequences that we are interested in.
*
*   Tries to pass through routine strings immediately, waiting for special
*   characters ESC and 255 to change modes.
*/


parse(tw,st,cnt)
	struct twin *tw;
	int cnt;
	unsigned char *st;
	{
	int i, option;
	unsigned char *mark,*orig;

static  char suboption[SUBSIZE];
static  int  subsize,iaccount;
        char xbuff[80];

	if(tw->termstate == LOADTYPE) {
	   	LoadWrite(tw,st,cnt);
		return;
	}

	orig = st;				/* remember beginning point */
	mark = st + cnt;		/* set to end of input string */
	netpush(tw->pnum);

       if(tw->telstate >= RLOGIN) {	/* rlogin doesn't do any processing */
	       	parsewrite(tw,st,cnt);
		return;
	}
/*
*  traverse string, looking for any special characters which indicate that
*  we need to change modes.
*/
	while (st < mark) {

		switch (tw->telstate) {
			case ESCFOUND:
#ifdef USETEK_OLD
				if (*st == 12)	{		/* esc-FF */
					if (tw->termstate == VTEKTYPE) {
						vprint(cv,"\n\r Entering Tek mode \n\r");
						tw->termstate = TEKTYPE;
						VGgmode(rgdevice);
						VGuncover(temptek);
						current=tw;
					}
					VGwrite(temptek,"\033\014",2); 
					orig = ++st;		/* pass by ESC-FF in data */
					tw->telstate = STNORM;
					break;
				}
#endif 
#ifdef USERAS
				if (*st == '^') {		/* esc-^ */
					tw->termstate = RASTYPE;
					tw->telstate = STNORM;
					current=tw;
					VRwrite("\033^",2);			 /* echo ^ */
					orig = ++st;
					break;
				}
#endif
				parsewrite(tw,"\033",1);        /* send the missing ESC */

				tw->telstate = STNORM;
				break;
			case IACFOUND: 		/* telnet option negotiation */
#ifdef  TN3270
                                if(tw->tnmode) {
                                        if(*st == IAC)  {
                                                *(tw->tn3270_front++) = *st;
                                                tw->telstate = STNORM;
                                        }
                                        else {
                                                tw->telstate = *st;
                                                if(*st == EOR)
                                                        continue;  /* loop to get eor in this shot */
                                        }
                                        orig = ++st;
                                        continue;
                                }
#endif
				if (*st == 255) {		/* real data = 255 */
					st++;				/* real 255 will get sent */
					tw->telstate = STNORM;
					break;
				}
				if ( 238 < *st ) {
					tw->telstate = *st;		/* by what the option is */
					st++;
					break;
				}
				nprintf(CONSOLE,"\nStrange telnet option %d\n",*st);
				orig = st;
				tw->telstate = STNORM;
				break;
			case GOAHEAD:
				tw->telstate = STNORM;
				orig = st;
				break;
			case DOTEL:
                                dooption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
			case DONTTEL:
                                dontoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
			case WILLTEL:
                                willoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
							
			case WONTTEL:
                                wontoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
                        case  SB :      /* sub negotiation */
				tw->telstate = SE;
                                iaccount = subsize = 0;
                                break;
                                        /* since we use a single static buffer,
                                           if two windows try sub negotiation at the
                                           same time there will be trouble */
                        case  SE :
                                if(*st == SE) {
                                        tnsuboption(tw, suboption,subsize);
                                        set3270_mode(tw);
                                        tw->telstate = STNORM;
                                }
                                else if(*st == IAC) {
                                        if(iaccount) {
                                                if(subsize < SUBSIZE-1) {
                                                        suboption[subsize++] = IAC;
                                                }
                                                iaccount = 0;
                                        }
                                        else
                                                iaccount = 1;
                                }
                                else {
                                        if(subsize < SUBSIZE-1) {
                                                suboption[subsize++] = *st;
                                        }
                                }
                                orig = ++st;
                                break;
#ifdef  TN3270
                        case    EOR :           /* end of record */
                                orig = ++st;    /* remember to do this */
                                if(tw->tnmode) {
                                        unsigned char *x;
                                        
/* ### */
                                        x = tw->tn3270_base;
                                        x += XDataFromNetwork(tw,1);    /* calls special data from network */
                                        if(x == tw->tn3270_front) {
                                                tw->tn3270_base = tw->tn3270_front = tw->tn3270_data;
                                        }
                                        else {
#ifdef	DEBUGMEM
	if(x > tw->tn3270_front)
	       printf("\n\r\007 Data From network overflow!\n\r");
#endif
                                                tw->tn3270_base = x;
                                        }
                                }
                                tw->telstate = STNORM;
				 if(slip_mode && current == tw)
						statline();
#ifdef	SCRIPT
				if(tw->Script)
				       	Script_Event(SCRIPT_DATA,tw->Script,0);
#endif

                                break;
#endif
			default:
				tw->telstate = STNORM;
				break;
		}

/*
* quick scan of the remaining string, skip chars while they are
* uninteresting
*/
		if (tw->telstate == STNORM) {
/*
*  skip along as fast as possible until an interesting character is found
*/
#ifdef  TN3270
                        if(tw->tnmode) {
                                unsigned char c;
                                while(st < mark) {
                                        c = *st++;
                                        if(c == IAC) {
                                                tw->telstate = IACFOUND;
                                                break;
                                        }
                                        *(tw->tn3270_front++) = c;
					if((FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)) > TNSHOVE) {
					       unsigned char *x = tw->tn3270_base;
						x += XDataFromNetwork(tw,0);
						if(x == tw->tn3270_front) {
	                                                tw->tn3270_base = tw->tn3270_front = tw->tn3270_data;
	                                        }
	                                        else {
#ifdef	DEBUGMEM
	if(x > tw->tn3270_front)
	       printf("\n\r\007 Data From network overflow!\n\r");
#endif

	                                                tw->tn3270_base = x;
	                                        }
					}

                                        if((FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_data)) >= TNBUFFSIZE) {
						memmove(tw->tn3270_data, tw->tn3270_base, (FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)));
						tw->tn3270_front = tw->tn3270_data + (FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base));
						tw->tn3270_base = tw->tn3270_data;
#ifdef	TRASH
						 char buff[100];
						 nprintf(SCREEN,"\n\rFatal: TNBUFF overflow. Data %lp, base %lp, front %lp\n\r",
							tw->tn3270_data, tw->tn3270_base, tw->tn3270_front);
                                                netshut(0);
                                                exit(1);
#endif
                                        }
                               }	 
                               orig = st;
				if(slip_mode && current == tw)
				       	statline();
                               continue;
                        }
#endif                        
/*			while (st < mark && *st != 27 && *st < 255) { */
			if (!tw->binary) {
				register int cnt = mark - st;
				while(cnt-- && *st != 255) {
					*(st++) &=127;
				}
			 }
		  	else {
			       	register int cnt = mark - st;

				while(cnt-- && *st != 255)
				       	st++;
			 }

			parsewrite(tw,orig,st-orig);

			orig = st;				/* forget what we have sent already */

			if (st < mark)
			switch (*st) {
				case 255:			/* telnet IAC */
					tw->telstate = IACFOUND;
					st++;
					break;
#ifdef	VESTIGIAL
				case 27:			/* ESCape code */
					if (st == mark-1 || *(st+1) == 12 || *(st+1) == '^') {
						tw->telstate = ESCFOUND;
					}
					st++;			/* strip or accept ESC char */
			
					break;
#endif
				default:
					nprintf(CONSOLE," strange char %d\n",*st);
					st++;
					break;
			}

		}

	}  /* end while */

}

/*********************************************************************/
/*  parsewrite
*   write out some chars from parse
*   Has a choice of where to send the stuff
*/
parsewrite(tw,dat,len)
	struct twin *tw;
	char *dat;
	int len;
	{
	int i,xlen;
/*
*  send the string where it belongs
*  1. Check for a capture file.  If so, echo a copy of the string
*  2. Check for dumb terminal type, convert special chars if so
*  3. Check for Tektronix mode, sending Tek stuff
*  3b. check for raster color type
*  4. or, send to virtual screen anyway
*/
/*
* raw mode for debugging, passes through escape sequences and other
* special characters as <27> symbols
*/
	if(tw->flags & TWIN_FLAGS_DISCARDING)
	       	return;
top:;		/* sigh, ugly I know */
	xlen = len;

	if (tw->termstate == DUMBTYPE) {
		for (i=0; i < len ; i++,dat++) 
			if (!isascii(*dat) && !isprint(*dat)) {
				sprintf(parsedat,"<%d>",*dat);
				VSwrite(tw->vs,parsedat,strlen(parsedat));
			}
			else
				VSwrite(tw->vs,dat,1);
	}
	else {
#ifdef USETEK
		if (tw->termstate == TEKTYPE) {
			i = VGwrite(temptek,dat,len);
			if (i < len) {
				leavetek();
				viewmode=10;
				xlen -= i;
/*				parsewrite(tw,dat+i,len-i); */
			}
		}				
		else 
#endif
#ifdef USERAS
		if (tw->termstate == RASTYPE) {
			i = VRwrite(dat,len);
			if (i < len) {
				tw->termstate = VTEKTYPE;
				xlen -= i;
/*				parsewrite(tw,dat+i,len-i); */
			}
		}
		else
#endif
			{			
				if((i = VSwrite(tw->vs,dat,len)) > 0) {	/* send to virtual VT102 */
					/* VSwrite returns # chars NOT processed */
					xlen = len -  i;
				 	
			       }
			}


	}
	if (tw->capon) {		/* capture to file? */
	       	 if(xlen > 0)
			 fwrite(dat,xlen,1,tw->capfp);
                if (tw->capon == -1 ) {
                                fclose(tw->capfp);
                                capon = tw->capon = 0;
                                tw->capfp = NULL;
                                capstat("Capture Off");
                }
        }
#ifdef	SCRIPT
	if(tw->Script && len)
	       	Script_Event(SCRIPT_DATA,tw->Script,0);
#endif

 	if((len - xlen) > 0) {
	       	dat += xlen;
		len -= xlen;
		goto top;
	}
}

/*********************************************************************/

breakstop()
	{
	foundbreak = 1;
#ifdef  __TURBOC__
        ctrlbrk(breakstop);
        return(1);
#else
	return(0);
#endif
}

/*********************************************************************/
/* newkey
*  filter for command key sequences
*/
#ifdef	NEWKEY
unsigned
#endif
newkey(t1)
	struct twin *t1;
	{
#ifdef	NEWKEY
	unsigned int c;
#else
	int c;
#endif

	if (foundbreak) {
		foundbreak = 0;
		c = '\003';					/* ctrl-c */
	}
	else {
		if (t1->echo)
			c = n_chkchar();		/* a char available ?*/
		else if (t1->halfdup) {		/* half duplex */
			c = n_chkchar();
			if (c == 13) {
				parse(t1,"\r\n",2);	/* echo crlf */
				vt100key(13);
				c = 10;
			} else if (c > 0 && c < 128)
				parse(t1,&c,1);		/* echo char */
		}
		else {						/* line mode */
			c = RSgets(t1->vs,t1->linemode,cols-1);
			if (c == 13) {			/* pressed return */
				parse(t1,"\r\n",2);     /* echo the return */
				strcat(t1->linemode,"\r\n");
				netpush(t1->pnum);
				netwrite(t1->pnum,t1->linemode,strlen(t1->linemode));
				t1->linemode[0] = '\0';
#ifdef	NEWKEY
				c = 0xffff;
#else
				c = 0;
#endif
			}
#ifdef	NEWKEY
			else if (c != 0xffff) {		/* write string, pass c to command interp */
#else
			else if (c > 0) {		/* write string, pass c to command interp */
#endif
				if (t1->linemode[0]) {
					netpush(t1->pnum);
					netwrite(t1->pnum,t1->linemode,strlen(t1->linemode));
					t1->linemode[0] = '\0';
				}
			}
		}
	}
#ifdef	NEWKEY
	if (c == 0xffff)
#else
	if (c <= 0)
#endif
		return(c);

	return(dokey(t1,c));

}


/************************************************************************/
/*  dokey
*   translates and sends keys and filters for command keys
*
*/
dokey(t1,c)
	struct twin *t1;
#ifdef	NEWKEY
	unsigned int c;
#else
	int c;
#endif
	{
	int i;

		switch (c) {
			case BACKSPACE:
				c = t1->bksp;			/* allows auto del instead of bs */
				break;
			case 13:					/* different CR mappings */
#ifdef  TN3270_NEWKEY
                                if(t1->tnmode)
                                        XDataFromTerminal(t1,&c,1);
                                else {
#endif
        				vt100key(13);
				     	if(!t1->binary)
		        			vt100key(t1->crfollow);
#ifdef  TN3270_NEWKEY
                                }
#endif
				c = 0;
				break;
			case 127:
				c = t1->del;		/* switch bs around, too */
				break;

			case THENUL:			/* user wants the true NUL char */
				c = 0;
#ifdef  TN3270
                                if(!t1->tnmode)
#endif
        				netwrite(t1->pnum, &c, 1);	/* write a NUL */
				break;
		 } /* end switch */

#ifdef	NEWKEY
	if (c > 0 && c != 0xffff) {
#else
	if (c > 0) {
#endif
#ifdef  TN3270_NEWKEY
                if(t1->tnmode)  {
                        XDataFromTerminal(t1, &c, 1);
                        c = 0;
                }
                else
#endif
		        vt100key(c);			/* send it, with VT100 translation */

        }
    	c = 0;
	return(c);

}

int
Command_Key(Macro *M, struct twin *t1, char *args)
{
	unsigned char c,*ii,*z;
	unsigned int i;
	struct twin *t;
	switch(M->M_code & 0x1fff) {

	       	        case ALTB: 		/* alt -b, remap keys, macro only */
			       	if(!args)
				       	break;
				if((ii = strchr(args,','))) {
				       	*ii = 0;
					if(!stricmp(args,"default")) {
					       	if(Default_Key_Config) {
						       	Key_Free_Lib(Default_Key_Config);
							Default_Key_Config = Key_Load_File(ii+1);
							break;
						}
					 	else
						       	args = ii+1;
					 }
				}
				if(t1->key_map) {
				       	Key_Free_Lib(t1->key_map);
					t1->key_map = NULL;
			        }
				t1->key_map = Key_Load_File(args);
				break;
			case ALTJ :		/* alt - j sys_show macro */
			        if(!args)
				       	break;
		       		t = t1->next;
				while(t && t != t1) {
				       	if(!stricmp(args,t->mname)) {
					       	current = t;
						viewmode = 10;
						break;
					}
				 	t = t->next;
				}
			 	break;
			case CTRLHOME:				/* tek clear screen */
#ifdef  TN3270
                                if(current->tnmode)
                                        break;
#endif                                                                     
				if (current->termstate != TEKTYPE) {
					current->termstate = TEKTYPE;
					VGgmode(rgdevice);
					VGuncover(temptek);
				}
				VGwrite(temptek,"\033\014",2);	/* clear storage and screen */
				c = 0;
				break;

			case HOME:				/* clear to text */
			case (HOME|0x1000) :
				if (leavetek()) {
					viewmode = 10;
					c = 0;
				}
				break;

			case ALTH:				/* help display */
				viewmode = 3;
				helpmsg();
				c = 0;
				break;

			case ALTP:				/* change a parameter */
				parmchange();
				c = 0;
				break;

			case ALTR:				/* reset screen values */
				if (!leavetek()) {
					if (current->capon) {
						fclose(current->capfp);
						current->capon = capon = 0;
					}
					VSreset(current->vs);		/* reset's emulator */
#ifdef  TN3270
                                        if(current->tnmode)
                                                tn_vsreset(current->vs);
#endif
				}
				wrest(current);
				c = 0;
				break;

#ifdef USETEK
			case ALTG:			/* graphics manipulation */
				c = 0;
				leavetek();
				dispgr();
				break;
#endif

			case ALTE:
				leavetek();
				n_window(0,0,NUMLINES+1,cols-1);
#ifdef	OLD
				i = n_color(current->colors[0]);
#else
				i = n_color(7);
#endif
				dosescape();
				viewmode = 5;
				n_color(i);
				c = 0;
				break;

			case ALTC:							/* toggle capture */
				if (capon && current->capon) {	/* already on */
					capstat("Capture off");
					fclose(current->capfp);		/* close the capture file */
					current->capon = capon = 0;
				}
				else if (!capon) {				/* I want one */
					FILE *Sopencap();
					if (NULL == (current->capfp = Sopencap())) {
						nprintf(CONSOLE,"\nCannot open capture file\n");
						break;
					}
					capstat("Capture on ");
					current->capon = capon = 1;
#if	COMIO
					if(com_port)
					       	com_tw  = current;
#endif
				}
				else {
					nprintf(CONSOLE,"Another session has capture file open, cannot open two at once\n");
					wrest(console);
					viewmode=2;
				}
					
				c=0;
				break;
                        case ALTD:              /* dump screen to capture file */
				 DoScreenDump();
                                c = 0;
                                break;
			case ALTI:							/* my internet address */
				sprintf(s,"%d.%d.%d.%d",myipnum[0],myipnum[1],myipnum[2],myipnum[3]);
#ifdef  TN3270
                                if(t1->tnmode)
                                        XDataFromTerminal(t1,s,strlen(s));
                                else
#endif
				        netwrite(t1->pnum,s,strlen(s));
				if (!t1->echo)
					parse(t1,s,strlen(s));     	/* echo the string */
				c = 0;
				break;

			case ALTT:							/* an ftp command */
#ifdef	JUNK
				if (Sneedpass())
#endif
					strcpy(s,"ftp ");
#ifdef	JUNK				 
				else
					strcpy(s,"ftp -n ");
#endif
				sprintf(&s[strlen(s)],"%d.%d.%d.%d\r",
					myipnum[0],myipnum[1],myipnum[2],myipnum[3]);
 				lastftp_time = time(NULL);

			 	if(!t1->binary) {
				       int x = strlen(s);
				       s[x++] = t1->crfollow;
				       s[x] = 0;
			        }

#ifdef  TN3270
                                if(t1->tnmode)	{
                                        XDataFromTerminal(t1,s,strlen(s)); 
				 }  
                                else
#endif
        				netwrite(t1->pnum,s,strlen(s));

				if (!t1->echo)
					parse(t1,s,strlen(s));     /* echo the string */
				c = 0;
				break;
#ifdef  FTPPW
                        case ALTW:                      /* xmit inboard ftp password */
                                ftppassword = (( ( (long) rand() <<  16L) + (long) rand()) | 1L) & 0x5f5e0ff;
			  			/* above & is to be sure that no passwords are
						   longer than 8 characters */

                                                /* can't allow it to be 0 */
      				sprintf(s,"%ld\r",ftppassword);
			 	if(!t1->binary) {
				       int x = strlen(s);
				       s[x++] = t1->crfollow;
				       s[x] = 0;
			        }
#ifdef  TN3270
                                if(t1->tnmode) {
                                        XDataFromTerminal(t1,s,strlen(s));
				 }
                                else
#endif
        				netwrite(t1->pnum,s,strlen(s));
				c = 0;
				break;
#endif
			case ALTQ:				/* are you there? */
			        if(t1->telstate < RLOGIN) {
					netpush(t1->pnum);
					netwrite(t1->pnum,"\377\366",2);
				}
				c = 0;
				break;

			case ALTO:				/* abort output */
			        if(t1->telstate < RLOGIN) {
					netpush(t1->pnum);
					netwrite(t1->pnum,"\377\365",2);
				}
				c = 0;
				break;
				
			case ALTY:				/* interrupt */
			        if(t1->telstate < RLOGIN) {
					netpush(t1->pnum);
					netwrite(t1->pnum,"\377\364",2);
					t1->flags |= TWIN_FLAGS_DISCARDING;
					sendoption(t1,TELOPT_TM,DO);


				}
				c = 0;
				break;
				
			case ALTU:				/* erase line */
				if(t1->telstate < RLOGIN) {
				        netpush(t1->pnum);
					netwrite(t1->pnum,"\377\370",2);
				}
				c = 0;
				break;
				
			case ALTK:				/* erase char */
				if(t1->telstate < RLOGIN) {
				        netpush(t1->pnum);
					netwrite(t1->pnum,"\377\367",2);
				}
				c = 0;
				break;
				
			case ALTA:				/* add session */
				c = 0;
				if (!addsess(args,23)) {		/* start up a new one */
#ifdef	JUNK
					nprintf(CONSOLE,"\nPress any key to continue . . .");
					viewmode = 9;
				}
				else
#else
}
#endif
					viewmode = 10;
				break;

			case ALTZ:			/* add rlogin session */
				c = 0;
				if (!addsess(args,513)) {		/* start up a new one */
#ifdef	JUNK
					nprintf(CONSOLE,"\nPress any key to continue . . .");
					viewmode = 9;
				}
				else
#else
}
#endif
					viewmode = 10;
				break;

			case ALTV:			/* add rshell session */
				c = 0;
				if (!addsess(args,514)) {		/* start up a new one */
#ifdef	JUNK
					nprintf(CONSOLE,"\nPress any key to continue . . .");
					viewmode = 9;
				}
				else
#else
}
#endif
					viewmode = 10;
				break;


			case ALTM:
				c = 0;
				leavetek();
				wrest(console);
				viewmode = 2;				/* console view mode */
				break;
                        case ALTL:                              /* last, previous window */
                                c = 0;
                                if(current->prev == NULL)
                                        break;
                                current = current->prev;
                                leavetek();
                                viewmode = 10;
                                break;
                                   
			case ALTN:						/* session switch */
				c = 0;
				leavetek();
				if (current->next == NULL)   /* are we only one ? */
					break;
				current = current->next;
				viewmode = 10;
				break;

			case ALTS:						/* skip to end */
#ifdef  TN3270
                                if(!t1->tnmode) {
#endif
					if(t1->telstate < RLOGIN) {
						t1->flags |= TWIN_FLAGS_DISCARDING;
						sendoption(t1,TELOPT_TM,DO);
					}
        				c = 0;
	        			RSvis(0);
                		        while (0 < (i = netread(t1->pnum,s,SSIZE)))
					        parse(t1,s,i);
        				viewmode = 10;
#ifdef  TN3270
                                }
#endif
				break;

			case ALTX:						/* close the connection */
				leavetek();
			 	if(args && !stricmp(args,"noask")) {
				       	netclose(t1->pnum);
					Stask();
					netputuev(CONCLASS,CONCLOSE,t1->pnum);
					break;
				}
				nprintf(SCREEN,"\n Are you sure you want to close the connection? Y/N\n");
				c = nbgetch();				/* get the answer */
				if (tolower(c) == 'y') {
					nprintf(SCREEN,"\n Attempting to close . . .\n");
					netclose(t1->pnum);
					Stask();
					netputuev(CONCLASS,CONCLOSE,t1->pnum);
				}
				else
					viewmode=10;			/* redraw screen */
				c = 0;
				break;

			case AF9:
				statcheck(NULL);
				break;

			case AF3:
			       	endall();
			 	exit(0);
				break;
#ifdef	SCRIPT
			case ALTMINUS :	/* kill current script if there is one */
			       	 if(current->Script)
				       	Script_Event(SCRIPT_FORCE,current->Script,0);
				 else if(args)
					Script_Spawn(args,current);
				 else
				       	Spawn_Script(current);
				 c = 0;
				 break;
#endif
			default:
				break;

		}
	return(0);
}

/***********************************************************************/

wrest(t)
	struct twin *t;
	{

	RSvis(t->vs);
	statline();						/* done before, moves cursor */
	VSredraw(t->vs,0,0,cols-1,NUMLINES);		/* redisplay, resets cursor correctly */

}

static	char	clock_text_buff[10]={"         "};

/***************************************************************************/
#ifdef  CLOCK
showclock(int mode)
{
   extern int clockmode;
#ifdef	__TURBOC__	
   struct time t;
#else
   struct tm *t;
   time_t  ti;
#endif
   char buff[133];
   int rw,cl,c;
static unsigned char z = 1;
static long lasttime;

   if (current == NULL || current->termstate == TEKTYPE || saving || !clockmode)
        return;
   rw = n_row();
   cl = n_col();

   if(!cleardata && n_clicks() > cleartime ) {
        saving = viewmode+1;
        viewmode = 9;
        n_color(0);
	 n_bordcol(0);
	n_clear();              /* clear the current screen */

        n_cur(NUMLINES+1,0);
        for(c=0; c < cols; c++)
                buff[c] = ' ';
        if (scmode())
	        n_cheat(buff,cols);       /* clear the statline too */
        else
                n_draw(buff,cols);
        n_cur(rw,cl);
        RSsetatt(512,current->vs);
   }

   if (current == console || saving)
		return;
   if(cleardata && clear_delay) {
           cleartime = n_clicks() + clear_delay;
           cleardata = 0;
   }
   c = 	n_color(current->colors[0]);
   lasttime = time(NULL);
   z = z ^ 1;
#ifdef	__TURBOC__
   gettime(&t); 
   if(clockmode == 12) {
	   	if(t.ti_hour > 12)
		       	t.ti_hour -= 12;
   }
   sprintf(clock_text_buff,"%02d%c%02d  ",t.ti_hour, z & 1 ? ':' : ' ', t.ti_min);
#else
   time(&ti);
   t = localtime(&ti);
   if(clockmode == 12) {
	   	if(t->tm_hour > 12)
		       	t->tm_hour -= 12;
   }
   sprintf(clock_text_buff,"%02d%c%02d    ",t->tm_hour, z & 1 ? ':' : ' ', t->tm_min);
#endif
   if(!mode && (lasttime == time(NULL)))
	   return;

   if (scmode()) {
	n_vcur(NUMLINES+1,cols - 6);
	n_cheat(clock_text_buff,5);		    /* machine name of connection */
	n_vcur(rw,cl);
   }
   else {
	 n_cur(NUMLINES+1,cols - 6);
        n_draw(clock_text_buff,5);
	 n_cur(rw,cl);
   }
   n_color(c);
}
#endif


clearstat()
{

       n_cur(NUMLINES+1,0);

	if (scmode()) {
		n_cheat(blankline,80);		/* fill out to 16 spaces */
	}
	else {
		n_draw(blankline,80);			/* fill out to 16 spaces */
       }
}

statline()
	{
	struct twin *t1,*t2;
	int wn,i,c,sm,rw,cl;
#ifdef  TN3270
        char    oia_buff[80];
 	unsigned count;
 	extern	int	slip_mode;
#endif
static	char	stat_boxes[3]={'$',' ',0};

#define	STAT_BOX(n)	{stat_boxes[0] = n; if(sm) n_cheat(&stat_boxes,2); else n_draw(&stat_boxes,2);}

	if (current == NULL || current == console || current->termstate == TEKTYPE || saving)
		return(0);

	c = n_color(current->colors[0]);			/* save current color */
	if (current->sstat != '*')
		current->sstat = 254;					/* this is current one */
	rw = n_row();
	cl = n_col();

	t1 = t2 = current;
	wn = 0;
	sm = scmode();
#ifdef  TN3270
        if(current->tnmode) {
                int z;

		if(sm)
	               n_vcur(NUMLINES+1,0);
		else
		       n_cur(NUMLINES+1,0);
#ifdef	SCRIPT
		if(current->Script)
		       	n_color(t1->colors[2]|128);
		else
#endif
			n_color(t1->colors[2]);
		if (t1->sstat == 254 && t1 != current)
			t1->sstat = 176;
		STAT_BOX(t1->sstat);
		z = i = strlen(t1->mname);
                z += 3;
		if (sm) {
			n_cheat(t1->mname,i);		    /* machine name of connection */
			n_cheat(blankline,1);		/* fill out to 16 spaces */
		}
		else {
			n_draw(t1->mname,i);		    /* machine name of connection */
			n_draw(blankline,1);			/* fill out to 16 spaces */
		}
                i = Get_OIA(oia_buff);

                if (sm)
		        n_cheat(oia_buff,i);			/* fill to edge of screen */
               	else
	        	n_draw(oia_buff,i);				/* fill to edge of screen */
                if(current->next && current->next != current)
                        t1 = current->next;
		 if(slip_mode)	{	/* if going through a serial line,
					  show the amount of incoming data
					*/
			if((count = FP_OFF(current->tn3270_front) - FP_OFF(current->tn3270_data))) {
				sprintf(oia_buff,"%u",count % TNBUFFSIZE);
				count = strlen(oia_buff);
				if(sm)
				       	n_cheat(oia_buff,count);
				else
				       	n_draw(oia_buff,count);
				i += count;
			}
		 	if(portlist[current->pnum]) {
			       	if(count = portlist[current->pnum]->out.contain) {
					sprintf(oia_buff,"(%d)",count);
					count = strlen(oia_buff);
					if(sm)
					       	n_cheat(oia_buff,count);
					else
					       	n_draw(oia_buff,count);
					i += count;
				}
			 }
				
		 }

                i += z;
                wn = i/18 + 1;
        	if (sm)
	        	n_cheat(blankline,18 * wn-i);			/* fill to edge of screen */
        	else
	        	n_draw(blankline,18 * wn-i);				/* fill to edge of screen */
                n_color(c);

        }
        if( !current->tnmode || (current->next && current->next != current) )
#endif
	do {

		if(sm)
			n_vcur(NUMLINES+1,wn*18);
		else
			n_cur(NUMLINES+1,wn*18);
#ifdef	SCRIPT
		if(t1->Script)
		       	n_color(t1->colors[2]|128);
		else
#endif
			n_color(t1->colors[2]);
		if (t1->sstat == 254 && t1 != current)
			t1->sstat = 176;
		STAT_BOX(t1->sstat);
		i = strlen(t1->mname);
		if (sm) {
			n_cheat(t1->mname,i);		    /* machine name of connection */
			n_cheat(blankline,16-i);		/* fill out to 16 spaces */
		}
		else {
			n_draw(t1->mname,i);		    /* machine name of connection */
			n_draw(blankline,16-i);			/* fill out to 16 spaces */
		}

		if (t1->next)					/* if not the only window open */
			t1 = t1->next;

		wn++;
	} while (t1 != t2 && wn < (cols/18));
	n_color(current->colors[0]);

	if (sm) {
		n_vcur(NUMLINES+1,wn*18);
		n_cheat(blankline,(cols-6)-wn*18);			/* fill to edge of screen */
		n_cheat(clock_text_buff,6);
       }
	else {
		n_cur(NUMLINES+1,wn*18);
		n_draw(blankline,(cols-6)-wn*18);				/* fill to edge of screen */
		n_draw(clock_text_buff,6);
       }

        i = 176;                /* this little enhancement will display a /
                                   if any of the windows has data and those
                                   windows don't appear on the statline
                                   (for when windows > 4)
                                */
        if(wn > 3 && (t1 != t2)) {
           while(t1 != t2) {
                if(t1->sstat != 254 && t1->sstat != 176)
                        i = t1->sstat;
                if(t1->next)
                        t1 = t1->next;
           }
           n_color(current->colors[1]);
	    if(sm)
	           n_vcur(NUMLINES+1,cols-8);
	    else
	           n_cur(NUMLINES+1,cols-8);
	   STAT_BOX(i);
        }
	n_color(c);
	n_cur(rw,cl);

}
