/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tn3270.c_v   1.0   15 Jan 1990 19:25:42   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tn3270.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:25:42   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   tn3270.c  $ $Revision:   1.0  $"};
/* #define	DEBUG	1 */
#include <stdio.h>
#include <dos.h>
#include <setjmp.h>
/* #define XDEB    1 */
#ifdef	_MSC_
#include <bios.h>
#endif

#include "windat.h"
#include "newwin.h"
#include "vsdata.h"
#include "netevent.h"

#include "screen.h"
#include "oia.h"

#include "globals.h"
#include "general.h"


struct twin      *to3270,*fromconsole;
extern  int     temptek, rgdevice,capon,viewmode;
extern  int    extended;      /* defined in ncsaio.asm */
/* here are some ugly assumptions.
   we assume that input from the keyboard could send data to network or screen
   but any data from network could result in output to screen and network.

   so, we use to3270 to hold the twin of the active io channel
*/

extern	unsigned char	*TransPointer;

static char attrib;
static int oldkey;
static jmp_buf tn3270_jump;

unsigned char
key_status()
{
	struct REGPACK regs;

	regs.r_ax = (2 + extended << 8);
	intr(0x16,&regs);
	return(regs.r_ax);
}

int
TN_status()

{

        if(!oia_modified) {
#ifdef  __TURBOC__
                if((key_status() & 0x63) != oldkey)
                        return(1);
                else
		   	return(0);
#endif
#ifdef	_MSC_
		if((_bios_keybrd(2 + extended) & 0x63) != oldkey)
		   	return(1);
		else
		   	return(0);
#endif
                        return(0);
        }
        return(1);
}

SetAttrib(at)
        char at;
{

   if(!at)
        attrib = to3270->colors[0];
   else
        attrib = at;
}


int
Get_OIA(str)                    /* get OIA into the string, return its length */
        unsigned char *str;
{

static union status {
                struct fred {
                        char  rule;
                        char  space;
                        char  syswait[4];
                        char  space2;
                        char  terminalwait[2];
                        char  space3;
                        char  messedup[4];
                        char  insertmode;
                        char  shiftmode;
                        char  num;
                        char  terminator;
                 } byte_values;
                char raw_data[1];
        } *p;

       int      x;

#define CONNECTED       219

       p = (union status *) str;

       for(x=0; x < sizeof(union status); x++)
                p->raw_data[x] = 32;
       p->byte_values.terminator = 0;

       p->byte_values.rule = 'A';
       if(IsOiaSystemLocked(&OperatorInformationArea))
                strncpy(p->byte_values.syswait,"\130SYS",4);
       if(IsOiaTWait(&OperatorInformationArea))
                strncpy(p->byte_values.terminalwait,"\130\354",2);
       if(OperatorInformationArea.input_inhibited[1] & OIA_TOO_MUCH_ENTERED)
                strncpy(p->byte_values.messedup,"\130\001>",3);
       else if(OperatorInformationArea.input_inhibited[1] & OIA_NUMERIC_FIELD)
                strncpy(p->byte_values.messedup,"\130\001NUM",5);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_OP_UNAUTHORIZED)
                strncpy(p->byte_values.messedup,"\130\001\130",3);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_OP_UNAUTHORIZED_MIN)
                strncpy(p->byte_values.messedup,"\130\001\130",3);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_WRONG_PLACE)
                strncpy(p->byte_values.messedup,"\130\032\001\033",4);

       p->byte_values.insertmode = IsOiaInsert(&OperatorInformationArea) ? '^' : ' ';

#if  defined(__TURBOC__)||defined(_MSC_)
#ifdef	__TURBOC__
       oldkey = key_status() & 0x63;
#else
	oldkey = _bios_keybrd(2 + extended) & 0x63;
#endif
       if(oldkey & 0x43)
          p->byte_values.shiftmode = 24;
       if(oldkey & 0x20)
          p->byte_values.num = '#';

#endif
        oia_modified = 0;
        return(sizeof(union status));

}


NCSA_TransStart()

{
        int transmode;

        transmode = (to3270->tnmode >> 1) & 3;
#ifdef	DEBUG
	cprintf("Transstart %x\n",to3270->tnmode);
#endif
        if(!(to3270->tnmode & 128)) {    /* switch into transparent mode */
                to3270->tnmode |= 128;
             switch (transmode) {

                case 0:         /* tek mode */
		        vprint(console->vs,"\n\r Transparent Data Entering Tek mode \n\r");
			to3270->termstate = TEKTYPE;
			VGgmode(rgdevice);
			VGuncover(temptek);
			current=to3270;
			VGwrite(temptek,"\033\014",2);
                        break;

                case 1:         /* vt mode */
			to3270->termstate = VTEKTYPE;
                        break;

                case 2:         /* capfile */
				if (capon && to3270->capon) {	/* already on */
                                        /* leave it on */
				}
				else if (!capon) {				/* I want one */
					FILE *Sopencap();
					if (NULL == (to3270->capfp = Sopencap())) {
						vprint(console->vs,"\r\nCannot open capture file ");
						break;
					}
					capstat("Capture on ");
					to3270->capon = capon = 1;
				}
				else {
					vprint(console->vs,"\r\nAnother session has capture file open, cannot open two at once\r\n");
					wrest(console);
					viewmode=2;
				}
	
                        break;
                default :;      /* huh? */
             }
       }
}


NCSA_TransStop()
{
        int transmode;

        transmode = (to3270->tnmode >> 1) & 3;
#ifdef	DEBUG
	cprintf("Transtop! %x\n",to3270->tnmode);
#endif

        if((to3270->tnmode & 128)) {    /* switch out of transparent mode */
                to3270->tnmode &= 127;

             switch (transmode) {

                case 0:         /* tek mode */
#ifdef	JUNK
                                VSwrite(to3270,"\007\007",1);       /* ring bell */
                                   /* make em hit ALTR themselves */
#endif
#ifndef  NOTUSED
				if (!leavetek()) {
					if (current->capon) {
						fclose(current->capfp);
						current->capon = capon = 0;
					}
					VSreset(current->vs);		/* reset's emulator */
				}
				wrest(current);
#endif
                        break;

                case 1:         /* vt mode */
                        break;

                case 2:         /* capfile */
				if (capon && to3270->capon) {	/* already on */
#ifdef	DEBUG
	cprintf("Turning off capture file\n");
#endif
                                        /* turn it off */
					capstat("Capture off");
					fclose(to3270->capfp);		/* close the capture file */
					to3270->capon = capon = 0;

				}

                        break;

             }
       }


}

void
tn_cursor(row,col)              /* position and turn on the cursor */
        int row;
        int col;

{
        if(VSvalids(to3270->vs))
                return;
        VSIw->x = col;
        VSIw->y = row;
        VSIcurson(to3270->vs,col,row,1);

}

tn_vsreset(vs)
        int vs;

{
        if(VSvalids(vs))
                return;

        VSIw->DECAWM = 1;
}

void
ScreenWrite(position, buff, count)      /* write string into VS buffer and screen using attrib */
        int position;           /* position in Host[] */
        char *buff;
        int count;
{
        /* the 3270 stuff seems to want to write the same data over the screen even after
           its been written to the screen, so we scan through and only draw over
           new stuff that hasn't yet been written to the screen. */

        int x,y;
        char *c,*a;
        if(VSvalids(to3270->vs))
                return;
        x = position % NumberColumns;
        y = position/NumberColumns;
        a = &VSIw->attrst[y]->text[x];
        c = &VSIw->linest[y]->text[x];
        while(*buff == *c && *a == attrib && count > 0) {
               c++;
               a++;
               x++;
               buff++;
               count--;
               if(x == NumberColumns) {
                        x = 0;
			 if(++y >= NumberLines)
				break;
                        c = &VSIw->linest[y]->text[x];
                        a = &VSIw->attrst[y]->text[x];
               }
        }
        VSIw->x = x;
        VSIw->y = y;
        VSIw->attrib = attrib;
	 VSIw->maxwidth = NumberColumns-1;	/* get the sucker to wrap for me */
        if(count > 0) {
                VSIcuroff(to3270->vs);
                VSem(buff,count);
        }
        return;
#ifdef  NOTUSED
        start = c = &VSIw->linest[y]->text[x];
        a = &VSIw->attrst[y]->text[x];
        VSIw->attrib = attrib;

        while(count) {
                if(VSIw->x > VSIw->maxwidth) {
                        VSIdraw(VSIwn, x, VSIw->y,attrib,VSIw->x - x, start);
                        x = VSIw->x = 0;
                        VSIindex();
                        y = VSIw->y;
                        start = c = &VSIw->linest[y]->text[x];
                        a = &VSIw->attrst[y]->text[x];
                }

                *c = *buff++;
                *a = attrib;
                c++; 
                a++;
                VSIw->x++;
                count--;
        }
        VSIdraw(VSIwn, x, VSIw->y,attrib,VSIw->x - x, start);
#endif

}
void
EmptyTerminal()                 /* make sure all chars to terminal are output */
{

}


suspend()                       /* ^Z not available under msdos */
{

}


ExitString(string, returnCode)  /* kill the program... have to look at this */
        char    *string;
        int     returnCode;
{
	 char buff[80];

        sprintf(buff,"\033[2J\033[HExit String :Error code %d (%s)\n",returnCode, string);
	 ScreenWrite(0, buff,strlen(buff));
	 /* now force the connection closed */
	 netputuev(CONCLASS,CONCLOSE,to3270->pnum);
 	longjmp(tn3270_jump,1);
}

void
StringToTerminal(s)
        char    *s;
{
        int count;

        count = strlen(s);
        if(count)
                DataToTerminal(s,count);
}

void
command(top)
        int top;                        /* enter command mode */
{

}


int
DataToTerminal(buffer, count)
        char    *buffer;
        int     count;
{
        parsewrite(to3270,buffer,count);
        return(count);
   
}

void
quit()

{
        ExitString("From Quit",0);
}


#ifdef  JUNK
int
DataToNetwork(buffer, count, doneflag)  /* send the data to the network connection
                                           if doneflag is set, add IAC EOR to after the
                                           last byte sent. Compensate for IAC's in the field
                                           by adding an extra IAC 
                                              
                                           see tn3270.c    
                                          */

        unsigned char *buffer;
        int     count;
        int     doneflag;

{
        unsigned char xbuff[8192];        /* 8K out of the stack, wow! */
        int     x,y,z;


        z = count;
        x = y = 0;
        while(z) {
                xbuff[x++] = *buffer;
                if(*buffer++ == IAC) 
                        xbuff[x++] = IAC;
                z--;
        }
        if(doneflag) {
                xbuff[x++] = IAC;
                xbuff[x++] = EOR;
        }
        while(y < x) {                          /* this is an unfair
                                                   recursion to force data
                                                   out the network if it won't
                                                   all fit */
                z = netwrite(to3270->pnum,&xbuff[y], x-y);
                netpush(to3270->pnum);
                if(z < 1) {
                        netsleep(0);    /* try and empty the queue */
                        continue;
                }
                y += z;
        }
        return(count);      /* say we sent it all */

}

#else

int
DataToNetwork(buffer, count, doneflag)  /* send the data to the network connection
                                           if doneflag is set, add IAC EOR to after the
                                           last byte sent. Compensate for IAC's in the field
                                           by adding an extra IAC 
                                              
                                           see tn3270.c    
                                          */

        unsigned char *buffer;
        int     count;
        int     doneflag;

{
        unsigned char xbuff[2];        /* 8K out of the stack, wow! */
        int     x,z,ocount;
        unsigned char *c,iac;
        
#ifdef	MEM_DEBUG
	char ibuff[80];

	sprintf(ibuff,"DataToNetwork %d/%d to port %d at %lp\n\r",count,doneflag,to3270->pnum,to3270);
	vprint(console->vs,ibuff);
#endif
        
        ocount = count;
        while(count > 0) {
           x = 0;
           c = buffer;

#ifdef  XDEB
        printf("top loop count %d x %d z %d\n",count,x,z);
#endif
           while( (*(c) != IAC) && (x < count)) { /* skip to next iac  or end */
                c++;
                x++;
           }
           while(x > 0) {
#ifdef  XDEB
        printf("first loop count %d x %d z %d\n",count,x,z);
#endif
                z = netwrite(to3270->pnum,buffer,x);
/*                netpush(to3270->pnum); */
                if(z < 1) {
                        netsleep(0);    /* try and empty the queue */
                        continue;
                }
                x -= z;
                buffer += z;
                count -= z;
           }
           if(count) {             /* if true, there was an IAC */
                iac = IAC;
                z = 0;
                while(z < 1) {
#ifdef  XDEB
        printf("second loop (iac) count %d x %d z %d\n",count,x,z);
#endif

                        z = netwrite(to3270->pnum,&iac,1);
/*                        netpush(to3270->pnum); */
                        if(z < 1) {
                                netsleep(0);    /* try and empty the queue */
                                continue;
                        }
                }
           }
        }
        if(doneflag) {
                xbuff[0] = IAC;
                xbuff[1] = EOR;
                x = 0;
                count = 2;
                while(count > 0) {                          /* this is an unfair
                                                           recursion to force data
                                                           out the network if it won't
                                                           all fit */
#ifdef  XDEB
        printf("third loop (EOR) count %d x %d z %d\n",count,x,z);
#endif

                        z = netwrite(to3270->pnum,&xbuff[x], count);
/*                        netpush(to3270->pnum); */
                        if(z < 1) {
                                netsleep(0);    /* try and empty the queue */
                                continue;
                        }
                        count -= z;
                        x += z;
                }
        }
        return(ocount);      /* say we sent it all */

}

#endif

int
XDataFromNetwork(tw,mode )    /* calls special data from network */
        struct twin *tw;
        int     mode;

{
        int  x;
        to3270 = tw;
 
	 if(setjmp(tn3270_jump)) {
		char xbuff[32];
		while(netread(tw->pnum,xbuff, 32) > 0);	/* discard all data */
		return(FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)); /* pretend we read it all */
        }
        x = DataFromNetwork(tw->tn3270_base, FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base), mode);
	 if(mode) { 
	        while(!DoTerminalOutput());
	        if(TN_status())
       	         statline();
	 } 
        return(x);
}


int
XDataFromTerminal(tw, buff, count )
        struct twin *tw;
        char    *buff;
        int     count;
{
        int x;
#ifdef	NEWKEY
	 char *c,*i;

	 i = c = buff;
	 if(!TransPointer)
	 for(x=count; x > 0; x--) {
		switch (*i) {
		       case '\r' :
			       *c = '\300';
				break;
			case '\n' :
			        i++;
			 	count--;
				continue;
				break;
			case '\040' :
			       	*c = '\226';
			 	break;
			default:;
		}
	 	i++;
	 	c++;
	}
#endif
        to3270 = tw;
        x = DataFromTerminal(buff, count);
        while(!DoTerminalOutput());
        if(TN_status())
                statline();
        return(x);
}

void
setconnmode()
{

}

#ifdef  MAIN
main()
#else
tn3270_init()
#endif
{

   MaxNumberLines = NumberLines = 24;
   MaxNumberColumns = NumberColumns = 80;
   ScreenSize = NumberLines * NumberColumns;

   init_ctlr();
   init_keyboard();
   init_screen();
   init_system();

        
}
