#define	DEBUGG	1
/* odiint.c - Interface with Kermit's msnodi.asm (called odi.asm))
   Author: Brad Clements  bkc@omnigate.clarkson.edu
           Clarkson University
           8/25/92
   Assumes Turbo C large model
*/

#include	<stdio.h>
#include        <dos.h>
#include	"config.h"
#include        "windat.h"
#include	"newwin.h"
#include        "protocol.h"

long	n_clicks();

enum	P_Status {P_END=0,P_FREE=1,P_INUSE=2, P_ALLOCATED=4, P_READNF=8};

typedef	struct	Odi_Buffer {
	unsigned char	pflag;		/* packet flag */
	unsigned char	pnum;		/* packet number */
	int		psize;		/* size of buffer */
} OB;

#define	ODI_BUFFSIZE	(1*1600)

unsigned char	Odi_Buffer[ODI_BUFFSIZE];
/* vars used from odi.asm */
unsigned int	pktbuf_wrote;			/* points to dgroup offset
						   of last written buffer
						*/
unsigned int kpdint = 'OD'; 

unsigned char	pktwnum;
unsigned char	eth_addr[6];
unsigned int	arp_hardware;
unsigned int	MAC_len;

unsigned char	odi_etheraddress[12];
int	odi_open;
int	use_rarp;
OB	*ob_ptr;

static char iptype[]={8,0};
static char arptype[]={8,6};
static char rarptype[] = {0x80, 0x35};
static	unsigned ip_handle, arp_handle, rarp_handle;


/* glue `logic' ack from pctools.c */
extern unsigned char stat;                    /* status from last read */
extern char *bufpt,*bufend,*bufread,*buforg;
extern int bufbig,buflim;

int	far	pdinit(unsigned int, unsigned int);

int	far pdaccess(unsigned int, int tsize, unsigned int);
int	far pdclose(int handle);
int	far pkt_send(char far * packet, unsigned length);

void
Prep_Buffer()			/* prepare Odi_Buffer */
{
	OB	*ob;
	int	buffsize = ODI_BUFFSIZE - 2 * sizeof(OB);


	ob = (OB *) Odi_Buffer;
	ob_ptr = ob;
	ob->pflag = P_FREE;
	ob->pnum  = 0;
	ob->psize = buffsize;

	/* that sets the first buffer, then there's one more thats at
	   the end       */

	ob = (OB *) (((char *) ob) + buffsize + sizeof(OB));
	ob->pflag = P_END;
	ob->pnum = 1;
	ob->psize = -1 * (ODI_BUFFSIZE);

	pktbuf_wrote = FP_OFF(ob);
}

int
odetopen(s,irq,address,ioaddr)
        char    *s;             /* ethernet address */
        int     irq;            /* don't need this      */
        int     address;        /* address is packet class */
        int     ioaddr;         /* packet int, or 0 */
                                /* we try and locate the packet driver
                                   and open ARP and IP handles.
                                */
{
	char	buff[65];

	if(odi_open > 0)
	       	return(0);
	else if(odi_open < 0)
	       	return(odi_open);
	odi_open++;
	
	Prep_Buffer();

	if(!pdinit(FP_OFF(Odi_Buffer), FP_OFF(odi_etheraddress))) {
		nprintf(CONSOLE,"ODI failed to initialize\n");
		return(odi_open = -1);
       }

	if(!pdaccess(FP_OFF(arptype), sizeof(arptype), FP_OFF(&arp_handle))) {
	       	nprintf(CONSOLE,"ODI:Can't access ARP Handle\n");
		pdclose(ip_handle);
		return(odi_open = -1);
	}

	if(!pdaccess(FP_OFF(iptype), sizeof(iptype), FP_OFF(&ip_handle))) {
	       	nprintf(CONSOLE,"ODI:Can't access IP Handle\n");
		return(odi_open = -1);
	}

       netgetip(buff);		/* get stored ip num */
       if (comparen(buff,"RARP",4)) {
		if(!pdaccess(FP_OFF(rarptype), sizeof(rarptype), FP_OFF(&rarp_handle))) {
	       		nprintf(CONSOLE,"ODI:Can't access RARP Handle\n");
			pdclose(ip_handle);
			pdclose(arp_handle);
			return(odi_open = -1);
		}
	    	use_rarp = 1;
	}
	memcpy(s, eth_addr, 6);
   	return(0);
}

int
odgetaddr(s,address,ioaddr)       /* get the ethernet address */
        char    *s;             /* ethernet address */
        int     address;        /* address is packet class */
        int     ioaddr;         /* packet int, or 0 */

{
	if(!odi_open)
      		return(odetopen(s,0,address,ioaddr));
	
	memcpy(s, eth_addr, 6);
   	return(0);
}

void
odrecv()                        /* no op for this interface     */
{
	 /* set bufbig and bufread if there's something to read */
	int	loopcnt = 100;
	OB	*ob_start = ob_ptr;

	if(ob_ptr->pflag == P_INUSE) {
inuse:;
	 	bufbig = 1;
		bufread = ((unsigned char *) ob_ptr) - 2 + sizeof(OB);
#if	DEBUGG
	nprintf(CONSOLE,"get %ld ",n_clicks());
#endif
		return;
       }
	ob_ptr = (OB*)  (((char *) ob_ptr) + ob_ptr->psize + sizeof(OB));
	while(--loopcnt && ob_ptr != ob_start) {
	       	if(ob_ptr->pflag == P_INUSE)
		       	goto inuse;
		ob_ptr = (OB*)  (((char *) ob_ptr) + ob_ptr->psize + sizeof(OB));
	}
	bufbig = 0;
}

int
odetclose()                     /* throw away our handles */
{
	pdclose(ip_handle);
	pdclose(arp_handle);
	if(use_rarp)
	       	pdclose(rarp_handle);
	return(0);
}

int
odxmit(packet,length)           /* transmit a packet    */
        char    *packet;
        int     length;
{
	if(length < 64)
	       	length = 64;
	return(!pkt_send((char far *) packet, length));
}

void
odetupdate()                    /* update the pointers */

{
	if(ob_ptr->pflag == P_INUSE) {
		ob_ptr->pflag = P_FREE;
#if	DEBUGG
	nprintf(CONSOLE," OUTlen %d ",ob_ptr->psize);
	nprintf(CONSOLE,"update %ld\n",n_clicks());
#endif
	}
}
