/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/pcutil.c_v   1.0   15 Jan 1990 19:26:28   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/pcutil.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:28   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   pcutil.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*  PCUTIL.C
*   Utilities for the network library that are PC specific
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      TCP/UDP/ICMP/IP Network kernel for NCSA Telnet                      *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*/
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
/* #include <math.h> */
#include "protocol.h"
#include "windat.h"
#include "newwin.h"
#include "hostform.h"
#ifdef	_MSC_
#include <graph.h>
#endif
#ifdef  __TURBOC__
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <io.h>
#include <alloc.h>
#include <conio.h>
static struct ffblk fblock;
#else
unsigned char *malloc();
#endif
#ifdef	_MSC_
#include <dos.h>
#include <ctype.h>
static struct find_t fblock;
#endif
#include "mem.h"

#ifdef  VJC

#define	_SIZE_T 1

#include "sys/types.h"
#include "mbuf.h"
#ifdef	SE
#undef SE
#endif
/* #include "splay.h" */


/* extern SE      *sc_se; */
extern u_char  *sc_tbuf;
extern int     enable_vjc;
u_long  vj_packets_in, vj_packets_out;
u_long  splay_packets_in, splay_packets_out;
extern int slip_mode;
#endif

#ifdef	_MSC_
struct	ftime	{
	unsigned	ft_tsec	 : 5;	/* Two second interval */
	unsigned	ft_min	 : 6;	/* Minutes */
	unsigned	ft_hour	 : 5;	/* Hours */
	unsigned	ft_day	 : 5;	/* Days */
	unsigned	ft_month : 4;	/* Months */
	unsigned	ft_year	 : 7;	/* Year */
};

#endif
extern	struct config Scon;

/**********************************************************************/
/*
*   Find directory name -- return a code that indicates whether the
*   directory exists or not.
*   0 = dir name ok
*   -1 = error
*   > 0 = dos error code, no dir by this name
*
*   Accept certain unix conventions, like '/' for separator
*
*   Also, append a '\' to the name before returning
* 
*  Note:  There must be enough room in the string to append the '\'
*/

struct dosdta {
	char junk[21];
	char att;
	int time,date;
	long int size;
	char name[13];
};

extern struct dosdta *dtaptr;

direxist(dirname)
	char dirname[];
	{
	int i,ret;
	char *p;

	if (!strcmp(dirname,".") || !dirname[0]) {
		dirname[0] = '\0';
		return(0);
	}

	if (!strcmp(dirname,"\\"))
		return(0);

	p = dirname;
	while (*p) {
		switch (*p) {
			case '*':
			case '?':
				return(-1);
			case '/':
				*p = '\\';
			default:
				break;
		}
		p++;
	}

/*
*  n_findfirst  will return normal files AND directories
*  must check attribute to see if it is really a directory
*/
	ret = n_findfirst(dirname,0x10);		/* find name */

	if (ret)
		return(ret);

	if (!(dtaptr->att & 0x10))
		return(-2);							/* is a normal file */

	i = strlen(dirname);
	dirname[i] = '\\';						/* extend with '\' */
	dirname[++i] = '\0';
	
	return(0);
}


#ifdef  __TURBOC__
char
*ffparse(struct ffblk *f, int mode)               /* parse out this sucker */
                        /* if mode set then place a . in front for dirs */
#else
char
*ffparse(struct find_t *f, int mode)
#define	ff_ftime	wr_time
#define	ff_attrib	attrib
#define	ff_name		name
#define	ff_fsize	size
#define	FA_DIREC	_A_SUBDIR
#endif
{
        static char buff[80];
        int     x;
        struct ftime *ft;

        ft = (struct ftime *) &f->ff_ftime;
        sprintf(buff,"%-12.12s     ",f->ff_name);
        for(x=0; x < 14; x++)
                buff[x] = isupper(buff[x]) ? tolower(buff[x]) : buff[x];

        if(mode && f->ff_attrib & FA_DIREC)
                buff[0] = '.';

        sprintf(&buff[15], f->ff_attrib & FA_DIREC ? 
                           "%s    <DIR> %02d-%02d-%02d  %02d:%02d" :                           
                           "%9ld %02d-%02d-%02d  %02d:%02d",
                           f->ff_attrib & FA_DIREC ? "" : (char *) f->ff_fsize,
                           ft->ft_month, ft->ft_day, ft->ft_year+80,
                           ft->ft_hour,ft->ft_min);
        return(buff);
}

char
*fixslash(str)                  /* change \ to / */
        char *str;
{
        char *c;

        c = str;

        while(*c) {
                if(*c == '\\')
                        *c = '/';
		 if(*c == ' ')	{
			*c=0;
		 	return(str);
		 }
                c++;
        }

        return(str);
}

/**********************************************************************/
/* firstname
*  find the first name in the given directory which matches the wildcard
*  specification
*
*  must malloc enough space for the path plus a full filename
*
*  expand '*' (unix) to '*.*' (dos)
*/
static char *savepath;
static int rootlen;

char *firstname(path,mode)
	char path[];
        int     mode;           /* if set, place a . in the front of the name for dirs */
	{
	int i,len;
	char *p,*q;

	if (!*path)
		return(NULL);

	len = strlen(path);
#if  	defined(__TURBOC__) || defined(_MSC_)
        savepath = mem_malloc(len + 80);
#else
	savepath = mem_malloc(len+16);
#endif
	i = 0;
	rootlen = 0;
	q = savepath;
	p = path;
	while (*q = *p) {				/* basic string copy with extras */
		if (*p == '\\')
			rootlen = i+1;			/* rootlen = position of last \ */
		p++;
		q++;
		i++;
	}

	if (savepath[len-1] == '*' && rootlen == len-1) {
		savepath[len++] = '.';
		savepath[len++] = '*';
		savepath[len++] = '\0';
	}
#ifdef  __TURBOC__
        if( findfirst(savepath, &fblock, mode ? 0 : FA_DIREC)) /* let em see directories */
                return(NULL);
        strcpy(&savepath[rootlen], ffparse(&fblock,0 /* mode */));
                
#else
#ifdef	_MSC_
	if(_dos_findfirst(savepath, mode ? 0 : _A_SUBDIR, &fblock))
	       	return(NULL);
	strcpy(&savepath[rootlen], ffparse(&fblock, 0));
#else
	if (n_findfirst(savepath,0))
		return(NULL);
/*
*  copy file name, translate to lower case 
*/
	q = &savepath[rootlen];
	p = dtaptr->name;
	while (*p) {
		if (*p >= 'A' && *p <= 'Z')
			*q++ = *p++ + 32;
		else
			*q++ = *p++;
	}
	*q = '\0';
#endif
#endif
	return(fixslash(savepath));
}

/**********************************************************************/
/* nextname
*  modify the path spec to contain the next file name in the
*  sequence as given by DOS
*
*  if at the end of the sequence, return NULL
*/
char *nextname(mode)
        int     mode;           /* if set, place a . before dirs for NLST 
                                   only effects turbo c */
	{
	char *p,*q;

	if (NULL == savepath)
		return(NULL);
#ifdef  __TURBOC__
        if(findnext(&fblock)) {
                mem_free(savepath);
                savepath = NULL;
        }
        else
                strcpy(&savepath[rootlen], ffparse(&fblock, 0 /* mode */));
#else
#ifdef	_MSC_
      	if(_dos_findnext(&fblock)) {
		mem_free(savepath);
		savepath = NULL;
	}
	else
	       	strcpy(&savepath[rootlen], ffparse(&fblock, 0));
#else
	if (n_findnext()) {
		mem_free(savepath);
		savepath = NULL;
		return(NULL);
	}

/*
*  copy file name, translate to lower case 
*/
	q = &savepath[rootlen];
	p = dtaptr->name;
	while (*p) {
		if (*p >= 'A' && *p <= 'Z')
			*q++ = *p++ + 32;
		else
			*q++ = *p++;
	}
	*q = '\0';

#endif
#endif
	return(fixslash(savepath));
}

/**********************************************************************/
/*  dopwd
*   get the current directory, including disk drive letter
*/
dopwd(p,l)
	char *p;
	int l;
	{
#if	!defined(__TURBOC__) && !defined(_MSC_)
	*p++ = 'A'+getdsk();		/* current disk drive */
	*p++ = ':';
	*p++ = '\\';
#endif
	getcwd(p,l-2);				/* get dir */

}

/**********************************************************************/
/*  chgdir
*  change directory, including disk drive letter
*/

chgdir(d)
	char *d;
	{

	while (*d && *d < 33)
		d++;

	if (!(*d))
		return(-1);

	*d = toupper(*d);

	if (*(d+1) == ':') {
#ifdef  __TURBOC__
                setdisk((*d)-'A');
#else
#ifdef	_MSC_
	{
		unsigned drives;

		_dos_setdrive((*d) - 'A' + 1,&drives);
	}
#else
		chgdsk((*d)-'A');
#endif
#endif
		d += 2;
	}

	if (!(*d))
		return(0);				/* just changed disk */

	return(chdir(d));

}


#ifdef  __TURBOC__


#ifdef  VJC
vj_status()
{
        int     states;
        long  	 eff;
/*        SCD     *scd; */
	char	x[4];
        nprintf(SCREEN,"VJ Compression Status\n");

        nprintf(SCREEN,"Packets in  %ld  Packets out %ld\n",vj_packets_in, vj_packets_out);
}

#endif

status_setup()                  /* setup for status */
{
   unsigned long *x;
   unsigned int count, limit;


   limit = (_SP - 32)/sizeof(long) - 256;

   x = MK_FP(_SS,256);

   for(count=0; count < limit; count++)
                *(x++) = 0xFFFFFFFF;

}


program_status()                /* display status about this machine */
{
        extern unsigned _stklen, _ovrbuffer, _heapbase,_heaptop;
#ifdef	OVERLAY
	extern unsigned _ovrsize;
#else
	unsigned _ovrsize = 0;
#endif
        unsigned long *x;
        int count,i;
        long perc,mem,z;
        unsigned k;
        char buff[20],*c;

        k = _SS;
        x = MK_FP(k,256);
        count = 256;
        while(*(x++) == 0xFFFFFFFF)
                count++;

	i = n_color(7); 
        count *= 4;

	n_clear();
	n_cur(0,0);

   nprintf(SCREEN,"Program Status\n\n");
   k = _stklen - count;
   perc  = (k * 100L)/_stklen;
   nprintf(SCREEN,"Resident Code and Stubs    = %6ld  -- DS %04x - PSP %04x\n",
	  mem = (long) (_DS - _psp) * 16L,_DS, _psp);
   nprintf(SCREEN,"Dgroup Segment Size        = %6ld  -- SS %04x - DS  %04x\n",
		 z = (long) (_SS -_DS) * 16L,_SS, _DS);
   mem += z;
   nprintf(SCREEN,"Stack length               = %6u  -- Max Used %u (%d%%)\n", _stklen,k,perc );
   mem += _stklen;
/*   nprintf(SCREEN,"Current SP %04x  %u Bytes  %d%%\n",_SP,_SP, 100 * (_stklen - _SP)/_stklen); */
   nprintf(SCREEN,"Overlay Buffer Size        = %6u  -- Requested Size %u\n",_ovrsize,_ovrbuffer * 16);
   mem += _ovrsize;
   c = mem_malloc(1);
   k = _SS + (_stklen/16) + (_ovrsize/16);
   nprintf(SCREEN,"Dynamic Memory Used        = %6ld\n", z = (long) (FP_SEG(c) - k) * 16);
   nprintf(SCREEN,"%*.*s-----------\n",28,28," ");
   mem += z;
   nprintf(SCREEN,"Total Memory Used          = %6ld bytes\n\n",mem);
   mem_free(c);
   nprintf(SCREEN,"Remaining Free Memory      = %6ld bytes\n",coreleft());
#ifdef  VJC
   if(slip_mode)
	   vj_status();
#endif
#ifdef	MEM_DEBUG
	nprintf(SCREEN,"mem_check...");
	mem_check();
	nprintf(SCREEN,"ok\n");
#endif
   n_color(i);

}

#endif

LoadInit(struct twin *tw)	/* initialize load display */
{
	char	buff[80];

	sprintf(buff,"%c[2J%c[H             KBytes Received\n\r             KB/Second",27,27);
	VSwrite(tw->vs,buff,strlen(buff));
	tw->bytes = 0L;
}

LoadWrite(struct twin *tw, char *dat, int len)
{
 	char	buff[80];
	unsigned long	throughput;
	unsigned long	diff;
	long	now;
static	long	lastupdate;

	if(!tw->bytes)
	   	tw->starttime = time(NULL);
	tw->bytes += len;
	now = time(NULL);
	if(lastupdate != now)  {
	   	diff = now - tw->starttime;
		lastupdate = now;
		if(diff)   {
			throughput = (tw->bytes)/1024;
			sprintf(buff,"%c[H% 3ld.%2d \n\r% 3ld.%2d ",27,throughput,
			       	(unsigned int) (tw->bytes % 1024),
				 (unsigned long) throughput/diff,
				  (unsigned int) (throughput % diff));
			VSwrite(tw->vs,buff,strlen(buff));
		}
	}

}


long
freediskspace()		/* returns free space on current drive */
{

#ifdef	_MSC_
	 struct diskfree_t  t;
 	long count;

	if(_dos_getdiskfree(0, &t))
	       	return(-1);
	count = (long) t.avail_clusters * (long) t.sectors_per_cluster * (long) t.bytes_per_sector;
	return(count);
#endif
#ifdef	__TURBOC__
      struct dfree t;
	long count;

	getdfree(0, &t);

	count = (long) t.df_avail * (long) t.df_bsec * (long) t.df_sclus;
	return(count);
#endif
	return(-1);
}
#ifdef	TRASH
int
cprintf(char *format,...)
{
	va_list list;
	char	tbuff[256],xbuff[256],*c,*o;
	int	len;

	c = xbuff;
	o = format;
	while(*o) {
	       if(*o == '\n')
		      	*c++ = '\r';
		*c++ = *o++;
	}
	*c++ = 0;
	va_start(list,format);
	vsprintf(tbuff,xbuff,list);
	va_end(list);
	vprint(console->vs,tbuff);
	return(0);
}

#endif
