/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rg9.c_v   1.0   15 Jan 1990 20:01:56   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rg9.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:01:56   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rg9.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*

rg9.c by Aaron Contorer for NCSA

graphics routines for drawing on Number Nine card
Input coordinate space = 0..4095 by 0..4095
MUST BE COMPILED WITH LARGE MEMORY MODEL!

RGH = routines callable from outside
NO9 = routines for internal use only

*/

#include <stdio.h>
	/* used for debugging only */
#include <dos.h>
	/* used for NO9 init call */

#define TRUE 1
#define FALSE 0
#define INXMAX 4096
#define INYMAX 4096
#define MAGNIFY 1000
#define SCRNXHI 511
#define SCRNYHI 479
#define MAXWIN 32
	/* max. number of windows */

extern char *malloc();

static int NO9active;		/* number of currently NO9active window */
static char *NO9ram;
static int *NO9bank; /* bank control registers */
static unsigned char power2[8] = {1,2,4,8,16,32,64,128};
static char *NO9name = "Number Nine, 512 x 480";
static int NO9xmax=512;
static int NO9ymax=480;

/* Current status of an NO9 window */
struct NO9WIN {
	char inuse; /* true if window in use */
	int pencolor, rotation, size;
	int winbot,winleft,wintall,winwide;
		/* position of the window in virtual space */
	};


static struct NO9WIN NO9win[MAXWIN];


NO9setup()
/* prepare variables for use in other functions */
{
	NO9ram=(char *)0xA0000;
	NO9bank = (int *)0xC0705;
}


static clrbuf(bank)
unsigned int bank;
{
	*NO9bank = bank;
	memset(NO9ram,0,0xFFFF);
	NO9ram[0xFFFF]=0;
}


RG9gmode()
/* go into NO9 graphics mode -- not yet implemented */
{
	clrbuf(0x0000);
	clrbuf(0x00ff);
	clrbuf(0xff00);
	clrbuf(0xffff);
}


RG9tmode()
/* go into NO9 text mode -- not supported */
{ }


RG9drawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
/* draw a line from (x0,y0) to (x1,y1) */
/* uses Bresenham's Line Algorithm */
{
	int x,y,dx,dy,d,temp,
	dx2,dy2,		/* 2dx and 2dy */
	direction;		/* +1 or -1, used for slope */
	char transpose;	/* true if switching x and y for vertical-ish line */

	if (w != NO9active) return;

	x0 = (int) ((long) x0 * NO9xmax / INXMAX);
	y0 = NO9ymax - 1 - (int) ((long) y0 * NO9ymax / INYMAX);
	x1 = (int) ((long) x1 * NO9xmax / INXMAX);
	y1 = NO9ymax - 1 - (int) ((long) y1 * NO9ymax / INYMAX);

	if (abs(y1-y0) > abs(x1-x0)) {
		/* transpose vertical-ish to horizontal-ish */
		temp=x1; x1=y1; y1=temp;
		temp=x0; x0=y0; y0=temp;
		transpose=TRUE;
	} else transpose=FALSE;

	/* make sure line is left to right */
	if (x1 < x0) {
		temp=x1; x1=x0; x0=temp; 
		temp=y1; y1=y0; y0=temp;
	}

	/* SPECIAL CASE: 1 POINT */
	if (x1==x0 && y1==y0) { 
		NO9point(x1,y1);
		return(0);
	}        


	/* ANY LINE > 1 POINT */

	x=x0;
	y=y0;
	dx=x1-x0;
	if (y1 >= y0) {
		dy=y1-y0;
		direction=1;
	} else {
		dy=y0-y1;
		direction= -1;
	}
	dx2=dx<<1;
	dy2=dy<<1;

	d = (dy<<1) - dx;

	if (transpose) {	
		/* CASE OF VERTICALISH (TRANSPOSED) LINES */
		while (x <= x1) {
			if (y>=0 && y<NO9xmax && x>=0 && x<NO9ymax)
				NO9point(y,x);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		} 

	} else {
		/* CASE OF HORIZONTALISH LINES */
		while (x <= x1) {
			if (x>=0 && x<NO9xmax && y>=0 && y<NO9ymax)
				NO9point(x,y);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}
	} /* end horizontalish */

} /* end NO9rasline() */


RG9clrscr(w)
int w;
/* 
	Clear the screen.
*/
{
	if (w == NO9active) {
		NO9setup();
		RG9gmode();
	}
}


int RG9newwin()
/* 
	Set up a new window; return its number.
	Returns -1 if cannot create window.
*/
{
	int w=0;

	while (w<MAXWIN && NO9win[w].inuse) w++;
	if (w==MAXWIN) return(-1); /* no windows available */
	NO9win[w].pencolor = 7;
	NO9win[w].winbot = 0;
	NO9win[w].wintall = 3120;
	NO9win[w].winleft = 0;
	NO9win[w].winwide = 4096;
	NO9win[w].inuse = TRUE;
	return(w);
}


RG9close(w)
int w;
{
	if (NO9active==w) {
		RG9clrscr();
		NO9active=-1;
	}
	NO9win[w].inuse = FALSE;
}


NO9point(x,y)
int x,y;
/*
	set point at real pixel x,y
*/
{
	unsigned int bank,loc;

	y += 16; /* map 480 lines onto 512 lines */
	if (y & 256) bank = 0xff00;
	else bank = 0;
	if (y & 128) bank |= 0x00ff;
	*NO9bank = bank;		
	loc = ((y & 0x7f) << 9) + x;
	NO9ram[loc] = 255; /* only drawing in color 255 */
}


RG9point(w,x,y)
int w,x,y;
/* set pixel at location (x,y) -- no range checking performed */
{
	int x2,y2; /* on-screen coordinates */

	if (w == NO9active) {
		x2=(int) ((long)x*NO9xmax/INXMAX);
		y2=SCRNYHI-(int) ((long)y*NO9ymax/INYMAX);
		NO9point(x2,y2);
	}
}  


RG9pagedone(w)
int w;
/*
	Do whatever has to be done when the drawing is all done.
	(For printers, that means eject page.)
*/
{
	/* do nothing for NO9 */
}


RG9dataline(w,data,count)
int w,count;
char *data;
/*
	Copy 'count' bytes of data to screen starting at current
	cursor location.
*/
{
	/* Function not supported yet. */
}


RG9pencolor(w,color)
int w,color;
/*
	Change pen color to the specified color.
*/
{
	/* Function not supported yet. */
}


RG9charmode(w,rotation,size)
/*
	Set description of future device-supported graphtext.
	Rotation=quadrant.
*/
{
	/* No rotatable device-supported graphtext is available on NO9. */
}

/* Not yet supported: */
RG9showcur() {}
RG9lockcur() {}
RG9hidecur() {}

#ifndef	_MSC_
static int abs(x)
int x;
{
  if (x>=0) return(x);
  else return(-x);
}
#endif

RG9bell(w)
int w;
/* Ring bell in window w */
{
	if (w == NO9active) putchar(7);
}


char *RG9devname()
/* return name of device that this RG supports */
{
	return(NO9name);
}


RG9init()
/* initialize all RG9 variables */
{
	int i;
	NO9setup();
	for (i=0; i<MAXWIN; i++) {
		NO9win[i].inuse = FALSE;
	}
	NO9active = -1;
}


RG9uncover(w)
int w;
/*
	Make this window visible, hiding all others.
	Caller should follow this with clrscr and redraw to show the current
	contents of the window.
*/
{
	NO9active = w;
}

RG9info(w,a,b,c,d,v) {}
