/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rgc.c_v   1.0   15 Jan 1990 20:02:10   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rgc.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:02:10   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rgc.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*
rgc.c by Aaron Contorer for NCSA

graphics routines for drawing on CGA
Input coordinate space = 0..4095 by 0..4095
MUST BE COMPILED WITH LARGC MEMORY MODEL!

*/

/* #define XDEBUG  1 */

#include <stdio.h>
	/* used for debugging only */
#include <dos.h>
	/* used for CGA init call */
#ifdef  XDEBUG
#include "../windat.h"
#endif

#define TRUE 1
#define FALSE 0
#define INXMAX 4096
#define INYMAX 4096
#define MAGNIFY 1000
#define SCRNXHI 639
#define SCRNYHI 199
#define MAXRW 32
	/* max. number of real windows */

extern char *malloc();
#ifdef	_MSC_
#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

static int CGAactive;		/* number of currently CGAactive window */
#ifdef  __TURBOC__
static  char far *CGAvidram;
#else
static char *CGAvidram;
#endif
static char CGApbit[SCRNXHI+1]; /* #### BUGFIX, used to not have +1, which allowed
                                   ####         clrscr routine to overwrite CGAactive
                                */

static unsigned char power2[8] = {1,2,4,8,16,32,64,128};
static char *CGAname = "Color Graphics Adaptor, 640 x 200";
static int CGAxmax=640;
static int CGAymax=200;
static int CGAbytes=80;	/* number of bytes per line */

/* Current status of an CGA window */
struct CGAWIN {
	char inuse; /* true if window in use */
	int pencolor, rotation, size;
	int winbot,winleft,wintall,winwide;
		/* position of the window in virtual space */
	};


static struct CGAWIN CGAwins[MAXRW];


CGAsetup()
/* prepare variables for use in other functions */
{
	int x;
	CGApbit[0]=128; CGApbit[1]=64; CGApbit[2]=32; CGApbit[3]=16;
	CGApbit[4]=8;   CGApbit[5]=4;  CGApbit[6]=2;  CGApbit[7]=1;
	for (x=8; x<=SCRNXHI; x++) CGApbit[x]=CGApbit[x & 7];
#if  	defined(__TURBOC__)||defined(_MSC_)
        CGAvidram = (char *) MK_FP(0xb800,0);
#else
	CGAvidram=(char *)0xB8000;
#endif
}


RGCgmode()
/* go into CGA graphics mode */
{
	union REGS *in, *out;
	in = (union REGS *)malloc(sizeof(union REGS));
	out = (union REGS *)malloc(sizeof(union REGS));
	in->x.ax = 6; /* 640x200 BW */
	int86(0x10,in,out);
	free(in);
	free(out);

}

RGCtmode()
/* go into CGA 80x25 color text mode */
{
	union REGS *in, *out;
	in = (union REGS *)malloc(sizeof(union REGS));
	out = (union REGS *)malloc(sizeof(union REGS));
	in->x.ax = 3; /* 80x25 color text */
	int86(0x10,in,out);
	free(in);
	free(out);
	CGAactive = -1;
}


RGCdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
/* draw a line from (x0,y0) to (x1,y1) */
/* uses Bresenham's Line Algorithm */
{
	int x,y,dx,dy,d,temp,
	dx2,dy2,		/* 2dx and 2dy */
	direction;		/* +1 or -1, used for slope */
	char transpose;	/* true if switching x and y for vertical-ish line */

	if (w != CGAactive) return; 

	x0 = (int) ((long) x0 * CGAxmax / INXMAX);
	y0 = CGAymax - 1 - (int) ((long) y0 * CGAymax / INYMAX);
	x1 = (int) ((long) x1 * CGAxmax / INXMAX);
	y1 = CGAymax - 1 - (int) ((long) y1 * CGAymax / INYMAX);

	if (abs(y1-y0) > abs(x1-x0)) {
		/* transpose vertical-ish to horizontal-ish */
		temp=x1; x1=y1; y1=temp;
		temp=x0; x0=y0; y0=temp;
		transpose=TRUE;
	} else transpose=FALSE;

	/* make sure line is left to right */
	if (x1 < x0) {
		temp=x1; x1=x0; x0=temp; 
		temp=y1; y1=y0; y0=temp;
	}

	/* SPECIAL CASE: 1 POINT */
	if (x1==x0 && y1==y0) { 
		CGAvidram[(y1&1)*8192 + (y1>>1) *80+(x1>>3)] |= CGApbit[x1];
		return(0);
	}        


	/* ANY LINE > 1 POINT */

	x=x0;
	y=y0;
	dx=x1-x0;
	if (y1 >= y0) {
		dy=y1-y0;
		direction=1;
	} else {
		dy=y0-y1;
		direction= -1;
	}
	dx2=dx<<1;
	dy2=dy<<1;

	d = (dy<<1) - dx;

	if (transpose) {	
		/* CASE OF VERTICALISH (TRANSPOSED) LINES */
		while (x <= x1) {
			if (y>=0 && y<CGAxmax && x>=0 && x<CGAymax)
				CGAvidram[(x&1)*8192 + (x>>1) *80+(y>>3)] |= CGApbit[y];
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		} 

	} else {
		/* CASE OF HORIZONTALISH LINES */
		while (x <= x1) {
			if (x>=0 && x<CGAxmax && y>=0 && y<CGAymax)
				CGAvidram[(y&1)*8192 + (y>>1) *80+(x>>3)] |= CGApbit[x];
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}
	} /* end horizontalish */

} /* end CGArasline() */


RGCclrscr(w)
int w;
/* 
	Clear the screen.
*/
{
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC clrscr1, active %d want %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	if (w == CGAactive) {
		CGAsetup();
		RGCgmode();
	}
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC clearscr2, active %d want %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

}


int RGCnewwin()
/* 
	Set up a new window; return its number.
	Returns -1 if cannot create window.
*/
{
	int w=0;
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC new1, active %d starting at %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	while ( (w < MAXRW) && CGAwins[w].inuse) w++;
	if (w==MAXRW) return(-1); /* no windows available */
	CGAwins[w].pencolor = 7;
	CGAwins[w].winbot = 0;
	CGAwins[w].wintall = 3120;
	CGAwins[w].winleft = 0;
	CGAwins[w].winwide = 4096;
	CGAwins[w].inuse = TRUE;
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC new2, active %d returning %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	return(w);
}


RGCclose(w)
int w;
{
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC close, active %d want %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	if (CGAactive==w) {
		RGCclrscr();
		CGAactive=-1;
	}
	CGAwins[w].inuse = FALSE;
}


RGCpoint(w,x,y)
int w,x,y;
/* set pixel at location (x,y) -- no range checking performed */
{
	int x2,y2; /* on-screen coordinates */
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC point, active %d want %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	if (w == CGAactive) {
		x2=(int) ((long)x*CGAxmax/INXMAX);
		y2=SCRNYHI-(int) ((long)y*CGAymax/INYMAX);
		CGAvidram[y2*80+(x2>>3)] |= CGApbit[x2];
	}
}  


RGCpagedone(w)
int w;
/*
	Do whatever has to be done when the drawing is all done.
	(For printers, that means eject page.)
*/
{
	/* do nothing for CGA */
}


RGCdataline(w,data,count)
int w,count;
char *data;
/*
	Copy 'count' bytes of data to screen starting at current
	cursor location.
*/
{
	/* Function not supported yet. */
}


RGCpencolor(w,color)
int w,color;
/*
	Change pen color to the specified color.
*/
{
	/* Function not supported. */
}


RGCcharmode(w,rotation,size)
/*
	Set description of future device-supported graphtext.
	Rotation=quadrant.
*/
{
	/* No rotatable device-supported graphtext is available on CGA. */
}

/* Not yet supported: */
RGCshowcur() {}
RGClockcur() {}
RGChidecur() {}

#ifndef	_MSC_
static int abs(x)
int x;
{
  if (x>=0) return(x);
  else return(-x);
}
#endif

RGCbell(w)
int w;
/* Ring bell in window w */
{
	if (w == CGAactive) putchar(7);
}


char *RGCdevname()
/* return name of device that this RG supports */
{
	return(CGAname);
}


RGCinit()
/* initialize all RGC variables */
{
	int i;
	CGAsetup();
	for (i=0; i<MAXRW; i++) {
		CGAwins[i].inuse = FALSE;
	}
	CGAactive = -1;
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC init, active %d \n\r", CGAactive);
        vprint(console->vs,buff);
        }
#endif

}


RGCuncover(w)
        int w;
/*
	Make this window visible, hiding all others.
	Caller should follow this with clrscr and redraw to show the current
	contents of the window.
*/
{
#ifdef  XDEBUG
        {
                char buff[80];
        sprintf(buff,"RGC uncover, active %d want %d\n\r", CGAactive, w);
        vprint(console->vs,buff);
        }
#endif

	CGAactive = w;

}

RGCinfo(w,a,b,c,d,v) {}
