// =====================================================================
// ghba.c - Reverse host name lookup
//
// (C) 1993, 1994 by Michael Ringe, Institut fuer Theoretische Physik,
// RWTH Aachen, Aachen, Germany (michael@thphys.physik.rwth-aachen.de)
//
// This program is free software; see the file COPYING for details.
// =====================================================================

#define INTEL16(i) (((short)(i) >> 8) | ((short)(i) << 8))

#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "../include/tcp.h"
#include "talk.h"

extern longword def_nameservers[ MAX_NAMESERVERS ];
extern int _last_nameserver;
extern word _domaintimeout;
static longword timeoutwhen;


typedef struct {
    word	ident,		/* unique identifier */
		flags,
		qdcount,	/* question section, # of entries */
		ancount,	/* answers, how many */
		nscount,	/* count of name server RRs */
		arcount;	/* number of "additional" records */
} dhdr_t;

/*
 *  flag masks for the flags field of the DOMAIN header
 */
#define DQR		0x8000	/* query = 0, response = 1 */
#define DOPCODE		0x7800	/* opcode, see below */
#define DAA		0x0400	/* Authoritative answer */
#define DTC		0x0200	/* Truncation, response was cut off at 512 */
#define DRD		0x0100	/* Recursion desired */
#define DRA		0x0080	/* Recursion available */
#define DRCODE		0x000F	/* response code, see below */

/* opcode possible values: */
#define DOPQUERY	0	/* a standard query */
#define DOPIQ		1	/* an inverse query */
#define DOPCQM		2	/* a completion query, multiple reply */
#define DOPCQU		3     	/* a completion query, single reply */
/* the rest reserved for future */

/* legal response codes: */
#define DROK	0		/* okay response */
#define DRFORM	1		/* format error */
#define DRFAIL	2		/* their problem, server failed */
#define DRNAME	3		/* name error, we know name doesn't exist */
#define DRNOPE	4		/* no can do request */
#define DRNOWAY	5		/* name server refusing to do request */

#define DTYPEA		1	/* host address resource record (RR) */
#define DTYPEPTR	12	/* a domain name ptr */

#define DIN		1	/* ARPA internet class */
#define DWILD		255	/* wildcard for several of the classifications */


typedef struct {
    word   	rtype,		/* resource record type = DTYPEA */
		rclass;		/* RR class = DIN */
    longword	ttl;		/* time-to-live, changed to 32 bits */
    word	rdlength;	/* length of next field */
    byte 	rdata[512];	/* data field */
} rr_t;

typedef struct {
    dhdr_t h;
    char x[50];
} question_t;

typedef struct {
    dhdr_t h;
    char x[500];
} answer_t;



static void qinit(question_t *q, longword ip)

{
    char *c;
    char tmp[10];
    unsigned char i;

    q->h.ident = 0x5271;
    q->h.flags = INTEL16(0x0100);	// recursion desired
    q->h.qdcount = INTEL16(1);
    q->h.ancount = 0;
    q->h.nscount = 0;
    q->h.arcount = 0;

    c = q->x;
    for (i = 0; i < 4; ++i)
    {
	unsigned char x = (unsigned char) ip;
	ip >>= 8;
    	*c = (x < 10) ? 1 : (x < 100) ? 2 : 3;
    	itoa(x,c+1,10);
    	c += *c + 1;
    }
    strcpy(c,"\007in-addr\004arpa");
    c += 14;
    *(short *) c = INTEL16(DTYPEPTR);
    c += 2;
    *(short *) c = INTEL16(DIN);
}



//----------------------------------------------------------------------
// getresult() - read answer and extract host name
//----------------------------------------------------------------------

static int getresult(udp_Socket *s, char *name)
{
    static answer_t a;
    char *c;
    rr_t *rr;

    sock_fastread(s,(byte *) &a,sizeof(a));
    if (a.h.qdcount != INTEL16(1) || a.h.ancount == 0) return 1;

    // Skip question
    c = a.x;
    while (*c != 0) ++c;
    c += 5;

    // Skip name
    while (*c != 0)
    {
	if ((*c & 0xC0) == 0xC0) { c += 2; break; }
	else ++c;
    }
    rr = (rr_t *) (c);
    if (rr->rtype != INTEL16(DTYPEPTR)) return 1;
    c = rr->rdata;
    while (*c != 0)
    {
	if ((*c & 0xC0) == 0xC0)
	    c = a.x + (*(int *)c & 0x3FFF);
	strncpy(name,c+1,*c);
	name += *c;
	c += *c + 1;
	if (*c != 0) *name++ = '.';
    }
    *name = 0;
    return 0;
}


//----------------------------------------------------------------------
// ghba() - returns 0 on success, 1 on eror or timeout
//----------------------------------------------------------------------

static int ghba(question_t *q, char *name, longword nameserver)

{
    int i;
    int timeout = 1;
    udp_Socket dom_sock;

    if (!nameserver) return 1;	/* no nameserver, give up now */
    udp_open(&dom_sock,997,nameserver,53,NULL);
    for ( i = 2; timeout && i < 17; i *= 2)
    {
    	sock_write(&dom_sock,(char*)q,sizeof(question_t));
    	sock_flush(&dom_sock);
        ip_timer_init(&dom_sock,i);
        do {
            kbhit();
            tcp_tick(&dom_sock);
            if (ip_timer_expired(&dom_sock )) break;
            if ( watcbroke ) {
                break;
            }
            if (chk_timeout( timeoutwhen ))
                break;
            if ( sock_dataready(&dom_sock )) timeout = 0;
        } while (timeout);
    }
    i = timeout ?  1 : getresult(&dom_sock,name);
    sock_close(&dom_sock);
    return i;
}


// ---------------------------------------------------------------------
// gethostbyaddr()
// ---------------------------------------------------------------------

int gethostbyaddr(longword ip,char *result)
{
    static question_t q;
    word oldhndlcbrk;
    int i;

    if (!_domaintimeout) _domaintimeout = sock_delay << 2;
    timeoutwhen = set_timeout(_domaintimeout);
    oldhndlcbrk = wathndlcbrk;
    wathndlcbrk = 1;        /* enable special interrupt mode */
    watcbroke = 0;
    *result = 0;
    qinit(&q,ip);
    for ( i = 0; i < _last_nameserver ; ++i )
    {
	if (ghba(&q,result,def_nameservers[i]) == 0)
	    break;
    }
    watcbroke = 0;          /* always clean up */
    wathndlcbrk = oldhndlcbrk;
    return 0;
}

