/*
 * blather - a program to generate vat control messages
 *
 * Usage: blather ["ID string"] [ttl] [multicast address] [port]
 *
 *   Lister is a primarly useless program that I hacked together to
 * prove that my multicast code was sending correctly. It will send out
 * a ID string to the specified multicast address/port at 5 second 
 * intervals. By default it will send a silly ID out on MBone Audio with
 * a ttl of 32. Each time an update is sent out, a message will be 
 * displayed. To quit, hit any key (be patient, it can take up to 5 secs)
 *
 * Jim Martin
 * jim@noc.rutgers.edu
 * 11/10/93
 */


#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <tcp.h>
#include <mem.h>
#include <dos.h>

struct CtrlMsg {
  unsigned char version:2;
  unsigned char flags:6;
  unsigned char type;
  unsigned short confid;
  char data;
};



void main(int argc, char **argv)
{
    udp_Socket telsock;
    static udp_Socket *s;
    longword host;
    int ttl;
    word port;
    char id[512];
    struct CtrlMsg *header;

	/* override defaults with command line if available */
        if (argc>1)
	        strcpy(id,argv[1]);
        else
	        strcpy(id,"A random PC blathering for no apparent reason");
        
        if (argc>2)
	         ttl=atoi(argv[2]);
	else
		 ttl=32;

	if (argc>3)
		host=resolve(argv[3]);
	else
	        host = resolve("224.2.0.1");

	if (argc>4)
		port=atoi(argv[4]);
	else
		port=3457;



        /* First initialize the header structure */
        header = (struct CtrlMsg *)malloc(sizeof(struct CtrlMsg)+strlen(id));
        memset(header, (int)NULL, sizeof(struct CtrlMsg)+strlen(id));
        header->type=1;
        strcpy(&header->data,id);

        /* And now for the networking */
	sock_init();

	s = (udp_Socket *) &telsock;

	/* Open the UDP connection (?!) */
	if( !udp_open( s, port, host, port, NULL)){
		printf("Unable to open udp connection\n");
		exit(0);
	}

	/* Join the multicast group */
	if( ! join_mcast_group( host ))
	       printf("Unable to join group!!!\n");

	/* Set the TTL */
        udp_SetTTL(s, ttl);

	/* And loop until we get a keypress */
	while ( !kbhit() ){
		tcp_tick(NULL);
		sock_write( s, (byte *)header, sizeof(struct CtrlMsg)+strlen(id));
		printf("Sent an ID of: %s \n",id);
		sleep(5);
	}

sock_err:
	sock_close( s );

	/* Leave the multicast group */
	if( ! leave_mcast_group( host ))
	        printf("Unable to leave group!!!\n");

	exit( 0 );
}






