#include "colors.h"
#include "screen.h"
#include "vt.h"

#define MAXARGS         16
#define MAXBUFLEN       16

static char  AB[61] = "ANSWER BACK";
static char  TabStop[80];
static int   InCode;
static char  Buf[MAXBUFLEN];
static char* BP;
static int   Arg[MAXARGS];
static int   Count;
static int   Origin = 0;
static int   Reverse;
static int   SaveR;
static int   SaveC;
static int   SaveColor;
static char* GraphSet[4];
static int   GR;
static int   GL;
static int   Shift;
static int   INS = 0;
static int   Extend;
static int   Output;
static int   DefaultColor = LIGHTGRAY;
static int   Mode = VT102;

unsigned char DGTab[128] =
{
     0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
    16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
    32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
    48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
   '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
   'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[','\\', ']', '^',  32,
   '', '',  26, '',  27, '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',  32
};

typedef struct
{
   int   mode;
   int   code;
   char* pattern;
} VTCODE;

enum {
        CURUP, CURDOWN, CURLEFT, CURRIGHT, CURLOC, CURLOCREL, CURSAVE, CURRESTORE,
        CLRDISPLAY, CLRLINE, INSLINE, DELLINE, ERASECHAR, INSCHAR, DELCHAR,
        SETREGION, CLEARTAB, CLEARALLTABS, SETTAB, CLRREGION,
        INDEX, REVINDEX, NEWLINE, CURPRELIN, SCROLLUP, SCROLLDN,
        ATTRIBUTES, SCOFORE, SCOBACK, DOUBLETOP, DOUBLEBOT, NORMAL, WIDE,
        BACKTAB, FORETAB, CURCOLABS, CURCOLREL, CURROWABS, CURROWREL,
        CHARUKG0, CHARUKG1, CHARUSG0, CHARUSG1, CHARGRG0, CHARGRG1,
        CHARR1G0, CHARR1G1, CHARR2G0, CHARR2G1,
        LEDS,
        ENTERGFX, EXITGFX, ENTERVT102, ENTERVT200,
        APPKEYS, NUMKEYS,
        SETMODE, RESETMODE, SETMODEDEC, RESETMODEDEC,
        SHIFT2, SHIFT3, LSHIFT1R, LSHIFT2, LSHIFT2R, LSHIFT3, LSHIFT3R,
        IDENTIFY, RESET,
        SENDREPORT, TESTPATTERN,
        IGNORE, PARTIAL, NOMATCH
     };

VTCODE Code[] =
{
   { VT52|HEATH19,                      CURUP,          "A" },
   { VT52|HEATH19,                      CURDOWN,        "B" },
   { VT52|HEATH19,                      CURRIGHT,       "C" },
   { VT52|HEATH19,                      CURLEFT,        "D" },
   { VT52|HEATH19,                      ENTERGFX,       "F" },
   { VT52|HEATH19,                      EXITGFX,        "G" },
   { VT52|HEATH19,                      CURLOC,         "H" },
   { VT52|HEATH19,                      REVINDEX,       "I" },
   { VT52|HEATH19,                      CLRDISPLAY,     "J" },
   { VT52|HEATH19,                      CLRLINE,        "K" },
   { VT52|HEATH19,                      CURLOC,         "Y-\037-\037" },
   { VT52|HEATH19,                      ENTERVT102,     "<" },
   { HEATH19,                           CLRDISPLAY,     "E" },
   { HEATH19,                           INSLINE,        "L" },
   { HEATH19,                           DELLINE,        "M" },
   { HEATH19,                           DELCHAR,        "N" },
   { HEATH19,                           CURSAVE,        "j" },
   { HEATH19,                           CURRESTORE,     "k" },
   { VT52|HEATH19|VT102|VT200,          IDENTIFY,       "Z" },
   { VT52|HEATH19|VT102|VT200,          APPKEYS,        "=" },
   { VT52|HEATH19|VT102|VT200,          NUMKEYS,        ">" },
   { VT102|VT200|ANSI,                  CLEARTAB,       "[g" },
   { VT102|VT200|ANSI,                  CLEARTAB,       "[0g" },
   { VT102|VT200|ANSI,                  CLEARALLTABS,   "[3g" },
   { VT102|VT200|ANSI,                  SETTAB,         "H" },
   { VT102|VT200|ANSI,                  CURUP,          "[A" },
   { VT102|VT200|ANSI,                  CURDOWN,        "[B" },
   { VT102|VT200|ANSI,                  CURRIGHT,       "[C" },
   { VT102|VT200|ANSI,                  CURLEFT,        "[D" },
   { VT102|VT200|ANSI,                  CURLOC,         "[H" },
   { VT102|VT200|ANSI,                  CURLOC,         "[f" },
   { VT102|VT200|ANSI,                  INDEX,          "D" },
   { VT102|VT200|ANSI,                  NEWLINE,        "E" },
   { VT102|VT200|ANSI,                  REVINDEX,       "M" },
   { VT102|VT200|ANSI,                  CURSAVE,        "7" },
   { VT102|VT200|ANSI,                  CURRESTORE,     "8" },
   { VT102|VT200|ANSI,                  ATTRIBUTES,     "[m" },
   { VT102|VT200|ANSI,                  DOUBLETOP,      "#3" },
   { VT102|VT200|ANSI,                  DOUBLEBOT,      "#4" },
   { VT102|VT200|ANSI,                  NORMAL,         "#5" },
   { VT102|VT200|ANSI,                  WIDE,           "#6" },
   { VT102|VT200|ANSI,                  TESTPATTERN,    "#8" },
   { VT102|VT200|ANSI,                  LEDS,           "[q" },
   { HEATH19|VT102|VT200|ANSI,          CLRDISPLAY,     "[J" },
   { VT102|VT200|ANSI,                  CLRLINE,        "[K" },
   { VT102|VT200|ANSI,                  CLRDISPLAY,     "[?J" },
   { VT102|VT200|ANSI,                  CLRLINE,        "[?K" },
   { VT102|VT200|ANSI,                  SETREGION,      "[r" },
   { VT102|VT200|ANSI,                  SENDREPORT,     "[n" },
   { VT102|VT200|ANSI,                  SENDREPORT,     "[?n" },
   { VT102|VT200|ANSI,                  SETMODE,        "[h" },
   { VT102|VT200|ANSI,                  SETMODEDEC,     "[?h" },
   { VT102|VT200|ANSI,                  RESETMODE,      "[l" },
   { VT102|VT200|ANSI,                  RESETMODEDEC,   "[?l" },
   { HEATH19|VT102|VT200|ANSI,          RESET,          "[z" },
   { VT102|VT200|ANSI,                  RESET,          "[!p" },
   { VT102|VT200|ANSI,                  RESET,          "[y" },
   { VT102|VT200|ANSI,                  RESET,          "c" },
   { VT102|VT200|ANSI,                  IDENTIFY,       "[c" },
   { VT102|VT200|ANSI,                  IDENTIFY,       "z" },
   { VT102|VT200|ANSI,                  CHARUKG0,       "(A" },
   { VT102|VT200|ANSI,                  CHARUKG1,       ")A" },
   { VT102|VT200|ANSI,                  CHARUSG0,       "(B" },
   { VT102|VT200|ANSI,                  CHARUSG1,       ")B" },
   { VT102|VT200|ANSI,                  CHARGRG0,       "(0" },
   { VT102|VT200|ANSI,                  CHARGRG1,       ")0" },
   { VT102|VT200|ANSI,                  CHARR1G0,       "(1" },
   { VT102|VT200|ANSI,                  CHARR1G1,       ")1" },
   { VT102|VT200|ANSI,                  CHARR2G0,       "(2" },
   { VT102|VT200|ANSI,                  CHARR2G1,       ")2" },
   { VT102|VT200|ANSI,                  LSHIFT1R,       "~" },
   { VT102|VT200|ANSI,                  LSHIFT2,        "n" },
   { VT102|VT200|ANSI,                  LSHIFT2R,       "}" },
   { VT102|VT200|ANSI,                  LSHIFT3,        "o" },
   { VT102|VT200|ANSI,                  LSHIFT3R,       "|" },
   { VT102|VT200|ANSI,                  ERASECHAR,      "[X" },
   { VT102|VT200|ANSI,                  INSCHAR,        "[@" },
   { VT102|VT200|ANSI,                  DELCHAR,        "[P" },
   { VT102|VT200|ANSI,                  INSLINE,        "[L" },
   { VT102|VT200|ANSI,                  DELLINE,        "[M" },
   { VT102|VT200|ANSI,                  SHIFT2,         "N" },
   { VT102|VT200|ANSI,                  SHIFT3,         "O" },
   { ANSI,                              SCOFORE,        "[=F" },
   { ANSI,                              SCOBACK,        "[=G" },
   { ANSI,                              SCROLLUP,       "[S" },
   { ANSI,                              SCROLLDN,       "[T" },
   { HEATH19|ANSI,                      CURSAVE,        "[s" },
   { HEATH19|ANSI,                      CURRESTORE,     "[u" },
   { ANSI,                              BACKTAB,        "[Z" },
   { ANSI,                              FORETAB,        "[I" },
   { ANSI,                              CURCOLABS,      "[G" },
   { ANSI,                              CURCOLABS,      "[`" },
   { ANSI,                              CURCOLREL,      "[a" },
   { ANSI,                              CURROWABS,      "[d" },
   { ANSI,                              CURROWREL,      "[e" },
   { ANSI,                              CURPRELIN,      "[F" },
   { ANSI,                              NEWLINE,        "[E" },
   { ANSI,                              CLRREGION,      "[O" },
   { ANSI,                              CURLOCREL,      "[g" },
   { 127,                               ENTERVT102,     "61\"p" },
   { 127,                               ENTERVT200,     "62\"p" },
   { 127,                               IGNORE,         "P" },
   { 127,                               IGNORE,         "\\" },
   { 127,                               IGNORE,         "[\"q" },
   { 127,                               IGNORE,         "[i" },
   { 127,                               IGNORE,         "[?i" },
   { END },
};

void VT_Mode( int i )
{
   Mode = i;
}

void VT_Init()
{
   int i;

   InCode = 0;
   SCR_Init();
   SCR_SetScreenWidth( 80 );
   SCR_SetScreenHeight( 24 + (Mode == ANSI) );
   SCR_DefineRegion( 0, 23 + (Mode == ANSI) );
   SCR_SetColor( DefaultColor );
   SCR_Wrap( (Mode == ANSI) );
   SCR_ScrollColor( (Mode == ANSI) ? -1 : DefaultColor );
   SCR_Clear( 0 );
   Reverse = 0;
   Origin = 0;
   SaveR = 0;
   SaveC = 0;
   SaveColor = DefaultColor;
   GraphSet[0] = 0;
   GraphSet[1] = 0;
   GraphSet[2] = 0;
   GraphSet[3] = 0;
   GR = 0;
   GL = 0;
   Shift = 0;
   INS = 0;
   Extend = 0;
   Output = 1;
   for( i = 0; i < 80; i++ )
   {
      if( i % 8 )
         TabStop[i] = 0;
      else
         TabStop[i] = 1;
   }
   KEY_SetFlag( 0, 0 );  /* NEWLINE */
   if( Mode == VT52 )
      KEY_SetFlag( 1, 2 );
   else
      KEY_SetFlag( 1, 0 );  /* ARROW KEYS */
   if( Mode == VT52 )
      KEY_SetFlag( 2, 2 );
   else
      KEY_SetFlag( 2, 0 );  /* KEYPAD */
   if( Mode == VT52 )
      KEY_SetFlag( 3, 1 );
   else
      KEY_SetFlag( 3, 0 );  /* PF KEYS */
}

void VT_Term()
{
   SCR_Term();
}

int VT_Match( char* vt, char* s )
{
   register i;

   memset( Arg, 0, 2 * MAXARGS );
   Count = 0;
   while( *s && *vt )
   {
      if( *vt == '-' )
      {
         vt++;
         Arg[Count++] = *s - *vt;
         s++;
         vt++;
      }
      else if( *s == *vt )
      {
         s++;
         vt++;
      }
      else if( *vt == '' )
      {
         do
         {
            if( *s == ';' )
            {
               Count++;
               s++;
            }
            while( *s >= '0' && *s <= '9' )
               Arg[Count] = 10 * Arg[Count] + (*s++ - '0');
         }  while( *s == ';' );
         vt++;
      }
      else
         return 0;
   }
   if( *vt )
      return -1;
   return 1;
}

int VT_Lookup( char* pattern )
{
   register i;
   int      m;
   int      r = NOMATCH;

   for( i = 0; Code[i].mode != END; i++ )
   {
      if( Code[i].mode & Mode )
      {
         m = VT_Match( Code[i].pattern, pattern );
         if( m == 1 )
            return Code[i].code;
         if( m == -1 )
            r = PARTIAL;
      }
   }
   return r;
}

int VT_Process( register ch )
{
   int i, c1, c2;
   int b[10];

   if( ch == 27 )
   {
      InCode = 1;
      BP = Buf;
      return;
   }
   if( ch == 127 )
      return;
   if( ch >= 128 && ch <= 159 && Mode != ANSI )
   {
      switch( ch )
      {
         case 129 : i = INDEX;
                    goto skip;
         case 130 : i = NEWLINE;
                    goto skip;
         case 141 : i = REVINDEX;
                    goto skip;
         case 142 : i = SHIFT2;
                    goto skip;
         case 143 : i = SHIFT3;
                    goto skip;
         case 155 : InCode = 1;
                    Buf[0] = '[';
                    BP = Buf + 1;
                    return;
      }
      return;
   }
   if( ch < 32 )
   {
      switch( ch )
      {
         case 5   : if( Mode != ANSI )
                       COM_PutStr( AB );
                    return;
         case 8   : if( Output )
                       SCR_PutChar( 1, '\b' );
                    return;
         case 9   : i = SCR_GetCol( 0 );
                    if( TabStop[i] )
                       i++;
                    while( i < 132 && TabStop[i] == 0 )
                       i++;
                    SCR_GotoRowCol( 0, SCR_GetRow( 0 ), i );
                    return;
         case 11  :
         case 12  : if( Mode == ANSI )
                       return;
         case 10  : SCR_PutChar( 1, '\n' );
                    return;
         case 13  : SCR_PutChar( 1, '\r' );
                    return;
         case 14  : GL = 1;
                    return;
         case 15  : GL = 0;
                    return;
         case 24  : InCode = 0;
                    return;
         case 26  : InCode = 0;
                    if( Output )
                       SCR_PutChar( 1, 168 );
                    return;
         default  : if( Mode != ANSI )
                       return;
      }
   }
   if( InCode && BP < Buf + MAXBUFLEN )
   {
      if( ch == '0' && (*(BP-1) == '[' || *(BP-1) == ';') )
         return;
      *BP++ = ch;
      *BP = 0;
      if( *Buf == '[' && ch <= '9' && ch >= '0' )
         return;
      i = VT_Lookup( Buf );
      if( i == PARTIAL )
         return;
      InCode = 0;
      if( i == NOMATCH )
         return;
skip:
/*
      {
         int x, y;
         x = wherex();
         y = wherey();
         gotoxy( 1, 1 );
         cprintf( "Command = %d (%s)", i, Buf );
         clreol();
         cprintf( "\r\nArgs =" );
         for( c1 = 0; c1 < Count; c1++ )
            cprintf( " %d", Arg[c1] );
         clreol();
         gotoxy( x, y );
         getch();
      }
*/
      switch( i )
      {
         case FORETAB     : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            c1 = SCR_GetCol( 0 );
                            for( i = 0; c1 < 132 && i < Arg[0]; i++ )
                            {
                               if( TabStop[c1] )
                                  c1++;
                               while( c1 < 132 && TabStop[c1] == 0 )
                                  c1++;
                            }
                            SCR_GotoRowCol( 0, SCR_GetRow( 0 ), c1 );
                            return;
         case BACKTAB     : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            c1 = SCR_GetCol( 0 );
                            for( i = 0; c1 && i < Arg[0]; i++ )
                            {
                               if( TabStop[c1] )
                                  c1--;
                               while( c1 && TabStop[c1] == 0 )
                                  c1--;
                            }
                            SCR_GotoRowCol( 0, SCR_GetRow( 0 ), c1 );
                            return;
         case APPKEYS     : if( Mode == VT52 )
                               KEY_SetFlag( 2, 2 );
                            else
                               KEY_SetFlag( 2, 1 );
                            break;
         case NUMKEYS     : KEY_SetFlag( 2, 0 );
                            break;
         case SETTAB      : TabStop[SCR_GetCol( 0 )] = 1;
                            break;
         case CLEARTAB    : TabStop[SCR_GetCol( 0 )] = 0;
                            break;
         case CLEARALLTABS: for( i = 0; i < 132; i++ )
                               TabStop[i] = 0;
                            break;
         case CURUP       : SCR_MoveUp( Arg[0] );
                            break;
         case CURDOWN     : SCR_MoveDown( Arg[0] );
                            break;
         case CURLEFT     : SCR_MoveLeft( Arg[0] );
                            break;
         case CURRIGHT    : SCR_MoveRight( Arg[0] );
                            break;
         case CURLOC      : SCR_GotoRowCol( Origin, Arg[0] - 1, Arg[1] - 1 );
                            break;
         case CURLOCREL   : SCR_GotoRowCol( 1, Arg[0] - 1, Arg[1] - 1 );
                            break;
         case CURCOLABS   : SCR_GotoRowCol( 0, SCR_GetRow( 0 ), Arg[0] );
                            break;
         case CURCOLREL   : SCR_GotoRowCol( 0, SCR_GetRow( 0 ), SCR_GetCol( 0 ) + Arg[0] );
                            break;
         case CURROWABS   : SCR_GotoRowCol( 0, Arg[0], SCR_GetCol( 0 ) );
                            break;
         case CURROWREL   : SCR_GotoRowCol( 0, SCR_GetRow( 0 ) + Arg[0], SCR_GetCol( 0 ) );
                            break;
         case CURSAVE     : SaveR = SCR_GetRow( 0 );
                            SaveC = SCR_GetCol( 0 );
                            SaveColor = SCR_GetColor();
                            break;
         case CURRESTORE  : SCR_GotoRowCol( 0, SaveR, SaveC );
                            SCR_SetColor( SaveColor );
                            break;
         case CLRDISPLAY  : switch( Arg[0] )
                            {
                               case 1  : SCR_ClearBOD( 0 );
                                         break;
                               case 2  : SCR_Clear( 0 );
                                         if( Mode == ANSI )
                                            SCR_GotoRowCol( 0, 0, 0 );
                                         break;
                               default : SCR_ClearEOD( 0 );
                                         break;
                            }
                            break;
         case CLRREGION   : switch( Arg[0] )
                            {
                               case 1  : SCR_ClearBOD( 1 );
                                         break;
                               case 2  : SCR_Clear( 1 );
                                         break;
                               case 3  : SCR_ClearEOD( 1 );
                                         break;
                            }
                            break;
         case CLRLINE     : switch( Arg[0] )
                            {
                               case 1  : SCR_ClearBOL( 0 );
                                         break;
                               case 2  : SCR_ClearBOL( 0 );
                                         SCR_ClearEOL( 0 );
                                         break;
                               default : SCR_ClearEOL( 0 );
                                         break;
                            }
                            break;
         case SCOFORE     : if( Arg[0] > 7 )
                               SCR_SetBold( 1 );
                            else
                               SCR_SetBold( 0 );
                            SCR_SetFore( Arg[0] );
                            DefaultColor = SCR_GetColor();
                            break;
         case SCOBACK     : SCR_SetBack( Arg[0] );
                            DefaultColor = SCR_GetColor();
                            break;
         case ATTRIBUTES  : for( i = 0; i <= Count; i++ )
                               switch( Arg[i] )
                               {
                                  case 10         : Extend = 0;
                                                    break;
                                  case 12         : Extend = 1;
                                                    break;
                                  case 0          : SCR_SetColor( DefaultColor );
                                                    Reverse = 0;
                                                    break;
                                  case 1          : SCR_SetBold( 1 );
                                                    break;
                                  case 5          : SCR_SetBlink( 1 );
                                                    break;
                                  case 7          : if( !Reverse )
                                                    {
                                                       c1 = SCR_GetFore();
                                                       c2 = SCR_GetBack();
                                                       SCR_SetFore( c2 );
                                                       SCR_SetBack( c1 );
                                                       Reverse = 1;
                                                    }
                                                    break;
                                  case 8          : Output = 0;
                                                    break;
                                  case 22         : SCR_SetBold( 0 );
                                                    break;
                                  case 25         : SCR_SetBlink( 0 );
                                                    break;
                                  case 27         : if( Reverse )
                                                    {
                                                       c1 = SCR_GetFore();
                                                       c2 = SCR_GetBack();
                                                       SCR_SetFore( c2 );
                                                       SCR_SetBack( c1 );
                                                       Reverse = 0;
                                                    }
                                                    break;
                                  case 30         : if( Reverse )
                                                       SCR_SetBack( BLACK );
                                                    else
                                                       SCR_SetFore( BLACK );
                                                    break;
                                  case 31         : if( Reverse )
                                                       SCR_SetBack( RED );
                                                    else
                                                       SCR_SetFore( RED );
                                                    break;
                                  case 32         : if( Reverse )
                                                       SCR_SetBack( GREEN );
                                                    else
                                                       SCR_SetFore( GREEN );
                                                    break;
                                  case 33         : if( Reverse )
                                                       SCR_SetBack( BROWN );
                                                    else
                                                       SCR_SetFore( BROWN );
                                                    break;
                                  case 34         : if( Reverse )
                                                       SCR_SetBack( BLUE );
                                                    else
                                                       SCR_SetFore( BLUE );
                                                    break;
                                  case 35         : if( Reverse )
                                                       SCR_SetBack( MAGENTA );
                                                    else
                                                       SCR_SetFore( MAGENTA );
                                                    break;
                                  case 36         : if( Reverse )
                                                       SCR_SetBack( CYAN );
                                                    else
                                                       SCR_SetFore( CYAN );
                                                    break;
                                  case 37         : if( Reverse )
                                                       SCR_SetBack( LIGHTGRAY );
                                                    else
                                                       SCR_SetFore( LIGHTGRAY );
                                                    break;
                                  case 39         : if( Reverse )
                                                       SCR_SetBack( DefaultColor & 7 );
                                                    else
                                                       SCR_SetFore( DefaultColor & 7 );
                                                    break;
                                  case 40         : if( Reverse )
                                                       SCR_SetFore( BLACK );
                                                    else
                                                       SCR_SetBack( BLACK );
                                                    break;
                                  case 41         : if( Reverse )
                                                       SCR_SetFore( RED );
                                                    else
                                                       SCR_SetBack( RED );
                                                    break;
                                  case 42         : if( Reverse )
                                                       SCR_SetFore( GREEN );
                                                    else
                                                       SCR_SetBack( GREEN );
                                                    break;
                                  case 43         : if( Reverse )
                                                       SCR_SetFore( BROWN );
                                                    else
                                                       SCR_SetBack( BROWN );
                                                    break;
                                  case 44         : if( Reverse )
                                                       SCR_SetFore( BLUE );
                                                    else
                                                       SCR_SetBack( BLUE );
                                                    break;
                                  case 45         : if( Reverse )
                                                       SCR_SetFore( MAGENTA );
                                                    else
                                                       SCR_SetBack( MAGENTA );
                                                    break;
                                  case 46         : if( Reverse )
                                                       SCR_SetFore( CYAN );
                                                    else
                                                       SCR_SetBack( CYAN );
                                                    break;
                                  case 47         : if( Reverse )
                                                       SCR_SetFore( LIGHTGRAY );
                                                    else
                                                       SCR_SetBack( LIGHTGRAY );
                                                    break;
                                  case 49         : if( Reverse )
                                                       SCR_SetFore( (DefaultColor & 112) >> 4 );
                                                    else
                                                       SCR_SetBack( (DefaultColor & 112) >> 4 );
                                                    break;
                               }
                            break;
         case SETREGION   : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            if( Arg[1] < 1 )
                               Arg[1] = 1;
                            if( Arg[0] < Arg[1] )
                            {
                               SCR_DefineRegion( Arg[0] - 1, Arg[1] - 1 );
                               SCR_GotoRowCol( Origin, 0, 0 );
                            }
                            else
                            {
                               SCR_DefineRegion( 0, 23 );
                               SCR_GotoRowCol( Origin, 0, 0 );
                            }
                            break;
         case SCROLLUP    : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            SCR_Scroll( 1, SCROLL_UP, Arg[0] );
                            break;
         case SCROLLDN    : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            SCR_Scroll( 1, SCROLL_DOWN, Arg[0] );
                            break;
         case NEWLINE     : SCR_PutChar( 1, '\r' );
         case INDEX       : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            if( !SCR_MoveDown( Arg[0] ) )
                               SCR_Scroll( 1, SCROLL_UP, 1 );
                            break;
         case CURPRELIN   : SCR_PutChar( 1, '\r' );
         case REVINDEX    : if( Arg[0] < 1 )
                               Arg[0] = 1;
                            if( !SCR_MoveUp( Arg[0] ) )
                               SCR_Scroll( 1, SCROLL_DOWN, 1 );
                            break;
         case SENDREPORT  : for( i = 0; i <= Count; i++ )
                            {
                               switch( Arg[i] )
                               {
                                  case 5  : COM_PutStr( "\033[0n" );
                                            break;
                                  case 6  : sprintf( b, "\033[%d;%dR", SCR_GetRow( 0 ) + 1, SCR_GetCol( 0 ) + 1 );
                                            COM_PutStr( b );
                                            break;
                                  case 15 : COM_PutStr( "\033[13n" );
                                            break;
                               }
                            }
                            break;
         case SETMODE     : for( i = 0; i <= Count; i++ )
                            {
                               switch( Arg[i] )
                               {
                                  case 4  : INS = 1;
                                            break;
                                  case 20 : KEY_SetFlag( 0, 1 );
                                            break;
                               }
                            }
                            break;
         case RESETMODE   : for( i = 0; i <= Count; i++ )
                            {
                               switch( Arg[i] )
                               {
                                  case 4  : INS = 0;
                                            break;
                                  case 20 : KEY_SetFlag( 0, 0 );
                                            break;
                               }
                            }
                            break;
         case SETMODEDEC  : for( i = 0; i <= Count; i++ )
                            {
                               switch( Arg[i] )
                               {
                                  case 1  : if( Mode != VT52 )
                                               KEY_SetFlag( 1, 1 );
                                            break;
                                  case 2  : Mode = VT102;
                                            /*
                                            KEY_SetFlag( 1, 2 );
                                            KEY_SetFlag( 2, 0 );
                                            KEY_SetFlag( 3, 1 );
                                            */
                                            break;
                                  case 6  : Origin = 1;
                                            SCR_GotoRowCol( Origin, 0, 0 );
                                            break;
                                  case 7  : SCR_Wrap( 1 );
                                            break;
                                  case 25 : SCR_LineCursor();
                                            break;
                               }
                            }
                            break;
         case RESETMODEDEC: for( i = 0; i <= Count; i++ )
                            {
                               switch( Arg[i] )
                               {
                                  case 1  : if( Mode != VT52 )
                                               KEY_SetFlag( 1, 0 );
                                            break;
                                  case 2  : Mode = VT52;
                                            KEY_SetFlag( 1, 2 );
                                            KEY_SetFlag( 2, 0 );
                                            KEY_SetFlag( 3, 1 );
                                            break;
                                  case 6  : Origin = 0;
                                            SCR_GotoRowCol( Origin, 0, 0 );
                                            break;
                                  case 7  : SCR_Wrap( 0 );
                                            break;
                                  case 25 : SCR_NoCursor();
                                            break;
                               }
                            }
                            break;
         case INSCHAR     : SCR_InsertChar( Arg[0], ' ' );
                            break;
         case DELCHAR     : SCR_DeleteChar( Arg[0] );
                            break;
         case INSLINE     : SCR_InsertLine( 1, Arg[0] );
                            break;
         case DELLINE     : SCR_DeleteLine( 1, Arg[0] );
                            break;
         case ERASECHAR   : SCR_EraseChars( Arg[0] );
                            break;
         case ENTERGFX    : GraphSet[0] = DGTab;
                            break;
         case EXITGFX     : GraphSet[0] = 0;
                            break;
         case CHARUKG0    : GraphSet[0] = 0;
                            break;
         case CHARUKG1    : GraphSet[1] = 0;
                            break;
         case CHARUSG0    : GraphSet[0] = 0;
                            break;
         case CHARUSG1    : GraphSet[1] = 0;
                            break;
         case CHARGRG0    : GraphSet[0] = DGTab;
                            break;
         case CHARGRG1    : GraphSet[1] = DGTab;
                            break;
         case ENTERVT102  : Mode = VT102;
                            KEY_SetFlag( 1, 0 );
                            KEY_SetFlag( 2, 0 );
                            KEY_SetFlag( 3, 0 );
                            break;
         case ENTERVT200  : Mode = VT200;
                            KEY_SetFlag( 1, 0 );
                            KEY_SetFlag( 2, 0 );
                            KEY_SetFlag( 3, 0 );
                            break;
         case SHIFT2      : Shift = 2;
                            break;
         case SHIFT3      : Shift = 3;
                            break;
         case LSHIFT1R    : GR = 1;
                            break;
         case LSHIFT2     : GL = 2;
                            break;
         case LSHIFT2R    : GR = 2;
                            break;
         case LSHIFT3     : GL = 3;
                            break;
         case LSHIFT3R    : GR = 3;
                            break;
         case IDENTIFY    : switch( Mode )
                            {
                               case VT52       : COM_PutStr( "\033/Z" );
                                                 break;
                               case HEATH19    : COM_PutStr( "\033/K" );
                                                 break;
                               case VT102      : COM_PutStr( "\033[?6c" );
                                                 break;
                               default         : COM_PutStr( "\033[?1;2c" );
                                                 break;
                            }
                            break;
         case TESTPATTERN : SCR_Fill( 0, 0, 79, 23, 'E', DefaultColor );
                            break;
         case RESET       : VT_Term();
                            VT_Init();
                            break;
      }
   }
   else
   {
      if( Extend )
         ch |= 128;
      if( Shift == 0 )
         Shift = GL;
      if( ch < 128 )
      {
         if( GraphSet[Shift] )
            ch = GraphSet[Shift][ch];
      }
      else
      {
         if( GraphSet[Shift] )
            ch = GraphSet[Shift][ch - 128];
      }
      Shift = 0;
      if( INS )
         SCR_InsertChar( 1, ' ' );
      if( Output )
         SCR_PutChar( 1, ch );
      if( (ch == 10 || ch == 11 || ch == 12) && KEY_GetFlag( 0 ) )
         SCR_PutChar( 1, '\r' );
   }
}

