#!/usr/local/bin/perl

# edit this to the printer hostname
$them = 'printer';
$port = 9100;

open(STDIN, "@ARGV[0]") if $#ARGV >= 0;

require 'sys/socket.ph';

$sockaddr = 'S n a4 x8';
chop($hostname = `hostname`);

($name, $aliases, $proto) = getprotobyname('tcp');
($name, $aliases, $port) = getservbyname($port, 'tcp')
	unless $port =~ /^\d+$/;
($name, $aliases, $type, $len, $thisaddr) = gethostbyname($hostname);
($name, $aliases, $type, $len, $thataddr) = gethostbyname($them);

socket(S, &PF_INET, &SOCK_STREAM, $proto) || &errexit("socket: $!\n");

$this = pack($sockaddr, &AF_INET, 0, $thisaddr);
bind(S, $this) || &errexit("bind: $!\n");

$that = pack($sockaddr, &AF_INET, $port, $thataddr);
connect(S, $that) || &errexit("connect: $!\n");

select(S); $| = 1; select(stdout);

while (1)
{
	$nread = read(STDIN, $buffer, 1024);
	last if $nread == 0;
	&errexit("write: $!\n") unless
		defined($written = syswrite(S,$buffer,$nread));
}
close(S);
exit 0;

sub errexit
{
	print STDERR @_;
	exit 2;
}
